/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rocket.impl.factory;

import com.dtyunxi.huieryun.mq.provider.rocket.impl.config.RocketClientConfig;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketProducerFactory {
    private static Logger logger = LoggerFactory.getLogger(RocketProducerFactory.class);
    public static ConcurrentHashMap<String, DefaultMQProducer> producerMap = new ConcurrentHashMap();

    public static void initProducer(MessageRegistryVo topicInfo) {
        DefaultMQProducer producer = new DefaultMQProducer(topicInfo.getTopicName());
        producer.setVipChannelEnabled(false);
        RocketProducerFactory.restConfig(topicInfo, producer);
        logger.info("create rocket producer success,{}", (Object)producer);
        producerMap.put(topicInfo.getTopicName(), producer);
    }

    public static DefaultMQProducer getRocketProducer(MessageRegistryVo topicInfo) {
        if (producerMap.get(topicInfo.getTopicName()) == null) {
            RocketProducerFactory.initProducer(topicInfo);
        }
        return producerMap.get(topicInfo.getTopicName());
    }

    private static void restConfig(MessageRegistryVo topicInfo, DefaultMQProducer producer) {
        producer.setVipChannelEnabled(false);
        producer.resetClientConfig(RocketClientConfig.getClientConfig(topicInfo));
        producer.setDefaultTopicQueueNums(4);
        producer.setSendMsgTimeout(10000);
        producer.setCompressMsgBodyOverHowmuch(4096);
        producer.setRetryAnotherBrokerWhenNotStoreOK(false);
        producer.setProducerGroup(StringUtils.isNotEmpty((CharSequence)topicInfo.getGroupName()) ? topicInfo.getGroupName() : topicInfo.getTopicName());
    }
}

