/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.huieryun.mq.api.AbstractMQService;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQFactory {
    private static final Logger logger = LoggerFactory.getLogger(MQFactory.class);

    public static IMQService createMQ(MessageRegistryVo messageRegistryVo) {
        AbstractMQService mqService = null;
        if (messageRegistryVo != null && messageRegistryVo.getType() != null) {
            MessageType messageType = MessageType.valueOf(messageRegistryVo.getType().toUpperCase());
            if (null == messageType) {
                throw new IllegalArgumentException("\u672a\u6307\u5b9aMQService\u7c7b\u578b");
            }
            switch (messageType) {
                case ALIYUN: {
                    mqService = MQFactory.initializeMQService("com.dtyunxi.huieryun.mq.provider.aliyun.AliyunMQ");
                    break;
                }
                case RABBIT: {
                    mqService = MQFactory.initializeMQService("com.dtyunxi.huieryun.mq.provider.rabbit.RabbitMQ");
                    break;
                }
                case KAFKA: {
                    mqService = MQFactory.initializeMQService("com.dtyunxi.huieryun.mq.provider.kafka.KafkaMQ");
                    break;
                }
                case ROCKET: {
                    mqService = MQFactory.initializeMQService("com.dtyunxi.huieryun.mq.provider.rocket.RocketMQ");
                }
            }
        }
        if (mqService == null) {
            throw new IllegalArgumentException("\u672a\u6307\u5b9aMQService\u7c7b\u578b");
        }
        mqService.init(messageRegistryVo);
        return mqService;
    }

    private static AbstractMQService initializeMQService(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, MQFactory.class.getClassLoader());
            return (AbstractMQService)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("{}\u7c7b\u672a\u627e\u5230\uff01", (Object)className, (Object)e);
            throw new RuntimeException(className + "\u7c7b\u672a\u627e\u5230\uff01");
        }
    }
}

