/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.obs;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.api.IObjectInputStreamProcessor;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.provider.obs.vo.HuaweiStsResponse;
import com.dtyunxi.huieryun.oss.util.HttpUtils;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class HuaweiObjectStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiObjectStorage.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private ObsClient obsClient;
    private static String STS_URL = "https://iam.myhuaweicloud.com/v3.0/OS-CREDENTIAL/securitytokens/v3.0/OS-CREDENTIAL/securitytokens";
    private static String STS_REQ = "{\n    \"auth\": {\n        \"identity\": {\n            \"methods\": [\n                \"token\"\n            ],\n            \"token\": {\n                \"id\": \"{{token}}\",\n                \"duration-seconds\": {{duration}}\n            }\n        }\n    }\n}";

    protected AccessControlList getAccessControlList() {
        switch (this.ossRegistryVo.getAcl()) {
            case "private": {
                return AccessControlList.REST_CANNED_PRIVATE;
            }
            case "public-read-write": {
                return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
            }
        }
        return AccessControlList.REST_CANNED_PUBLIC_READ;
    }

    public String put(String bucketName, String objectName, InputStream inputstream) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        String fileUri = this.getSaveFileUri(objectName);
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(fileUri);
        request.setInput(inputstream);
        request.setAcl(this.getAccessControlList());
        PutObjectResult result = this.obsClient.putObject(request);
        return result.getObjectUrl();
    }

    public void delete(String bucketName, String objectName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        this.obsClient.deleteObject(bucketName, objectName);
    }

    public boolean exists(String bucketName, String objectName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        return this.obsClient.doesObjectExist(bucketName, objectName);
    }

    public OutputStream get(String fileURI) {
        OutputStream outputStream = null;
        outputStream = fileURI.indexOf("huaweicloud.com") != -1 ? this.getOutputStreamByUrl(fileURI) : this.get(fileURI, this.ossRegistryVo.getBucketName());
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getOutputStreamByUrl(String fileUrl) {
        ByteArrayOutputStream outputStream = null;
        HttpURLConnection connection = null;
        try {
            URL endpointUrl = new URL(fileUrl);
            connection = HttpUtils.createHttpConnection((URL)endpointUrl, (String)"GET", null);
            InputStream is = connection.getInputStream();
            outputStream = this.getByteArrayOutputStream(is);
        }
        catch (Exception e) {
            logger.error("error getOutputStreamByUrl : ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getByteArrayOutputStream(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int lenght = 0;
        try {
            while ((lenght = is.read(buffer)) != -1) {
                out.write(buffer, 0, lenght);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close InputStream :", (Throwable)e);
            }
        }
        return out;
    }

    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        TemporarySignatureRequest req = new TemporarySignatureRequest(HttpMethodEnum.GET, (long)(this.ossRegistryVo.getExpireHour() * 3600));
        req.setBucketName(this.ossRegistryVo.getBucketName());
        req.setObjectKey(fileURI);
        TemporarySignatureResponse res = this.obsClient.createTemporarySignature(req);
        return res.getActualSignedRequestHeaders();
    }

    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        TemporarySignatureRequest req = new TemporarySignatureRequest(HttpMethodEnum.GET, (long)(expiresIn * 3600));
        req.setBucketName(this.ossRegistryVo.getBucketName());
        req.setObjectKey(fileURI);
        TemporarySignatureResponse res = this.obsClient.createTemporarySignature(req);
        return res.getSignedUrl();
    }

    public OutputStream get(String key, String bucketName) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        ObsObject obsObject = this.obsClient.getObject(bucketName, key);
        return this.getOutputStreamByKey(obsObject);
    }

    private OutputStream getOutputStreamByKey(ObsObject ossObject) {
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            logger.error("Cannot read object content stream: ", (Throwable)ex);
            throw new RuntimeException("CannotReadContentStream", ex);
        }
        finally {
            HuaweiObjectStorage.safeClose(outputStream);
            HuaweiObjectStorage.safeClose(ossObject.getObjectContent());
        }
        return outputStream;
    }

    public void get(String objectName, String bucketName, IObjectInputStreamProcessor processor) {
        if (StrUtil.isBlank((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        if (objectName.indexOf("huaweicloud.com") == -1) {
            ObsObject obsObject = null;
            try {
                obsObject = this.obsClient.getObject(bucketName, objectName);
                processor.process(obsObject.getObjectContent());
            }
            catch (ObsException obsException) {
            }
            catch (Throwable ex) {
                logger.error("Cannot read object content stream: ", ex);
                throw new RuntimeException("CannotReadContentStream", ex);
            }
            finally {
                if (obsObject != null) {
                    HuaweiObjectStorage.safeClose(obsObject.getObjectContent());
                }
            }
        }
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Map<String, String> createPolicy(OssRegistryVo ossRegistryVo, String fileType) {
        PostSignatureRequest request = new PostSignatureRequest();
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("x-obs-acl", ossRegistryVo.getAcl());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType})) {
            formParams.put("content-type", fileType);
        }
        request.setFormParams(formParams);
        request.setExpires((long)(ossRegistryVo.getExpireHour() * 3600));
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        String formAction = this.getFormAction(ossRegistryVo);
        respMap.put("form-action", formAction);
        try {
            PostSignatureResponse response = this.obsClient.createPostSignature(request);
            respMap.put("x-obs-acl", "public-read");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType})) {
                respMap.put("content-type", fileType);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ossRegistryVo.getDir()})) {
                respMap.put("key", ossRegistryVo.getDir());
            }
            respMap.put("policy", response.getPolicy());
            respMap.put("AccessKeyId", ossRegistryVo.getAccessKeyId());
            respMap.put("signature", response.getSignature());
        }
        catch (ObsException e1) {
            logger.error("Compute Signature Failure:", (Throwable)e1);
            throw new RuntimeException("Compute Signature Failure:", e1);
        }
        return respMap;
    }

    protected String getFormAction(OssRegistryVo ossRegistryVo) {
        String formAction = ossRegistryVo.getEndpoint();
        if (formAction.startsWith("https://")) {
            return formAction;
        }
        return String.format("https://%s.%s", ossRegistryVo.getBucketName(), formAction);
    }

    public void init(OssRegistryVo ossRegistryVo, ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
        this.ossRegistryVo = ossRegistryVo;
        if (ossRegistryVo.getEndpoint().startsWith("https://" + ossRegistryVo.getBucketName())) {
            String endpoint = ossRegistryVo.getEndpoint().replace("https://" + ossRegistryVo.getBucketName() + ".", "https://");
            this.obsClient = new ObsClient(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret(), endpoint);
        } else {
            this.obsClient = new ObsClient(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret(), ossRegistryVo.getEndpoint());
        }
    }

    public Map<String, String> createSts(OssRegistryVo registryVo, TempSignCreateParam tempSignCreateParam) {
        Long durationSecond = tempSignCreateParam == null || tempSignCreateParam.getDurationSecond() <= 0L ? Long.valueOf(60L) : Long.valueOf(tempSignCreateParam.getDurationSecond());
        String srcToken = tempSignCreateParam.getToken();
        if (StringUtils.isBlank((CharSequence)srcToken)) {
            throw new RuntimeException("tempSignCreateParam.token could not be blank");
        }
        String reqBody = STS_REQ.replace("{{token}}", srcToken).replace("{{duration}}", durationSecond.toString());
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(STS_URL);
        StringEntity entity = null;
        try {
            entity = new StringEntity(reqBody);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response != null && response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                try {
                    String responseBody = EntityUtils.toString((HttpEntity)entity);
                    HuaweiStsResponse parse = (HuaweiStsResponse)JSON.parseObject((String)responseBody, HuaweiStsResponse.class);
                    return parse.getCredential();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException("http req fail, url=" + STS_URL);
        }
        try {
            client.close();
        }
        catch (IOException e) {
            logger.info("", (Throwable)e);
        }
        return null;
    }

    public Logger getLogger() {
        return logger;
    }
}

