/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.amazonaws.auth;

import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerBase;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWS4SignerForQueryParameterAuth
extends AWS4SignerBase {
    private static final Logger logger = LoggerFactory.getLogger(AWS4SignerForQueryParameterAuth.class);
    private static final String BACKSLASH = "/";

    public AWS4SignerForQueryParameterAuth(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
        this.dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        this.dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWS4SignerForQueryParameterAuth.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4SignerForQueryParameterAuth.getCanonicalizedHeaderString(headers);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + BACKSLASH + this.regionName + BACKSLASH + this.serviceName + BACKSLASH + "aws4_request";
        queryParameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        queryParameters.put("X-Amz-Credential", awsAccessKey + BACKSLASH + scope);
        queryParameters.put("X-Amz-Date", dateTimeStamp);
        queryParameters.put("X-Amz-SignedHeaders", canonicalizedHeaderNames);
        String canonicalizedQueryParameters = AWS4SignerForQueryParameterAuth.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4SignerForQueryParameterAuth.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        logger.debug("--------- Canonical request --------");
        logger.debug(canonicalRequest);
        logger.debug("------------------------------------");
        String stringToSign = AWS4SignerForQueryParameterAuth.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        logger.debug("--------- String to sign -----------");
        logger.debug(stringToSign);
        logger.debug("------------------------------------");
        String signature = this.getHmacSHA256Signature(awsSecretKey, dateStamp, stringToSign);
        return this.getAuthString(queryParameters, signature);
    }

    private String getAuthString(Map<String, String> queryParameters, String signature) {
        StringBuilder authString = new StringBuilder();
        authString.append("X-Amz-Algorithm=" + queryParameters.get("X-Amz-Algorithm"));
        authString.append("&X-Amz-Credential=" + queryParameters.get("X-Amz-Credential"));
        authString.append("&X-Amz-Date=" + queryParameters.get("X-Amz-Date"));
        authString.append("&X-Amz-Expires=" + queryParameters.get("X-Amz-Expires"));
        authString.append("&X-Amz-SignedHeaders=" + queryParameters.get("X-Amz-SignedHeaders"));
        authString.append("&X-Amz-Signature=" + signature);
        return authString.toString();
    }
}

