/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerBase;
import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerForAuthorizationHeader;
import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerForPolicy;
import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerForQueryParameterAuth;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.BinaryUtils;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.HttpUtils;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3ObjectStorage
extends AbstractObjectStorageService {
    private static final String BACKSLASH = "/";
    private static final Logger logger = LoggerFactory.getLogger(AmazonS3ObjectStorage.class);
    private static final SimpleDateFormat SF_ISO_DATE = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final String X_AMZ_ALGORITHM = "AWS4-HMAC-SHA256";

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        Map<String, String> headers;
        byte[] objectContent = this.getByteArrayOutputStream(inputstream).toByteArray();
        String fileURI = this.getSaveFilePath(key);
        URL endpointUrl = this.getEndPointUrl(fileURI);
        String amazonResponse = HttpUtils.invokeHttpRequest(endpointUrl, "PUT", headers = this.createPutFileSignerHeader(objectContent, endpointUrl), objectContent);
        if (!amazonResponse.trim().isEmpty()) {
            throw new RuntimeException(String.format("Put File to Amazon S3 Failure,Amazon S3 Server Response Message:%s", amazonResponse));
        }
        return fileURI;
    }

    private Map<String, String> createPutFileSignerHeader(byte[] objectContent, URL endpointUrl) {
        byte[] contentHash = AWS4SignerBase.hash(objectContent);
        String contentHashString = BinaryUtils.toHex(contentHash);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-amz-content-sha256", contentHashString);
        headers.put("content-length", String.valueOf(objectContent.length));
        headers.put("x-amz-storage-class", "REDUCED_REDUNDANCY");
        AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(endpointUrl, "PUT", "s3", this.ossRegistryVo.getRegionName());
        String authorization = signer.computeSignature(headers, null, contentHashString, this.ossRegistryVo.getAccessKeyId(), this.ossRegistryVo.getAccessKeySecret());
        headers.put("Authorization", authorization);
        return headers;
    }

    private String getSaveFilePath(String fileName) {
        StringBuilder builder = new StringBuilder(BACKSLASH);
        builder.append(this.ossRegistryVo.getBucketName());
        builder.append(BACKSLASH);
        builder.append(this.ossRegistryVo.getDir());
        builder.append(fileName);
        return builder.toString();
    }

    @Override
    public void delete(String group, String key) {
    }

    @Override
    public boolean exists(String group, String key) {
        return false;
    }

    @Override
    public Map<String, String> creatPoliy() {
        long currentTime = System.currentTimeMillis();
        String xAmzDate = SF_ISO_DATE.format(currentTime);
        AWS4SignerForPolicy aWS4SignerForPolicy = new AWS4SignerForPolicy("s3", this.ossRegistryVo.getRegionName());
        String xAmzCredential = aWS4SignerForPolicy.getXAmzCredential(currentTime, this.ossRegistryVo.getAccessKeyId());
        String policy = aWS4SignerForPolicy.getPolicy(this.ossRegistryVo.getBucketName(), this.ossRegistryVo.getDir(), this.ossRegistryVo.getAcl(), xAmzCredential, currentTime);
        String signature = aWS4SignerForPolicy.computeSignature(this.ossRegistryVo.getAccessKeySecret(), policy, currentTime);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("form-action", this.ossRegistryVo.getEndpoint() + BACKSLASH + this.ossRegistryVo.getBucketName());
        respMap.put("x-amz-signature", signature);
        respMap.put("policy", policy);
        respMap.put("x-amz-date", xAmzDate);
        respMap.put("x-amz-algorithm", X_AMZ_ALGORITHM);
        respMap.put("x-amz-credential", xAmzCredential);
        respMap.put("acl", this.ossRegistryVo.getAcl());
        respMap.put("key", this.ossRegistryVo.getDir());
        return respMap;
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("X-Amz-Expires", "" + expiresIn);
        URL endpointUrl = this.getEndPointUrl(fileURI);
        HashMap<String, String> headers = new HashMap<String, String>();
        AWS4SignerForQueryParameterAuth signer = new AWS4SignerForQueryParameterAuth(endpointUrl, "GET", "s3", this.ossRegistryVo.getRegionName());
        String authorizationQueryParameters = signer.computeSignature(headers, queryParams, "UNSIGNED-PAYLOAD", this.ossRegistryVo.getAccessKeyId(), this.ossRegistryVo.getAccessKeySecret());
        return endpointUrl.toString() + "?" + authorizationQueryParameters;
    }

    @Override
    public OutputStream get(String fileURI) {
        URL endpointUrl = this.getEndPointUrl(fileURI);
        Map<String, String> headers = this.createGetFileSignerHeader(endpointUrl);
        return this.getFileOutput(endpointUrl, headers);
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        URL endpointUrl = this.getEndPointUrl(fileURI);
        return this.createGetFileSignerHeader(endpointUrl);
    }

    private URL getEndPointUrl(String fileURI) {
        try {
            if (fileURI.startsWith(this.ossRegistryVo.getEndpoint())) {
                return new URL(fileURI);
            }
            return new URL(this.ossRegistryVo.getEndpoint() + fileURI);
        }
        catch (MalformedURLException e) {
            logger.error("Unable to parse filename: ", (Throwable)e);
            throw new RuntimeException("Unable to parse filename: " + e.getMessage());
        }
    }

    private Map<String, String> createGetFileSignerHeader(URL endpointUrl) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(endpointUrl, "GET", "s3", this.ossRegistryVo.getRegionName());
        String authorization = signer.computeSignature(headers, null, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", this.ossRegistryVo.getAccessKeyId(), this.ossRegistryVo.getAccessKeySecret());
        headers.put("Authorization", authorization);
        return headers;
    }

    private OutputStream getFileOutput(URL endpointUrl, Map<String, String> headers) {
        InputStream is;
        HttpURLConnection connection = HttpUtils.createHttpConnection(endpointUrl, "GET", headers);
        try {
            is = connection.getInputStream();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
        ByteArrayOutputStream out = this.getByteArrayOutputStream(is);
        connection.disconnect();
        return out;
    }

    private ByteArrayOutputStream getByteArrayOutputStream(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int lenght = 0;
        try {
            while ((lenght = is.read(buffer)) != -1) {
                out.write(buffer, 0, lenght);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close InputStream :", (Throwable)e);
            }
        }
        return out;
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        InputStream inStream = null;
        HttpURLConnection conn = null;
        String result = null;
        try {
            URL url = new URL(fileUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inStream = conn.getInputStream();
            result = this.put(group, key, inStream);
        }
        catch (Exception e) {
            logger.error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo registryVo) {
        return this.creatPoliy();
    }

    @Override
    public OutputStream get(String key, String bucketName) {
        return this.get(key);
    }
}

