/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.api;

import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.enums.ObjectStorageType;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.huieryun.oss.vo.OssThreadPoolRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ObjectStorageFactory {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStorageFactory.class);
    private static final ConcurrentMap<ObjectStorageType, AbstractObjectStorageService> objectStorageServices = new ConcurrentHashMap<ObjectStorageType, AbstractObjectStorageService>(4);

    public static IObjectStorageService createObjectStorage(OssRegistryVo ossRegistryVo) {
        AbstractObjectStorageService objectStorageService;
        String className;
        if (null == ossRegistryVo.getOssType()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b\u4e3a\u7a7a\uff01");
        }
        ObjectStorageType type = ObjectStorageType.valueOf(ossRegistryVo.getOssType().toUpperCase());
        if (null == type) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b");
        }
        if (objectStorageServices.containsKey((Object)type)) {
            return (IObjectStorageService)objectStorageServices.get((Object)type);
        }
        switch (type) {
            case ALIYUNOSS: {
                className = "com.dtyunxi.huieryun.oss.provider.oss.AliyunObjectStorage";
                break;
            }
            case JDCLOUDS3: 
            case AMAZONS3: {
                className = "com.dtyunxi.huieryun.oss.provider.aws.AmazonS3ObjectStorage";
                break;
            }
            case MINIO: {
                className = "com.dtyunxi.huieryun.oss.provider.minio.MinioObjectStorage";
                break;
            }
            case HUAWEIOBS: {
                className = "com.dtyunxi.huieryun.oss.provider.obs.HuaweiObjectStorage";
                break;
            }
            default: {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b");
            }
        }
        try {
            objectStorageService = (AbstractObjectStorageService)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u60e0\u5c14\u4e91\u5bf9\u8c61\u5b58\u50a8\u5b9e\u73b0\u7c7b\uff1a" + className);
        }
        catch (ClassNotFoundException e) {
            throw new BusinessRuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u60e0\u5c14\u4e91\u5bf9\u8c61\u5b58\u50a8\u5b9e\u73b0\u7c7b\uff1a" + className);
        }
        objectStorageService.init(ossRegistryVo, ObjectStorageFactory.createOssThreadPool(ossRegistryVo));
        objectStorageServices.put(type, objectStorageService);
        return objectStorageService;
    }

    private static ThreadPoolTaskExecutor createOssThreadPool(OssRegistryVo ossRegistryVo) {
        OssThreadPoolRegistryVo ossThreadPoolRegistryVo = ossRegistryVo.getOssThreadPoolRegistryVo();
        if (null == ossThreadPoolRegistryVo) {
            ossThreadPoolRegistryVo = new OssThreadPoolRegistryVo();
        }
        ThreadPoolTaskExecutor threadPool = new ThreadPoolTaskExecutor();
        threadPool.setCorePoolSize(ossThreadPoolRegistryVo.getCorePoolSize());
        threadPool.setMaxPoolSize(ossThreadPoolRegistryVo.getMaxPoolSize());
        threadPool.setQueueCapacity(ossThreadPoolRegistryVo.getQueueCapacity());
        threadPool.setKeepAliveSeconds(ossThreadPoolRegistryVo.getKeepAliveSeconds());
        switch (ossThreadPoolRegistryVo.getFullPoolRejectedPolicy()) {
            case ABORT: {
                threadPool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case DISCARD: {
                threadPool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
                break;
            }
            case DISCARD_OLDEST: {
                threadPool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
            default: {
                threadPool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            }
        }
        threadPool.initialize();
        return threadPool;
    }
}

