/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.rest;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.ObjectStorageFactory;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/huieryun/objectstorage/policy"})
@Api(value="/v1/huieryun/objectstorage/policy", description="\u83b7\u53d6OSS\u7684\u8bbf\u95ee\u8bb8\u53ef")
public class OssPolicyController {
    private static Logger logger = LoggerFactory.getLogger(OssPolicyController.class);
    private static final Pattern GET_HOST_FROM_ENDPIONT = Pattern.compile("(http://|https://)?([a-zA-Z\\-0-9]+).([a-zA-Z\\-0-9.]+)");
    private String policy = "{\"Statement\": [{\"Action\": [\"oss:GetObject\",\"oss:PutObject\",\"oss:DeleteObject\",\"oss:ListParts\",\"oss:AbortMultipartUpload\",\"oss:ListObjects\" ],\"Effect\": \"Allow\",\"Resource\": [\"acs:oss:*:*:{{bucketName}}/*\", \"acs:oss:*:*:{{bucketName}}\"]}],\"Version\": \"1\"}";
    private String stsEndPoint = "cn-hangzhou";
    private String stsApiVersion = "2015-04-01";
    private String bucketName = "";
    private String endPoint = "";
    @Autowired
    Environment env;

    @ApiOperation(value="\u83b7\u53d6\u8bbf\u95ee\u914d\u7f6e\u6587\u4ef6", notes="\u83b7\u53d6\u8bbf\u95ee\u914d\u7f6e\u6587\u4ef6", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/getpolicy"}, method={RequestMethod.GET})
    public RestResponse applyPolicy(@PathVariable String appId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        RestResponse restResp = null;
        try {
            logger.info("OssConstant.APP_ID:{}, appId:{}", (Object)OssConstant.APP_ID, (Object)appId);
            if (!appId.equals(OssConstant.APP_ID)) {
                restResp = new RestResponse(10001, "appId \u65e0\u6548");
            } else {
                IObjectStorageService service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)OssConstant.registryVo);
                Map respMap = service.creatPoliy();
                restResp = new RestResponse((Object)respMap);
            }
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u9519\u8bef,{} ", (Object)e.getMessage(), (Object)e);
            return new RestResponse(500, "\u6388\u6743\u9519\u8bef");
        }
        return restResp;
    }

    @ApiOperation(value="sts\u7b7e\u540d\u63a5\u53e3", notes="sts\u7b7e\u540d\u63a5\u53e3", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/sts"}, method={RequestMethod.GET})
    public RestResponse stsAuth(@PathVariable String appId) {
        String roleArn;
        if (!appId.equals(OssConstant.APP_ID)) {
            logger.info("\u4ec5\u652f\u6301{}\u7684\u8bf7\u6c42", (Object)OssConstant.APP_ID);
            return new RestResponse(10001, "appId \u65e0\u6548");
        }
        if (StringUtils.isBlank((CharSequence)this.bucketName) || StringUtils.isBlank((CharSequence)this.endPoint)) {
            Matcher m = GET_HOST_FROM_ENDPIONT.matcher(OssConstant.registryVo.getEndpoint());
            if (!m.find()) {
                throw new BusinessRuntimeException("\u672a\u4ece{" + this.endPoint + "}\u4e2d\u63d0\u53d6BucketName,\u53caoss\u8282\u70b9\u5730\u5740.\u82e5\u9759\u6001\u7f51\u7ad9\u5730\u5740\u4e3a\u81ea\u5b9a\u4e49\u57df\u540d\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u4fee\u6539\u4ee3\u7801");
            }
            this.bucketName = m.group(2);
            this.endPoint = m.group(3);
            this.policy = this.policy.replace("{{bucketName}}", this.bucketName);
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)this.stsEndPoint, (String)OssConstant.registryVo.getSubAccessKeyId(), (String)OssConstant.registryVo.getSubAccessKeySecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(this.stsApiVersion);
        request.setMethod(MethodType.POST);
        request.setProtocol(ProtocolType.HTTPS);
        String string = roleArn = OssConstant.registryVo != null ? OssConstant.registryVo.getRoleArn() : null;
        if ("ALIYUNOSS".equals(OssConstant.registryVo.getOssType()) && StringUtils.isBlank((CharSequence)roleArn)) {
            logger.error("\u65e0\u6cd5\u8bfb\u53d6stst \u6240\u9700\u7684\u89d2\u8272\u4fe1\u606f roleArn. \u8bf7\u786e\u4fdd\u914d\u7f6e\u5df2\u7ecf\u914d\u7f6e\u4e86\u8be5\u5185\u5bb9.");
        }
        request.setRoleArn(roleArn);
        request.setRoleSessionName("external-username");
        request.setPolicy(this.policy);
        try {
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessKeyId", response.getCredentials().getAccessKeyId());
            respMap.put("accessKeySecret", response.getCredentials().getAccessKeySecret());
            respMap.put("securityToken", response.getCredentials().getSecurityToken());
            respMap.put("ossFile", OssConstant.DIR);
            respMap.put("host", OssConstant.registryVo.getEndpoint());
            respMap.put("endPoint", this.endPoint);
            respMap.put("bucketName", this.bucketName);
            respMap.put("cdnHost", OssConstant.registryVo.getCdnHost());
            return new RestResponse(respMap);
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u9519\u8bef,{} ", (Object)e.getMessage(), (Object)e);
            return new RestResponse(500, "\u6388\u6743\u9519\u8bef");
        }
    }
}

