/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.rest;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.ObjectStorageFactory;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/huieryun/objectstorage/policy"})
@Api(value="/v1/huieryun/objectstorage/policy", description="\u83b7\u53d6OSS\u7684\u8bbf\u95ee\u8bb8\u53ef")
public class OssPolicyController {
    private static Logger logger = LoggerFactory.getLogger(OssPolicyController.class);
    private static final Pattern GET_HOST_FROM_ENDPIONT = Pattern.compile("(http://|https://)?([a-zA-Z\\-0-9]+).([a-zA-Z\\-0-9.]+)");

    public OssPolicyController(Environment env) {
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u4e34\u65f6\u6388\u6743", notes="\u83b7\u53d6\u6587\u4ef6\u4e0a\u4f20\u4e34\u65f6\u6388\u6743", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/getpolicy"}, method={RequestMethod.GET})
    public RestResponse<?> applyPolicy(@PathVariable String appId, @RequestParam(value="bucketKey", required=false) String bucketKey, @RequestParam(value="fileType", required=false) String fileType) {
        logger.info("OssConstant.APP_ID:{}, appId:{}", (Object)OssConstant.APP_ID, (Object)appId);
        if (!appId.equals(OssConstant.APP_ID)) {
            return new RestResponse("10001", "appId \u65e0\u6548");
        }
        RestResponse restResp = null;
        OssRegistryVo registryVo = OssConstant.registryVo;
        if (StringUtils.isNotEmpty((CharSequence)bucketKey)) {
            registryVo = this.assembleRegistryVo(bucketKey);
        }
        if (null == registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        try {
            IObjectStorageService service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)OssConstant.registryVo);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType}) && !fileType.contains("/")) {
                fileType = fileType + "/";
            }
            Map respMap = service.creatPoliy(registryVo, fileType);
            restResp = new RestResponse((Object)respMap);
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u9519\u8bef,{} ", (Object)e.getMessage(), (Object)e);
            return new RestResponse("500", "\u6388\u6743\u9519\u8bef");
        }
        return restResp;
    }

    @ApiOperation(value="sts\u7b7e\u540d\u63a5\u53e3", notes="sts\u7b7e\u540d\u63a5\u53e3", response=RestResponse.class)
    @RequestMapping(value={"/{appId}/sts"}, method={RequestMethod.GET})
    public RestResponse<?> stsAuth(@PathVariable String appId, @RequestParam(value="bucketKey", required=false) String bucketKey) {
        IObjectStorageService service;
        Map respMap;
        OssRegistryVo registryVo = OssConstant.registryVo;
        if (!appId.equals(OssConstant.APP_ID)) {
            logger.error("\u4ec5\u652f\u6301{}\u7684\u8bf7\u6c42", (Object)OssConstant.APP_ID);
            return new RestResponse("10001", "appId \u65e0\u6548");
        }
        if (StringUtils.isNotEmpty((CharSequence)bucketKey)) {
            registryVo = this.assembleRegistryVo(bucketKey);
        }
        if (null == registryVo) {
            return new RestResponse("10001", "bucketKey \u9519\u8bef\uff01");
        }
        String bucketName = registryVo.getBucketName();
        String endPoint = registryVo.getEndpoint();
        if (StringUtils.isBlank((CharSequence)bucketName) && StringUtils.isNotBlank((CharSequence)endPoint)) {
            Matcher m = GET_HOST_FROM_ENDPIONT.matcher(endPoint);
            if (!m.find()) {
                throw new BusinessRuntimeException("\u672a\u4ece{" + endPoint + "}\u4e2d\u63d0\u53d6BucketName,\u53caoss\u8282\u70b9\u5730\u5740.\u82e5\u9759\u6001\u7f51\u7ad9\u5730\u5740\u4e3a\u81ea\u5b9a\u4e49\u57df\u540d\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u4fee\u6539\u4ee3\u7801");
            }
            bucketName = m.group(2);
            endPoint = m.group(3);
            registryVo = this.assembleRegistryVo(bucketName);
            registryVo.setEndpoint(endPoint);
        }
        if (null == (respMap = (service = ObjectStorageFactory.createObjectStorage((OssRegistryVo)registryVo)).createSts(registryVo))) {
            return new RestResponse("500", "\u6388\u6743\u9519\u8bef");
        }
        return new RestResponse((Object)respMap);
    }

    private OssRegistryVo assembleRegistryVo(String bucketKey) {
        OssRegistryVo registryVo = new OssRegistryVo();
        String bucketName = "";
        if (null != OssConstant.registryVo) {
            if (null != OssConstant.registryVo.getExtProperty() && StringUtils.isEmpty((CharSequence)(bucketName = (String)OssConstant.registryVo.getExtProperty().get(bucketKey)))) {
                return null;
            }
            BeanUtils.copyProperties((Object)OssConstant.registryVo, (Object)registryVo);
        }
        if (null != registryVo) {
            if (StringUtils.isNotEmpty((CharSequence)registryVo.getEndpoint()) && StringUtils.isNotEmpty((CharSequence)registryVo.getBucketName())) {
                registryVo.setEndpoint(registryVo.getEndpoint().replaceAll(registryVo.getBucketName(), bucketName));
            }
            registryVo.setBucketName(bucketName);
        }
        return registryVo;
    }
}

