/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.rest;

import com.dtyunxi.app.AppEnv;
import com.dtyunxi.huieryun.oss.rest.ImageResizer;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/simplestorage/files"})
public class SimpleFileStorageController {
    private static final Logger logger = LoggerFactory.getLogger(SimpleFileStorageController.class);
    @Autowired
    private AppEnv appEnv;

    public SimpleFileStorageController(AppEnv appEnv) {
        this.appEnv = appEnv;
    }

    private File getFilePath(String group, String key) {
        String fileHomeDir = this.appEnv.getProperty("huieryun.objectstorage.simpleobjectstorage.filehome");
        File fileDir = new File(fileHomeDir);
        if (!fileDir.exists()) {
            throw new IllegalArgumentException("Dir does not exist: " + fileDir);
        }
        return Paths.get(fileHomeDir, group, key).toFile();
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResponse<String> upload(@RequestParam(required=true, value="group") String group, @RequestParam(required=true, value="key") String key, @RequestParam(value="file") MultipartFile uploadFile) {
        File file = this.getFilePath(group, key);
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        try {
            Files.copy(uploadFile.getInputStream(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return RestResponse.SUCCEED;
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, value="group") String group, @RequestParam(required=true, value="key") String key) {
        String[] processKeys = this.getProcessKey(key);
        File file = this.getFilePath(group, processKeys[0]);
        Path path = Paths.get(file.getPath(), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            response.setContentType("application/octet-stream");
            String fileName = file.getName();
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            try {
                if (processKeys[1] != null) {
                    ImageResizer.resize(path.toFile(), processKeys[1], (OutputStream)response.getOutputStream());
                } else {
                    Files.copy(path, (OutputStream)response.getOutputStream());
                }
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                logger.error("File serve error", (Throwable)e);
                throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.warn("No file found for {}", (Object)file.toString());
            response.setStatus(404);
        }
    }

    private String[] getProcessKey(String key) {
        String[] ary = new String[2];
        int index = key.lastIndexOf("@");
        if (index >= 0) {
            ary[0] = key.substring(0, index);
            ary[1] = key.substring(index + 1);
        } else {
            ary[0] = key;
        }
        return ary;
    }

    @RequestMapping(value={"/exists"}, method={RequestMethod.GET})
    public void exists(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, value="group") String group, @RequestParam(required=true, value="key") String key) {
        String[] processKeys = this.getProcessKey(key);
        File file = this.getFilePath(group, processKeys[0]);
        try {
            response.getWriter().println(file.exists());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (!file.exists()) {
            response.setStatus(404);
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, value="group") String group, @RequestParam(required=true, value="key") String key) {
        String[] processKeys = this.getProcessKey(key);
        File file = this.getFilePath(group, processKeys[0]);
        if (file.exists()) {
            file.delete();
        } else {
            response.setStatus(404);
        }
    }
}

