/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.autoconfigure;

import com.dtyunxi.app.AppEnv;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.api.ObjectStorageFactory;
import com.dtyunxi.huieryun.oss.autoconfigure.OssAppProperties;
import com.dtyunxi.huieryun.oss.autoconfigure.OssProperties;
import com.dtyunxi.huieryun.oss.autoconfigure.OssThreadPoolProperties;
import com.dtyunxi.huieryun.oss.constant.OssConstant;
import com.dtyunxi.huieryun.oss.rest.OssPolicyController;
import com.dtyunxi.huieryun.oss.vo.OssAppVo;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;

@ConditionalOnProperty(prefix="huieryun.ossregistryvo", name={"enable"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={AppEnv.class, OssPolicyController.class, ObjectStorageFactory.class})
@ComponentScan(basePackages={"com.dtyunxi.huieryun.oss.autoconfigure"}, resourcePattern="**/OssProperties.class")
@EnableConfigurationProperties(value={OssAppProperties.class, OssThreadPoolProperties.class})
public class OssAutoConfiguration {
    private final OssRegistryVo ossRegistryVo;
    private final OssAppVo ossAppVo;
    private final Environment environment;

    public OssAutoConfiguration(OssProperties ossRegistryVo, OssAppVo ossAppVo, Environment environment) {
        this.ossRegistryVo = ossRegistryVo;
        this.ossAppVo = ossAppVo;
        this.environment = environment;
        OssConstant.registryVo = this.ossRegistryVo;
        OssConstant.APP_ID = this.ossAppVo.getAppId();
        OssConstant.DIR = this.ossAppVo.getDir();
    }

    @Bean
    @ConditionalOnMissingBean
    public AppEnv appEnv() {
        AppEnv appEnv = new AppEnv();
        return appEnv;
    }

    @Bean
    @ConditionalOnMissingBean
    public OssPolicyController ossPolicyController() {
        return new OssPolicyController(this.environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public IObjectStorageService objectStorageService() {
        return ObjectStorageFactory.createObjectStorage((OssRegistryVo)this.ossRegistryVo);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringBeanUtil springBeanUtil() {
        return new SpringBeanUtil();
    }
}

