/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.autoconfigure;

import com.dtyunxi.huieryun.oss.autoconfigure.OssProperties;
import com.dtyunxi.huieryun.oss.autoconfigure.OssTypeSwitchInterceptor;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class RestServletContextConfig
implements WebMvcConfigurer {
    @Bean(value={"minioOssProperties"})
    @ConditionalOnProperty(prefix="huieryun.minio.ossregistryvo", name={"ossType"}, havingValue="MinIO")
    @ConfigurationProperties(prefix="huieryun.minio.ossregistryvo")
    public OssRegistryVo minioOssProperties() {
        return new OssProperties();
    }

    @Bean(value={"huaweiOssProperties"})
    @ConditionalOnProperty(prefix="huieryun.obs.ossregistryvo", name={"ossType"}, havingValue="HuaweiOBS")
    @ConfigurationProperties(prefix="huieryun.obs.ossregistryvo")
    public OssRegistryVo huaweiOssProperties() {
        return new OssProperties();
    }

    @Bean(value={"awsOssProperties"})
    @ConditionalOnProperty(prefix="huieryun.aws.ossregistryvo", name={"ossType"}, havingValue="AmazonS3")
    @ConfigurationProperties(prefix="huieryun.aws.ossregistryvo")
    public OssRegistryVo awsOssProperties() {
        return new OssProperties();
    }

    @Bean(value={"jdCloudOssProperties"})
    @ConditionalOnProperty(prefix="huieryun.jdcloud.ossregistryvo", name={"ossType"}, havingValue="JDCloudS3")
    @ConfigurationProperties(prefix="huieryun.jdcloud.ossregistryvo")
    public OssRegistryVo jdCloudOssProperties() {
        return new OssProperties();
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/v1/huieryun/objectstorage/policy/**");
    }

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration interceptor = registry.addWebRequestInterceptor((WebRequestInterceptor)new OssTypeSwitchInterceptor());
        List<String> patterns = Arrays.asList("/v1/huieryun/objectstorage/policy/**");
        interceptor.addPathPatterns(patterns);
    }
}

