/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.api;

import com.dtyunxi.util.JacksonUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Mutex {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private String lockKey;
    private String lockAcquirer;
    private Long lockTtl;

    protected Mutex() {
    }

    public Mutex(String lockKey) {
        this.lockKey = lockKey;
        this.lockAcquirer = this.getLocalIP() + "#" + sdf.format(Calendar.getInstance().getTime());
    }

    public Mutex(String lockKey, String lockAcquirer) {
        this.lockKey = lockKey;
        this.lockAcquirer = lockAcquirer;
    }

    public static Mutex parseMutex(String jsonStr) {
        return (Mutex)JacksonUtil.readValue((String)jsonStr, Mutex.class);
    }

    public static String buildLockKey(String tableName, String primaryKey) {
        return "_dtlocks/" + tableName + "#" + primaryKey;
    }

    private String getLocalIP() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public String getLockAcquirer() {
        return this.lockAcquirer;
    }

    public Long getLockTtl() {
        return this.lockTtl;
    }

    public String toString() {
        return JacksonUtil.toJson((Object)this);
    }
}

