/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.api;

import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.vo.RegistryItemVo;
import com.dtyunxi.util.JacksonUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistryService
implements IRegistryService {
    protected String cipherDecodeKey;
    private static final Logger logger = LoggerFactory.getLogger(AbstractRegistryService.class);
    protected String group;
    protected Map<String, RegistryChangeListener> mapKeyListner = new HashMap<String, RegistryChangeListener>();

    @Override
    public boolean put(String key, String value) {
        return this.put(this.group, key, value);
    }

    @Override
    public boolean putObject(String key, Object value) {
        return this.putObject(this.group, key, value);
    }

    @Override
    public boolean putObject(String group, String key, Object value) {
        return this.put(group, key, JacksonUtil.toJson((Object)value));
    }

    @Override
    public String get(String key) {
        return this.get(this.group, key);
    }

    @Override
    public RegistryItemVo[] getPrefix(String key) {
        return this.getPrefix(this.group, key);
    }

    @Override
    public <T> T getObject(String key, Class<T> valueClass) {
        return this.getObject(this.group, key, valueClass);
    }

    @Override
    public <T> T getObject(String group, String key, Class<T> valueClass) {
        String value = this.get(key);
        if (valueClass.equals(String.class) || valueClass.isPrimitive()) {
            return valueClass.cast(value);
        }
        if (value != null) {
            return (T)JacksonUtil.readValue((String)value, valueClass);
        }
        return null;
    }

    @Override
    public void delete(String key) {
        this.delete(this.group, key);
    }

    @Override
    public void watch(String key, RegistryChangeListener registryChangeListener) {
        this.watch(this.group, key, registryChangeListener);
    }

    @Override
    public void watch(String group, String key, RegistryChangeListener registryChangeListener) {
        String mapKey = group + "/" + key;
        RegistryChangeListener oldListener = this.mapKeyListner.get(mapKey);
        if (oldListener == null) {
            this.registerChangeListner(group, key, registryChangeListener);
            this.mapKeyListner.put(mapKey, registryChangeListener);
        } else if (!oldListener.equals(registryChangeListener)) {
            logger.info("registering listener is invalid for group={}, key={}", (Object)group, (Object)key);
        }
    }

    public RegistryChangeListener getRegistryChangeListener(String group, String key) {
        String mapKey = group + "/" + key;
        return this.mapKeyListner.get(mapKey);
    }

    protected abstract void registerChangeListner(String var1, String var2, RegistryChangeListener var3);

    public void setCipherDecodeKey(String cipherDecodeKey) {
        this.cipherDecodeKey = cipherDecodeKey;
    }
}

