/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.api;

import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryServiceFactory;
import com.dtyunxi.util.JacksonUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class ConfigRegistration {
    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, Object> parse(InputStream is) throws IOException {
        BufferedReader reader = null;
        HashMap<String, Object> mapConfigs = new HashMap<String, Object>();
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int indexOfEqual;
                System.out.println(line);
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (indexOfEqual = line.indexOf("=")) < 0) continue;
                String key = line.substring(0, indexOfEqual);
                String value = line.substring(indexOfEqual + 1);
                String objKey = null;
                String objProp = null;
                int indexOfVoDot = key.lastIndexOf("vo.");
                if (indexOfVoDot >= 0) {
                    objKey = key.substring(0, indexOfVoDot + 2);
                    objProp = key.substring(indexOfVoDot + 3);
                    ConfigRegistration.parseVoObject(mapConfigs, objProp, objKey, value);
                    continue;
                }
                mapConfigs.put(key, value);
            }
        }
        catch (Throwable throwable) {
            ConfigRegistration.closeQuietly(reader);
            ConfigRegistration.closeQuietly(is);
            throw throwable;
        }
        ConfigRegistration.closeQuietly(reader);
        ConfigRegistration.closeQuietly(is);
        return mapConfigs;
    }

    private static void parseVoObject(Map<String, Object> mapConfigs, String objProp, String objKey, String propValue) {
        int indexOfSubjectObjectDot;
        HashMap<String, Object> mapObj = (HashMap<String, Object>)mapConfigs.get(objKey);
        if (mapObj == null) {
            mapObj = new HashMap<String, Object>();
            mapConfigs.put(objKey, mapObj);
        }
        if ((indexOfSubjectObjectDot = objProp.indexOf(".")) >= 0) {
            String subObjKey = objProp.substring(0, indexOfSubjectObjectDot);
            String subObjProp = objProp.substring(indexOfSubjectObjectDot + 1);
            ConfigRegistration.parseVoObject(mapObj, subObjProp, subObjKey, propValue);
        } else {
            mapObj.put(objProp, propValue);
        }
    }

    public void registration(String filePath, String group, IRegistryService configService) throws IOException {
        this.registration(new FileInputStream(filePath), group, configService);
    }

    public void registration(InputStream is, String group, IRegistryService configService) throws IOException {
        ConfigRegistration configReg = new ConfigRegistration();
        Map<String, Object> mapConfigs = ConfigRegistration.parse(is);
        for (String key : mapConfigs.keySet()) {
            Object value = mapConfigs.get(key);
            String configValue = null;
            configValue = value instanceof Map ? JacksonUtil.toJson((Object)value) : (String)value;
            System.out.println("key=" + key);
            System.out.println("value=" + configValue);
            System.out.println("===========");
            configService.put(group, key, configValue);
        }
    }

    public static void main(String[] args) {
        String keyGroup = "dtyunxi-qinqu-dev";
        IRegistryService configService = RegistryServiceFactory.createRegistryService("etcd", new String[]{"http://192.168.56.101:2379"}, keyGroup);
        try {
            ConfigRegistration configReg = new ConfigRegistration();
            configReg.registration("/filter-dev.properties", keyGroup, configService);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

