/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.api;

import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.lang.BusinessRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class RegistryServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(RegistryServiceFactory.class);

    public static IRegistryService createRegistryService(String configServiceType, String[] endpoints, String group) {
        AbstractRegistryService configService = null;
        if (configServiceType == null) {
            logger.warn("Fallback to default registry service {} ", (Object)"diamond");
            configServiceType = "diamond";
        }
        if (group == null) {
            throw new BusinessRuntimeException("Please set registry group by system parameter: -Ddtyunxi.registry.group=xxx");
        }
        String className = null;
        switch (configServiceType) {
            case "diamond": {
                className = "com.dtyunxi.huieryun.registry.provider.DiamondRegistryService";
                break;
            }
            case "etcd": {
                className = "com.dtyunxi.huieryun.registry.provider.etcd.EtcdRegistryService";
                break;
            }
            case "zookeeper": {
                className = "com.dtyunxi.huieryun.registry.provider.zookeeper.ZooKeeperRegistryService";
                break;
            }
            case "localfile": {
                className = "com.dtyunxi.huieryun.registry.provider.LocalFileRegistryService";
                break;
            }
        }
        try {
            configService = (AbstractRegistryService)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("Using dtyunxi registry service {}, endpoints {}, group {}", new Object[]{configServiceType, endpoints, group});
        configService.init(endpoints, group);
        return configService;
    }

    public static IRegistryService createRegistryService(Environment env) {
        String configProvider = env.getProperty("dtyunxi.registry.provider");
        String configEndpoints = env.getProperty("dtyunxi.registry.endpoints");
        String[] endpoints = null;
        if (configEndpoints != null && !configEndpoints.trim().isEmpty()) {
            endpoints = new String[]{configEndpoints};
        }
        String configGroup = env.getProperty("dtyunxi.registry.group");
        IRegistryService configService = RegistryServiceFactory.createRegistryService(configProvider, endpoints, configGroup);
        String cipherDecodeKey = env.getProperty("dtyunxi.registry.cipherKey");
        if (cipherDecodeKey != null) {
            ((AbstractRegistryService)configService).setCipherDecodeKey(cipherDecodeKey);
        }
        return configService;
    }
}

