/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.registry.provider;

import com.alibaba.edas.configcenter.config.ConfigChangeListenerAdapter;
import com.alibaba.edas.configcenter.config.ConfigService;
import com.dtyunxi.huieryun.registry.api.AbstractRegistryService;
import com.dtyunxi.huieryun.registry.api.RegistryChangeListener;
import com.dtyunxi.huieryun.registry.provider.DiamondManagerListener;
import com.dtyunxi.huieryun.registry.vo.RegistryItemVo;
import com.dtyunxi.util.CipherTextUtil;
import com.taobao.diamond.client.Diamond;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiamondRegistryService
extends AbstractRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(DiamondRegistryService.class);
    private static String config = "";

    @Override
    public void init(String[] endpoints, String group) {
        this.group = group;
    }

    @Override
    public boolean put(String group, String key, String value) {
        logger.debug("Put value to registry, group:{}, key:{}, value:{}", new Object[]{group, key, value});
        return Diamond.publishSingle((String)key, (String)group, (String)value);
    }

    @Override
    public String get(String group, String key) {
        String value = null;
        try {
            value = ConfigService.getConfig((String)key, (String)group, (long)3000L);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        value = CipherTextUtil.decode((String)this.cipherDecodeKey, (String)value);
        logger.debug("Get value from registry, group:{}, key:{}, value:{}", new Object[]{group, key, value});
        return value;
    }

    @Override
    public RegistryItemVo[] getPrefix(String group, String key) {
        throw new UnsupportedOperationException("DiamondConfigService.getPrefix");
    }

    @Override
    public void delete(String group, String key) {
        logger.debug("Detete key from registry, group:{}, key:{}", (Object)group, (Object)key);
        Diamond.remove((String)key, (String)group);
    }

    @Override
    public void registerChangeListner(String group, String key, RegistryChangeListener registryChangeListener) {
        ConfigService.addListener((String)key, (String)group, (ConfigChangeListenerAdapter)new DiamondManagerListener(group, key, registryChangeListener));
    }
}

