/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.dto.mapping;

import com.dtyunxi.dto.mapping.YxClass;
import com.dtyunxi.dto.mapping.YxClassRef;
import com.dtyunxi.dto.mapping.YxData;
import com.dtyunxi.dto.mapping.YxField;
import com.dtyunxi.dto.mapping.YxFieldRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DataCopier {
    private static Logger logger = LoggerFactory.getLogger(DataCopier.class);
    private static Map<String, Map<String, YxClassRef>> classRefMap = new ConcurrentHashMap<String, Map<String, YxClassRef>>(16);
    private static Map<String, Map<String, String>> subRefMap = new ConcurrentHashMap<String, Map<String, String>>(16);

    public static void regeditClassRef(YxClassRef classRef) {
        String lefClass = classRef.from().readCanonicalName();
        String rightClass = classRef.to().readCanonicalName();
        classRefMap.putIfAbsent(lefClass, new ConcurrentHashMap(4));
        classRefMap.get(lefClass).putIfAbsent(rightClass, classRef);
        if (!lefClass.equals(rightClass)) {
            classRefMap.putIfAbsent(rightClass, new ConcurrentHashMap(4));
            classRefMap.get(rightClass).putIfAbsent(lefClass, classRef.flip());
        }
    }

    public static void regeditSubPropClassRef(YxClass mainData, String prop4sub, YxClassRef classRef) {
        subRefMap.putIfAbsent(mainData.readCanonicalName(), new ConcurrentHashMap(4));
        String rightClass = classRef.to().readCanonicalName();
        subRefMap.get(mainData.readCanonicalName()).put(rightClass, prop4sub);
        DataCopier.regeditClassRef(classRef);
    }

    public static YxData copy(YxData input, YxClass outputType) {
        if (input.getYxClass() == null) {
            throw new RuntimeException("\u9700\u8981\u6307\u5b9a\u8f93\u5165\u6570\u636e\u7684\u5b9a\u4e49\u683c\u5f0f");
        }
        return DataCopier.copy(input, outputType, input.getYxClass());
    }

    public static YxData copy(YxData input, YxClass outputType, YxClass inputType) {
        return DataCopier.copy(input, outputType, inputType, new ArrayList<YxClassRef>(4));
    }

    public static YxData copy(YxData input, YxClass outputType, YxClass inputType, ArrayList<YxClassRef> traceStack) {
        if (outputType.readCanonicalName().equals(inputType.readCanonicalName())) {
            return input;
        }
        YxClassRef classRef = (YxClassRef)((Object)((Map)classRefMap.getOrDefault(inputType.readCanonicalName(), new HashMap())).get(outputType.readCanonicalName()));
        if (traceStack == null) {
            traceStack = new ArrayList();
        }
        traceStack.add(classRef);
        if (classRef == null || classRef.isEmpty()) {
            return DataCopier.copyFromSubInner(input, outputType, inputType, classRef);
        }
        DataCopier.checkStack(traceStack);
        return DataCopier.copyInner(input, classRef);
    }

    private static YxData copyFromSubInner(YxData input, YxClass outputType, YxClass inputType, YxClassRef classRef) {
        String propName4sub = (String)((Map)subRefMap.getOrDefault(inputType.readCanonicalName(), new HashMap())).get(outputType.readCanonicalName());
        if (StringUtils.isBlank((CharSequence)propName4sub)) {
            throw new RuntimeException("\u6620\u5c04\u5173\u7cfb\u672a\u5b9a\u4e49: " + inputType.readCanonicalName() + "->" + outputType.readCanonicalName());
        }
        logger.debug("\u4ece\u5b50\u5c5e\u6027\u4e2d\u63d0\u53d6\u503c: \u6e90:{} ,\u5c5e\u6027:{}, \u76ee\u6807:{}", new Object[]{inputType.readCanonicalName(), propName4sub, outputType.readCanonicalName()});
        YxField subField = inputType.getAttr(propName4sub);
        if (subField == null) {
            throw new RuntimeException("\u8f93\u5165\u5bf9\u8c61" + inputType.readCanonicalName() + "\u672a\u901a\u8fc7YxClass\u65b9\u5f0f\u58f0\u660e\u5c5e\u6027" + propName4sub + "\u7684\u7c7b\u578b");
        }
        YxClass subType = subField.getSubType();
        if (subType == null) {
            throw new RuntimeException("\u8f93\u5165\u5bf9\u8c61" + inputType.readCanonicalName() + "\u672a\u901a\u8fc7YxClass\u65b9\u5f0f\u58f0\u660e\u5c5e\u6027" + propName4sub + "\u5bf9\u5e94\u7684\u7c7b\u578b");
        }
        Object propValue = input.get(propName4sub);
        if (propValue instanceof Collection) {
            Collection collection = (Collection)propValue;
            if (CollectionUtils.isEmpty((Collection)collection)) {
                return new YxData(classRef.to());
            }
            Object firstElement = collection.iterator().next();
            if (firstElement instanceof Map) {
                YxData subItem = new YxData(subType);
                subItem.putAll((Map)firstElement);
                YxClassRef subClassRef = (YxClassRef)((Object)((Map)classRefMap.getOrDefault(subType.readCanonicalName(), new HashMap())).get(outputType.readCanonicalName()));
                return DataCopier.copyInner(subItem, subClassRef);
            }
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u4ece\u5c5e\u6027\u4e2d\u590d\u5236 \u8f93\u5165\u5bf9\u8c61" + inputType.readCanonicalName() + "\u7684" + propName4sub + ".\u5bf9\u5e94\u7684\u7c7b\u578b\u4e3a" + firstElement.getClass());
        }
        logger.warn("\u4ece\u975e\u5217\u8868\u5c5e\u6027\u4e2d\u5e94\u6620\u5c04\u503c,\u76ee\u524d\u4e0d\u652f\u6301");
        return null;
    }

    private static YxData copyInner(YxData input, YxClassRef classRef) {
        YxData output = new YxData(classRef.to());
        for (YxFieldRef ref : classRef.ref()) {
            if (ref.from().getType().isCollection()) {
                List inputSubValues = (List)input.get(ref.from().code);
                if (inputSubValues == null) continue;
                List outSubValues = inputSubValues.stream().map(inputSubValue -> DataCopier.copy(inputSubValue, ref.to().subType, ref.from().subType)).collect(Collectors.toList());
                output.put(ref.to().getCode(), (Object)outSubValues);
                continue;
            }
            Object inputValue = input.get(ref.from().code);
            if (inputValue == null) continue;
            output.put(ref.to().code, inputValue);
        }
        return output;
    }

    private static void checkStack(ArrayList<YxClassRef> traceStack) {
        if (traceStack.size() > 3) {
            String stackMsg = "\n";
            String tab = "";
            for (YxClassRef ref : traceStack) {
                stackMsg = stackMsg + tab + ref.from().readCanonicalName() + "->" + ref.to().readCanonicalName() + "\n";
                tab = tab + "\t";
            }
            throw new RuntimeException("\u590d\u5236\u5c42\u6b21\u8fc7\u6df1:" + stackMsg);
        }
    }
}

