/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.dto.mapping;

import com.dtyunxi.dto.mapping.ValueType;
import com.dtyunxi.dto.mapping.YxField;
import java.util.HashMap;
import java.util.Map;

public class YxClass {
    String code;
    String name;
    String pkg;
    Map<String, YxField> attrs;

    public YxClass addNumAttr(String code, String name) {
        return this.addAttr(new YxField(code, name, ValueType.NUM));
    }

    public YxClass addStrAttr(String code, String name) {
        return this.addAttr(new YxField(code, name, ValueType.STR));
    }

    public YxClass addBoolAttr(String code, String name) {
        return this.addAttr(new YxField(code, name, ValueType.BOOL));
    }

    public YxClass addDateAttr(String code, String name) {
        return this.addAttr(new YxField(code, name, ValueType.DATE));
    }

    public YxClass addSimpleAttr(String code, String name, ValueType valueType) {
        return this.addAttr(new YxField(code, name, valueType));
    }

    public YxClass addListAttr(String code, String name, YxClass subType) {
        return this.addAttr(new YxField(code, name, ValueType.LIST).setSubType(subType));
    }

    private YxClass addAttr(YxField attr) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, YxField>(8);
        }
        attr.parent = this;
        this.attrs.put(attr.getCode(), attr);
        return this;
    }

    public String readCanonicalName() {
        if (this.getPkg() == null) {
            return this.getCode();
        }
        return this.getPkg() + "." + this.getCode();
    }

    public YxField getAttr(String code) {
        return this.attrs.get(code);
    }

    public Map<String, YxField> getAttrs() {
        return this.attrs;
    }

    public String getCode() {
        return this.code;
    }

    public YxClass setCode(String code) {
        this.code = code;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public YxClass setName(String name) {
        this.name = name;
        return this;
    }

    public String getPkg() {
        return this.pkg;
    }

    public YxClass setPkg(String pkg) {
        this.pkg = pkg;
        return this;
    }

    public String toString() {
        return "YxClass-" + this.readCanonicalName();
    }
}

