/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassScanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassScanUtils.class);

    public static Set<Class<?>> getJarClass(List<String> compileClasspathElements, ClassLoader classLoader) {
        HashSet jarClass = new HashSet();
        try {
            for (String jarPath : compileClasspathElements) {
                if (jarPath.toLowerCase().endsWith(".jar")) {
                    ClassScanUtils.addJarClasses(classLoader, jarClass, jarPath);
                    continue;
                }
                if (!jarPath.endsWith(File.separator + "classes")) continue;
                ClassScanUtils.addFolderClasses(classLoader, jarClass, jarPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6jar\u5305\u4e0b\u7684\u7c7b\u5f02\u5e38", (Throwable)e);
        }
        return jarClass;
    }

    private static void addFolderClasses(ClassLoader classLoader, Set<Class<?>> jarClass, String baseFolderPath) {
        File file = new File(baseFolderPath);
        if (file != null && file.exists() && file.isDirectory()) {
            ClassScanUtils.addFileClassesUnderFolder(classLoader, jarClass, file, baseFolderPath);
        }
    }

    private static void addFileClassesUnderFolder(ClassLoader classLoader, Set<Class<?>> jarClass, File folder, String baseFolderPath) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (file.isDirectory()) {
                ClassScanUtils.addFileClassesUnderFolder(classLoader, jarClass, file, baseFolderPath);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String absolutePath = file.getAbsolutePath();
            try {
                String className = absolutePath.substring(baseFolderPath.length() + 1, absolutePath.lastIndexOf(".")).replace(File.separator, ".");
                LOGGER.debug("\u52a0\u8f7d\u7c7b:{}", (Object)className);
                Class<?> myClass = classLoader.loadClass(className);
                jarClass.add(myClass);
            }
            catch (Throwable e) {
                LOGGER.warn("could not load class {}, reason: Class not found {}", (Object)absolutePath, (Object)e.getMessage());
            }
        }
    }

    private static void addJarClasses(ClassLoader classLoader, Set<Class<?>> jarClass, String jarPath) throws IOException {
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            String name;
            JarEntry jarEntry = enu.nextElement();
            if (jarEntry == null || !(name = jarEntry.getName()).endsWith(".class")) continue;
            try {
                String className = name.substring(0, name.lastIndexOf(".")).replace("/", ".");
                LOGGER.debug("\u52a0\u8f7d\u7c7b:{}", (Object)className);
                Class<?> myClass = classLoader.loadClass(className);
                jarClass.add(myClass);
            }
            catch (Throwable e) {
                LOGGER.warn("could not load class {}, reason: Class not found {}", (Object)name, (Object)e.getMessage());
            }
        }
    }
}

