/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.utils.SourceRoot;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;

public class JavaParserUtils {
    private static String getComment(Optional<Comment> optComment) {
        if (optComment.isPresent()) {
            Comment comment = optComment.get();
            String strComment = comment.getContent().trim();
            if (strComment.startsWith("*")) {
                strComment = strComment.substring(1, strComment.length()).trim();
            }
            return strComment;
        }
        return null;
    }

    public static Map<String, String> getComments(String sourceDir, String packageName, String javaFileName) {
        HashMap<String, String> mapComments = new HashMap<String, String>();
        SourceRoot sourceRoot = new SourceRoot(Paths.get(sourceDir, new String[0]));
        CompilationUnit cu = sourceRoot.parse(packageName, javaFileName + ".java");
        for (TypeDeclaration type : cu.getTypes()) {
            String strTypeComent = JavaParserUtils.getComment(type.getComment());
            if (strTypeComent != null) {
                mapComments.put(packageName + "." + javaFileName, strTypeComent);
            }
            List fieldDeclarations = type.getFields();
            for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
                String strComment;
                if (!fieldDeclaration.isAnnotationPresent(Column.class) || (strComment = JavaParserUtils.getComment(fieldDeclaration.getComment())) == null) continue;
                List varNames = fieldDeclaration.getVariables().stream().map(v -> v.getName().getId()).collect(Collectors.toList());
                String fieldName = String.join((CharSequence)", ", varNames);
                mapComments.put(fieldName, strComment);
            }
        }
        return mapComments;
    }
}

