/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ServiceContextUtil {
    public static String[] PACKING_HEADERS = new String[]{"X-Real-Hostname", "Application-Key", "Referer", "Access-Token", "yes.req.terminal.type", "yes.req.clientId", "yes.req.requestId", "sceneCode", "yes.req.tenantId", "yes.req.applicationId", "yes.req.instanceId", "yes.req.userId", "yes.req.userCode"};
    public static List<String> PACKING_HEADERS_LIST = Arrays.asList(PACKING_HEADERS);
    public static Map<String, String> PACKING_HEADERS_TO_CAMEL = Stream.of(PACKING_HEADERS).collect(Collectors.toConcurrentMap(String::toLowerCase, str -> str));
    public static List<String> IDENTITY_HEADERS = Arrays.asList("yes.req.tenantId", "yes.req.applicationId", "yes.req.instanceId", "yes.req.userId", "yes.req.userCode");
    public static List<String> GENERAL_HEADERS = Stream.of(PACKING_HEADERS).filter(s -> !IDENTITY_HEADERS.contains(s)).collect(Collectors.toList());

    public static Long getRequestApplicationId() {
        return ServiceContextUtil.readIContext().applicationId();
    }

    public static Long getRequestTenantId() {
        return ServiceContextUtil.readIContext().tenantId();
    }

    public static Long getRequestInstanceId() {
        return ServiceContextUtil.readIContext().instanceId();
    }

    private static IContext readIContext() {
        return (IContext)SpringBeanUtil.getBean(IContext.class);
    }

    public static String getAccessToken() {
        return ServiceContext.getContext().getAttachment("Access-Token");
    }

    public static String getApplicationKey() {
        return ServiceContext.getContext().getAttachment("Application-Key");
    }

    public static String getXrealHostName() {
        return ServiceContext.getContext().getAttachment("X-Real-Hostname");
    }

    public static String getReferer() {
        return ServiceContext.getContext().getAttachment("Referer");
    }
}

