/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.yes.rpc.AbstractMicroServiceContext;
import com.dtyunxi.yundt.module.context.biz.ContextConstants;
import com.dtyunxi.yundt.module.context.biz.impl.ContextInterceptor;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpMethod;

@ConditionalOnClass(value={RequestInterceptor.class})
public class FeignClientContextFilter
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(FeignClientContextFilter.class);

    public void apply(RequestTemplate template) {
        if (template.method().equalsIgnoreCase(HttpMethod.GET.name())) {
            if (template.url().contains("/v1/application/instance/one-time")) {
                return;
            }
            if (template.url().contains("/v1/application/instance?hostname=")) {
                return;
            }
        }
        logger.warn("\u8bf7\u6c42\u5934\u5185\u5bb9\u900f\u4f20\uff01Url:{},Method={}", (Object)template.url(), (Object)template.method());
        this.delivery(template);
    }

    public void delivery(RequestTemplate template) {
        List<String> inputHeaders = ContextInterceptor.getInputHeaders();
        for (String packingHeader : inputHeaders) {
            this.setHeader(template, packingHeader, ServiceContext.getContext().getAttachment(packingHeader));
        }
        this.setHeader(template, AbstractMicroServiceContext.createContextKey((String)"yes.req.requestId"), ServiceContext.getContext().get("yes.req.requestId"));
        this.setHeader(template, ContextConstants.KEY_REQ_SOURCE, ContextConstants.REQ_SOURCE_FEIGN);
    }

    private <T> void setHeader(RequestTemplate template, String header, T value) {
        if (value != null) {
            template.header(header, new String[]{value.toString()});
        }
    }

    public FeignClientContextFilter initTransferableHeaders(List<String> transferableHeaders) {
        return this;
    }
}

