/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yes.rpc.AbstractMicroServiceContext;
import com.dtyunxi.yundt.module.context.biz.ServiceContextUtil;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import com.dtyunxi.yundt.module.context.common.config.UrlWhiteList;
import com.dtyunxi.yundt.module.context.common.utils.ContextCommonUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class ContextInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ContextInterceptor.class);
    private boolean trustHeaderApp = false;
    private static ThreadLocal<List<String>> inputHeadersBox = new ThreadLocal();
    private UrlWhiteList urlWhiteList = new UrlWhiteList();
    private final AppRecognitionConfig appRecognitionConfig;

    public ContextInterceptor(AppRecognitionConfig appRecognitionConfig) {
        this.appRecognitionConfig = appRecognitionConfig;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        boolean needRecognizeAppInfo;
        String requestMethod = request.getMethod();
        if (HttpMethod.OPTIONS.name().equalsIgnoreCase(requestMethod)) {
            return true;
        }
        String requestURI = request.getRequestURI();
        if (requestURI.equals("/error")) {
            return true;
        }
        if (this.urlWhiteList.isWhiteList(requestURI)) {
            return true;
        }
        if (requestMethod.equalsIgnoreCase(HttpMethod.GET.name()) && (requestURI.contains("/v1/application/instance/one-time") || requestURI.contains("/v1/application/instance?hostname="))) {
            return true;
        }
        HashMap<String, String> packingHeaderValues = new HashMap<String, String>(8);
        ArrayList<String> inputHeaders = new ArrayList<String>(8);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String value = request.getHeader(headerName);
            logger.debug("\u63a5\u6536\u7684\u8bf7\u6c42\u5934\uff1a{}-{}", (Object)headerName, (Object)value);
            if (value == null) continue;
            if (ServiceContextUtil.PACKING_HEADERS_TO_CAMEL.containsKey(headerName)) {
                String actualHeadName = ServiceContextUtil.PACKING_HEADERS_TO_CAMEL.get(headerName);
                inputHeaders.add(actualHeadName);
                packingHeaderValues.put(actualHeadName, value);
                continue;
            }
            inputHeaders.add(headerName);
            packingHeaderValues.put(headerName, value);
        }
        inputHeadersBox.set(inputHeaders);
        String requestId = request.getHeader(AbstractMicroServiceContext.createContextKey((String)"yes.req.requestId"));
        if (requestId != null) {
            packingHeaderValues.put("yes.req.requestId", requestId);
        }
        if ((needRecognizeAppInfo = ContextCommonUtils.fillContextByHeader(request.getRequestURL().toString(), packingHeaderValues, this.trustHeaderApp)) && this.appRecognitionConfig.isEnforceAppRecognize()) {
            throw new BizException("\u672a\u80fd\u8bc6\u522b\u5e94\u7528\u4fe1\u606f,\u8bf7\u7ed3\u5408api\u7f51\u5173\u4f7f\u7528");
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ServiceContext serviceContext = ServiceContext.getContext();
        serviceContext.removeAttachmentContext();
        ServiceContext.removeContext();
        inputHeadersBox.remove();
    }

    public static List<String> getInputHeaders() {
        List<String> headers = null;
        if (inputHeadersBox != null) {
            headers = inputHeadersBox.get();
        }
        if (headers == null) {
            headers = ServiceContextUtil.PACKING_HEADERS_LIST;
        } else {
            headers.addAll(ServiceContextUtil.PACKING_HEADERS_LIST);
            headers = headers.stream().distinct().collect(Collectors.toList());
        }
        return headers;
    }

    public ContextInterceptor enableTrustHeaderApp() {
        this.trustHeaderApp = true;
        return this;
    }

    public void initWhiteList(UrlWhiteList urlWhiteList) {
        this.urlWhiteList = urlWhiteList;
    }
}

