/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context;

import com.dtyunxi.yundt.module.context.ContextInterceptorWebMvcConfigurer;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.context.biz.FeignClientContextFilter;
import com.dtyunxi.yundt.module.context.biz.impl.ContextImpl;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;

@RefreshScope
public class ContextTransferAutoConfiguration {
    @Value(value="${com.dtyunxi.yundt.module.context.config.whiteList:}")
    private List<String> contextInputExcludePathPatterns;

    @Bean
    @RefreshScope
    @ConfigurationProperties(prefix="app.recognition")
    public AppRecognitionConfig appRecognitionConfig() {
        return new AppRecognitionConfig();
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public FeignClientContextFilter feignFilter(AppRecognitionConfig appRecognitionConfig) {
        List<String> transferableHeaders = this.readTransferableHeaders(appRecognitionConfig);
        return new FeignClientContextFilter().initTransferableHeaders(transferableHeaders);
    }

    private List<String> readTransferableHeaders(AppRecognitionConfig appRecognitionConfig) {
        List<String> transferableHeaders = appRecognitionConfig != null ? appRecognitionConfig.getTransferableHeaders() : null;
        return transferableHeaders;
    }

    @Bean
    public ContextInterceptorWebMvcConfigurer contextInterceptorWebMvcConfigurer(AppRecognitionConfig appRecognitionConfig) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        if (this.contextInputExcludePathPatterns != null && !this.contextInputExcludePathPatterns.isEmpty()) {
            urls.addAll(this.contextInputExcludePathPatterns);
        }
        return new ContextInterceptorWebMvcConfigurer(appRecognitionConfig).setExcludePathPatterns(urls);
    }

    @Bean(value={"huieryunCubeContext"})
    @ConditionalOnMissingBean
    public IContext context() {
        return new ContextImpl();
    }
}

