/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.common.callback;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IAppInstanceCallBack<T> {
    public static final Logger LOGGER = LoggerFactory.getLogger(IAppInstanceCallBack.class);

    public int snippetLen();

    public String keyWord();

    public T searchByInstanceId(Long var1);

    public T searchByUrl(String var1);

    @Deprecated
    default public Long getAppId() {
        return ServiceContext.getContext().getRequestApplicationId();
    }

    @Deprecated
    default public Long getInstanceId() {
        return ServiceContext.getContext().getRequestInstanceId();
    }

    @Deprecated
    default public Long getTenantId() {
        return ServiceContext.getContext().getRequestTenantId();
    }

    @Deprecated
    public static String processWithUrl(String url, int snippetLen) {
        return IAppInstanceCallBack.processWithUrl(url, snippetLen, null);
    }

    public static String processWithUrl(String url, int snippetLen, String keyWord) {
        LOGGER.debug("\u5e94\u7528\u8bc6\u522b\u7684host[referer/x-real-hostname]\u5904\u7406\u524d:{}", (Object)url);
        url = IAppInstanceCallBack.removeProtocol(url);
        String[] snippets = StringUtils.split((String)url, (String)"/");
        if (snippetLen == 0 || snippets.length <= snippetLen) {
            return url;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < snippetLen && i < snippets.length; ++i) {
            sb.append(snippets[i]).append("/");
            if (!snippets[i].equals(keyWord)) continue;
            ++snippetLen;
        }
        LOGGER.debug("\u5e94\u7528\u8bc6\u522b\u7684host[referer/x-real-hostname]\u5904\u7406\u540e:{}", (Object)url);
        return sb.toString();
    }

    public static String removeProtocol(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        if (url.startsWith("http://")) {
            url = url.substring(7);
        } else if (url.startsWith("https://")) {
            url = url.substring(8);
        }
        return url;
    }

    default public T process(String appInstanceKey) {
        T result = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appInstanceKey})) {
            if (StringUtils.isNumeric((CharSequence)appInstanceKey)) {
                return this.searchByInstanceId(Long.valueOf(appInstanceKey));
            }
            if (appInstanceKey.contains("_")) {
                String[] keys = appInstanceKey.split("_");
                if (keys.length != 2) {
                    throw new BizException("3050", "app\u5b9e\u4f8bkey\u4e0d\u5408\u6cd5");
                }
                try {
                    Long appInsId = Long.valueOf(keys[1]);
                    return this.searchByInstanceId(appInsId);
                }
                catch (Exception e) {
                    throw new BizException("3050", "app\u5b9e\u4f8bkey\u4e0d\u5408\u6cd5");
                }
            }
            result = this.searchByUrl(IAppInstanceCallBack.processWithUrl(appInstanceKey, this.snippetLen(), this.keyWord()));
            if (result != null) {
                return result;
            }
            LOGGER.debug("\u901a\u8fc7url\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b:{}", (Object)appInstanceKey);
        }
        return null;
    }
}

