/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.admin.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.yundt.cube.center.identity.api.IAppSecretApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AppSecretReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.AppSecretRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.query.IAppSecretQueryApi;
import com.dtyunxi.yundt.cube.center.payment.api.config.IPayCenterConfigApi;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AppAuthRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.AppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.PayAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAppAuthRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryAppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.QueryStoreRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.StoreRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateAccountRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.config.UpdateAppRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.response.AppPaytypeRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.AppRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.PartnerConfigRespDto;
import com.dtyunxi.yundt.cube.center.payment.dto.response.StoreRespDto;
import com.dtyunxi.yundt.module.admin.api.ISystemBizConfig;
import com.dtyunxi.yundt.module.admin.dto.request.AliAccountReqDto;
import com.dtyunxi.yundt.module.admin.dto.request.WxAccountReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemBizConfigImpl
implements ISystemBizConfig {
    private static Logger logger = LoggerFactory.getLogger(SystemBizConfigImpl.class);
    @Resource(name="yundt.module.admin")
    private IConfig config;
    @Resource
    private IAppSecretApi appSecretApi;
    @Resource
    private IAppSecretQueryApi appSecretQueryApi;
    @Autowired
    private IPayCenterConfigApi payCenterConfigApi;
    @Resource
    private IContext context;

    public Boolean invoiceConfig() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(null, "com.dtyunxi.yundt.module.admin.invoice");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
        if (null == configItem) {
            logger.info("\u5f00\u7968\u5171\u80fd\u672a\u8bbe\u7f6e\uff0c\u9ed8\u8ba4true\u5f00\u542f");
            return true;
        }
        return Boolean.valueOf(configItem.getValue());
    }

    public Integer operationMode() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(null, "com.dtyunxi.yundt.module.admin.operationMode");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5546\u57ce\u8fd0\u8425\u6a21\u5f0f\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        if (null == configItem) {
            return 1;
        }
        logger.info("\u8fd0\u8425\u6a21\u5f0f\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)configItem));
        return Integer.valueOf(configItem.getValue());
    }

    public void saveWeixinAccount(WxAccountReqDto wxAccount) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        this.checkWxAccountParam(wxAccount);
        try {
            PartnerConfigRespDto account;
            Optional<PartnerConfigRespDto> accountOpt;
            AppRespDto app;
            Optional<AppRespDto> appOpt;
            AppSecretReqDto wxAppSecret = new AppSecretReqDto();
            wxAppSecret.setKeyAppId(wxAccount.getAppId());
            wxAppSecret.setKeyAppSecret(wxAccount.getAppSecret());
            this.saveWxApp(wxAppSecret);
            StoreRespDto store = this.getStore(instanceId, tenantId);
            Optional<StoreRespDto> storeOpt = Optional.ofNullable(store);
            if (!storeOpt.isPresent()) {
                StoreRequest newStore = new StoreRequest();
                String code = this.getStoreCode(0);
                newStore.setCode(code);
                newStore.setApiSecret(instanceId.toString());
                newStore.setInstanceId(instanceId);
                newStore.setTenantId(tenantId);
                Long storeId = (Long)this.payCenterConfigApi.createStore(newStore).getData();
                store = (StoreRespDto)this.payCenterConfigApi.queryStoreById(storeId).getData();
            }
            if (!(appOpt = Optional.ofNullable(app = this.getApp(instanceId, tenantId, store.getCode(), "101"))).isPresent()) {
                AppRequest newApp = new AppRequest();
                String appCode = this.getAppCode("101", 0);
                newApp.setCode(appCode);
                newApp.setName(wxAccount.getMerchantName());
                newApp.setStatus("U");
                newApp.setIsAutoClosePtOrder(Integer.valueOf(0));
                newApp.setIsAllowResubmit(Integer.valueOf(1));
                newApp.setIsCloseOrder(Integer.valueOf(1));
                newApp.setInstanceId(instanceId);
                newApp.setTenantId(tenantId);
                Long appId = (Long)this.payCenterConfigApi.createApp(store.getCode(), newApp).getData();
                app = (AppRespDto)this.payCenterConfigApi.queryAppById(appId).getData();
            } else {
                UpdateAppRequest updateApp = new UpdateAppRequest();
                BeanUtils.copyProperties((Object)app, (Object)updateApp);
                updateApp.setName(wxAccount.getMerchantName());
                this.payCenterConfigApi.updateApp(app.getId(), updateApp);
            }
            AppPaytypeRespDto appAuth = this.getAppAuth(instanceId, tenantId, app.getCode(), "101");
            Optional<AppPaytypeRespDto> appAuthOpt = Optional.ofNullable(appAuth);
            if (!appAuthOpt.isPresent()) {
                AppAuthRequest auth = new AppAuthRequest();
                auth.setAppCode(app.getCode());
                auth.setPartnerCode("102");
                auth.setPayType("101");
                auth.setTenantId(tenantId);
                auth.setInstanceId(instanceId);
                this.payCenterConfigApi.createAppAuth(auth);
            }
            if (!(accountOpt = Optional.ofNullable(account = this.getPayAccount(instanceId, tenantId, store.getCode(), app.getCode(), "101"))).isPresent()) {
                PayAccountRequest newAccount = new PayAccountRequest();
                newAccount.setPartnerCode("102");
                newAccount.setPayType("101");
                newAccount.setStoreCode(store.getCode());
                newAccount.setAppCode(app.getCode());
                newAccount.setStatus("U");
                newAccount.setPtMerId(wxAccount.getMerchantNum());
                newAccount.setPtAccount(wxAccount.getAppId());
                newAccount.setPtPubKey(wxAccount.getPaySecretKey());
                newAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                newAccount.setInstanceId(instanceId);
                newAccount.setTenantId(tenantId);
                this.payCenterConfigApi.createPayAccount(newAccount).getData();
            } else {
                UpdateAccountRequest updateAccount = new UpdateAccountRequest();
                BeanUtils.copyProperties((Object)account, (Object)updateAccount);
                updateAccount.setStoreCode(store.getCode());
                updateAccount.setAppCode(app.getCode());
                updateAccount.setPtMerId(wxAccount.getMerchantNum());
                updateAccount.setPtAccount(wxAccount.getAppId());
                updateAccount.setPtPubKey(wxAccount.getPaySecretKey());
                updateAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                this.payCenterConfigApi.updatePayAccount(account.getId(), updateAccount);
            }
            this.saveWxH5(instanceId, tenantId, store.getCode(), app.getCode(), wxAccount);
            this.saveWxCode(instanceId, tenantId, store.getCode(), app.getCode(), wxAccount);
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u5fae\u4fe1\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    private void checkWxAccountParam(WxAccountReqDto wxAccount) {
        if (null == wxAccount) {
            throw new BusinessRuntimeException("\u5fae\u4fe1\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)wxAccount.getAppId())) {
            throw new BusinessRuntimeException("\u5fae\u4fe1APPID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)wxAccount.getAppSecret())) {
            throw new BusinessRuntimeException("\u5fae\u4fe1AppSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)wxAccount.getMerchantName())) {
            throw new BusinessRuntimeException("\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)wxAccount.getMerchantNum())) {
            throw new BusinessRuntimeException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)wxAccount.getPaySecretKey())) {
            throw new BusinessRuntimeException("\u5fae\u4fe1\u5546\u6237\u652f\u4ed8\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        wxAccount.setAppId(wxAccount.getAppId().trim());
        wxAccount.setAppSecret(wxAccount.getAppSecret().trim());
        wxAccount.setMerchantName(wxAccount.getMerchantName().trim());
        wxAccount.setMerchantNum(wxAccount.getMerchantNum().trim());
        wxAccount.setPaySecretKey(wxAccount.getPaySecretKey().trim());
    }

    public void saveWxApp(AppSecretReqDto wxAppReqDto) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        RequestDto param = new RequestDto();
        param.setInstanceId(instanceId);
        param.setTenantId(tenantId);
        List wxApps = (List)this.appSecretQueryApi.findList(JSON.toJSONString((Object)param)).getData();
        if (CollectionUtils.isNotEmpty((Collection)wxApps)) {
            AppSecretReqDto update = new AppSecretReqDto();
            BeanUtils.copyProperties(wxApps.get(0), (Object)update);
            update.setKeyAppId(wxAppReqDto.getKeyAppId());
            update.setKeyAppSecret(wxAppReqDto.getKeyAppSecret());
            update.setKeyAppConfig(JSON.toJSONString((Object)wxAppReqDto));
            this.appSecretApi.modify(((AppSecretRespDto)wxApps.get(0)).getId(), wxAppReqDto);
        } else {
            wxAppReqDto.setInstanceId(instanceId);
            wxAppReqDto.setTenantId(tenantId);
            wxAppReqDto.setLoginSource(Integer.valueOf(2));
            wxAppReqDto.setStatus(Integer.valueOf(1));
            wxAppReqDto.setThirdparyType(Integer.valueOf(1));
            wxAppReqDto.setKeyAppConfig(JSON.toJSONString((Object)wxAppReqDto));
            this.appSecretApi.create(wxAppReqDto);
        }
    }

    private String getStoreCode(int total) {
        QueryStoreRequest param = new QueryStoreRequest();
        if (total < 10000) {
            total = 10000;
            List currentList = (List)this.payCenterConfigApi.queryStore(param).getData();
            if (null != currentList) {
                total += currentList.size();
            }
        }
        String code = "icommerce-" + total;
        param.setCode(code);
        List storeList = (List)this.payCenterConfigApi.queryStore(param).getData();
        if (CollectionUtils.isNotEmpty((Collection)storeList)) {
            code = this.getStoreCode(++total);
        }
        return code;
    }

    private AppRespDto getApp(Long instanceId, Long tenantId, String storeCode, String payType) {
        AppRespDto app = null;
        QueryAppRequest appParam = new QueryAppRequest();
        appParam.setInstanceId(instanceId);
        appParam.setTenantId(tenantId);
        appParam.setStoreCode(storeCode);
        List apps = (List)this.payCenterConfigApi.queryApp(appParam).getData();
        if (CollectionUtils.isNotEmpty((Collection)apps)) {
            for (AppRespDto appResp : apps) {
                if ("101".equals(payType) && appResp.getCode().contains("is-wx")) {
                    app = appResp;
                }
                if (!"500".equals(payType) || !appResp.getCode().contains("is-ali")) continue;
                app = appResp;
            }
        }
        return app;
    }

    private AppPaytypeRespDto getAppAuth(Long instanceId, Long tenantId, String appCode, String payType) {
        AppPaytypeRespDto appAuth = null;
        QueryAppAuthRequest appAuthParam = new QueryAppAuthRequest();
        appAuthParam.setInstanceId(instanceId);
        appAuthParam.setTenantId(tenantId);
        appAuthParam.setAppCode(appCode);
        appAuthParam.setPayType(payType);
        List appAuthList = (List)this.payCenterConfigApi.queryAppAuth(appAuthParam).getData();
        if (CollectionUtils.isNotEmpty((Collection)appAuthList)) {
            appAuth = (AppPaytypeRespDto)appAuthList.get(0);
        }
        return appAuth;
    }

    private StoreRespDto getStore(Long instanceId, Long tenantId) {
        StoreRespDto store = null;
        QueryStoreRequest param = new QueryStoreRequest();
        param.setInstanceId(instanceId);
        param.setTenantId(tenantId);
        List storeList = (List)this.payCenterConfigApi.queryStore(param).getData();
        if (CollectionUtils.isNotEmpty((Collection)storeList)) {
            store = (StoreRespDto)storeList.get(0);
        }
        return store;
    }

    private String getAppCode(String payType, int total) {
        List currentList;
        QueryAppRequest param = new QueryAppRequest();
        if (total == 0 && null != (currentList = (List)this.payCenterConfigApi.queryApp(param).getData())) {
            total += currentList.size();
        }
        String code = "";
        code = "101".equals(payType) ? "icom-wx-" + total : "icom-ali-" + total;
        param.setCode(code);
        List appList = (List)this.payCenterConfigApi.queryApp(param).getData();
        if (CollectionUtils.isNotEmpty((Collection)appList)) {
            code = this.getAppCode(payType, ++total);
        }
        return code;
    }

    private PartnerConfigRespDto getPayAccount(Long instanceId, Long tenantId, String storeCode, String appCode, String payType) {
        PartnerConfigRespDto account = null;
        QueryAccountRequest accountParam = new QueryAccountRequest();
        accountParam.setInstanceId(instanceId);
        accountParam.setTenantId(tenantId);
        accountParam.setStoreCode(storeCode);
        accountParam.setAppCode(appCode);
        accountParam.setPayType(payType);
        List accountList = (List)this.payCenterConfigApi.queryPayAccount(accountParam).getData();
        if (CollectionUtils.isNotEmpty((Collection)accountList)) {
            account = (PartnerConfigRespDto)accountList.get(0);
        }
        return account;
    }

    private void saveWxH5(Long instanceId, Long tenantId, String storeCode, String appCode, WxAccountReqDto wxAccount) {
        try {
            PartnerConfigRespDto account;
            Optional<PartnerConfigRespDto> accountOpt;
            AppPaytypeRespDto appAuth = this.getAppAuth(instanceId, tenantId, appCode, "104");
            Optional<AppPaytypeRespDto> appAuthOpt = Optional.ofNullable(appAuth);
            if (!appAuthOpt.isPresent()) {
                AppAuthRequest auth = new AppAuthRequest();
                auth.setAppCode(appCode);
                auth.setPartnerCode("102");
                auth.setPayType("104");
                auth.setTenantId(tenantId);
                auth.setInstanceId(instanceId);
                this.payCenterConfigApi.createAppAuth(auth);
            }
            if (!(accountOpt = Optional.ofNullable(account = this.getPayAccount(instanceId, tenantId, storeCode, appCode, "104"))).isPresent()) {
                PayAccountRequest newAccount = new PayAccountRequest();
                newAccount.setPartnerCode("102");
                newAccount.setPayType("104");
                newAccount.setStoreCode(storeCode);
                newAccount.setAppCode(appCode);
                newAccount.setStatus("U");
                newAccount.setPtMerId(wxAccount.getMerchantNum());
                newAccount.setPtAccount(wxAccount.getAppId());
                newAccount.setPtPubKey(wxAccount.getPaySecretKey());
                newAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                newAccount.setInstanceId(instanceId);
                newAccount.setTenantId(tenantId);
                this.payCenterConfigApi.createPayAccount(newAccount);
            } else {
                UpdateAccountRequest updateAccount = new UpdateAccountRequest();
                BeanUtils.copyProperties((Object)account, (Object)updateAccount);
                updateAccount.setStoreCode(storeCode);
                updateAccount.setAppCode(appCode);
                updateAccount.setPtMerId(wxAccount.getMerchantNum());
                updateAccount.setPtAccount(wxAccount.getAppId());
                updateAccount.setPtPubKey(wxAccount.getPaySecretKey());
                updateAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                this.payCenterConfigApi.updatePayAccount(account.getId(), updateAccount);
            }
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1H5\u652f\u4ed8\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u5fae\u4fe1H5\u652f\u4ed8\u914d\u7f6e\u5931\u8d25");
        }
    }

    private void saveWxCode(Long instanceId, Long tenantId, String storeCode, String appCode, WxAccountReqDto wxAccount) {
        try {
            PartnerConfigRespDto account;
            Optional<PartnerConfigRespDto> accountOpt;
            AppPaytypeRespDto appAuth = this.getAppAuth(instanceId, tenantId, appCode, "100");
            Optional<AppPaytypeRespDto> appAuthOpt = Optional.ofNullable(appAuth);
            if (!appAuthOpt.isPresent()) {
                AppAuthRequest auth = new AppAuthRequest();
                auth.setAppCode(appCode);
                auth.setPartnerCode("102");
                auth.setPayType("100");
                auth.setTenantId(tenantId);
                auth.setInstanceId(instanceId);
                this.payCenterConfigApi.createAppAuth(auth);
            }
            if (!(accountOpt = Optional.ofNullable(account = this.getPayAccount(instanceId, tenantId, storeCode, appCode, "100"))).isPresent()) {
                PayAccountRequest newAccount = new PayAccountRequest();
                newAccount.setPartnerCode("102");
                newAccount.setPayType("100");
                newAccount.setStoreCode(storeCode);
                newAccount.setAppCode(appCode);
                newAccount.setStatus("U");
                newAccount.setPtMerId(wxAccount.getMerchantNum());
                newAccount.setPtAccount(wxAccount.getAppId());
                newAccount.setPtPubKey(wxAccount.getPaySecretKey());
                newAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                newAccount.setInstanceId(instanceId);
                newAccount.setTenantId(tenantId);
                this.payCenterConfigApi.createPayAccount(newAccount);
            } else {
                UpdateAccountRequest updateAccount = new UpdateAccountRequest();
                BeanUtils.copyProperties((Object)account, (Object)updateAccount);
                updateAccount.setStoreCode(storeCode);
                updateAccount.setAppCode(appCode);
                updateAccount.setPtMerId(wxAccount.getMerchantNum());
                updateAccount.setPtAccount(wxAccount.getAppId());
                updateAccount.setPtPubKey(wxAccount.getPaySecretKey());
                updateAccount.setPtQueryKey(wxAccount.getPaySecretKey());
                this.payCenterConfigApi.updatePayAccount(account.getId(), updateAccount);
            }
        }
        catch (Exception e) {
            logger.error("\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u5fae\u4fe1\u626b\u7801\u652f\u4ed8\u914d\u7f6e\u5931\u8d25");
        }
    }

    public void saveAliAccount(AliAccountReqDto aliAccount) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        this.checkAliAccountParam(aliAccount);
        try {
            PartnerConfigRespDto account;
            Optional<PartnerConfigRespDto> accountOpt;
            AppRespDto app;
            Optional<AppRespDto> appOpt;
            StoreRespDto store = this.getStore(instanceId, tenantId);
            Optional<StoreRespDto> storeOpt = Optional.ofNullable(store);
            if (!storeOpt.isPresent()) {
                StoreRequest newStore = new StoreRequest();
                String code = this.getStoreCode(0);
                newStore.setCode(code);
                newStore.setApiSecret(instanceId.toString());
                newStore.setInstanceId(instanceId);
                newStore.setTenantId(tenantId);
                Long storeId = (Long)this.payCenterConfigApi.createStore(newStore).getData();
                store = (StoreRespDto)this.payCenterConfigApi.queryStoreById(storeId).getData();
            }
            if (!(appOpt = Optional.ofNullable(app = this.getApp(instanceId, tenantId, store.getCode(), "500"))).isPresent()) {
                AppRequest newApp = new AppRequest();
                String appCode = this.getAppCode("500", 0);
                newApp.setCode(appCode);
                newApp.setName(aliAccount.getMerchantName());
                newApp.setStatus("U");
                newApp.setIsAutoClosePtOrder(Integer.valueOf(0));
                newApp.setIsAllowResubmit(Integer.valueOf(1));
                newApp.setIsCloseOrder(Integer.valueOf(1));
                newApp.setInstanceId(instanceId);
                newApp.setTenantId(tenantId);
                Long appId = (Long)this.payCenterConfigApi.createApp(store.getCode(), newApp).getData();
                app = (AppRespDto)this.payCenterConfigApi.queryAppById(appId).getData();
            } else {
                UpdateAppRequest updateApp = new UpdateAppRequest();
                BeanUtils.copyProperties((Object)app, (Object)updateApp);
                updateApp.setName(aliAccount.getMerchantName());
                this.payCenterConfigApi.updateApp(app.getId(), updateApp);
            }
            AppPaytypeRespDto appAuth = this.getAppAuth(instanceId, tenantId, app.getCode(), "500");
            Optional<AppPaytypeRespDto> appAuthOpt = Optional.ofNullable(appAuth);
            if (!appAuthOpt.isPresent()) {
                AppAuthRequest auth = new AppAuthRequest();
                auth.setAppCode(app.getCode());
                auth.setPartnerCode("103");
                auth.setPayType("500");
                auth.setTenantId(tenantId);
                auth.setInstanceId(instanceId);
                this.payCenterConfigApi.createAppAuth(auth);
            }
            if (!(accountOpt = Optional.ofNullable(account = this.getPayAccount(instanceId, tenantId, store.getCode(), app.getCode(), "500"))).isPresent()) {
                PayAccountRequest acc = new PayAccountRequest();
                acc.setPartnerCode("103");
                acc.setPayType("500");
                acc.setStoreCode(store.getCode());
                acc.setAppCode(app.getCode());
                acc.setStatus("U");
                acc.setPtMerId("1");
                acc.setPtAccount(aliAccount.getEnterpriseAccount());
                acc.setPtPubKey(aliAccount.getAlipayPubKey());
                acc.setPtQueryKey(aliAccount.getAlipayPubKey());
                acc.setLcPrivKey(aliAccount.getAppPriKey());
                acc.setLcPubKey(aliAccount.getAppPubKey());
                acc.setInstanceId(instanceId);
                acc.setTenantId(tenantId);
                this.payCenterConfigApi.createPayAccount(acc);
            } else {
                UpdateAccountRequest updateAccount = new UpdateAccountRequest();
                BeanUtils.copyProperties((Object)account, (Object)updateAccount);
                updateAccount.setStoreCode(store.getCode());
                updateAccount.setAppCode(app.getCode());
                updateAccount.setPtAccount(aliAccount.getEnterpriseAccount());
                updateAccount.setPtPubKey(aliAccount.getAlipayPubKey());
                updateAccount.setPtQueryKey(aliAccount.getAlipayPubKey());
                updateAccount.setLcPrivKey(aliAccount.getAppPriKey());
                updateAccount.setLcPubKey(aliAccount.getAppPubKey());
                this.payCenterConfigApi.updatePayAccount(account.getId(), updateAccount);
            }
        }
        catch (Exception e) {
            logger.error("\u652f\u4ed8\u5b9d\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new BusinessRuntimeException("\u652f\u4ed8\u5b9d\u53f7\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public Boolean locationConfig() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(null, "com.dtyunxi.yundt.module.admin.location");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u533a\u57df\u5b50\u7ad9\u6a21\u5f0f\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
        if (null == configItem) {
            logger.info("\u533a\u57df\u5b50\u7ad9\u6a21\u5f0f\u672a\u8bbe\u7f6e\uff0c\u9ed8\u8ba4true\u5f00\u542f");
            return false;
        }
        return Boolean.valueOf(configItem.getValue());
    }

    private void checkAliAccountParam(AliAccountReqDto aliAccount) {
        if (null == aliAccount) {
            throw new BusinessRuntimeException("\u652f\u4ed8\u5b9d\u53f7\u6536\u6b3e\u8d26\u53f7\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)aliAccount.getAlipayPubKey())) {
            throw new BusinessRuntimeException("\u652f\u4ed8\u5b9d\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)aliAccount.getAppPriKey())) {
            throw new BusinessRuntimeException("\u5e94\u7528\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)aliAccount.getEnterpriseAccount())) {
            throw new BusinessRuntimeException("\u5e94\u7528\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)aliAccount.getMerchantName())) {
            throw new BusinessRuntimeException("\u652f\u4ed8\u5b9d\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        aliAccount.setAlipayPubKey(aliAccount.getAlipayPubKey().trim());
        aliAccount.setAppPriKey(aliAccount.getAppPriKey().trim());
        aliAccount.setAppPubKey(aliAccount.getAppPubKey().trim());
        aliAccount.setEnterpriseAccount(aliAccount.getEnterpriseAccount().trim());
        aliAccount.setMerchantName(aliAccount.getMerchantName().trim());
    }
}

