/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.module.bitem.api.IBCategoryService;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.bo.CategoryBo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BCategoryServiceImpl
implements IBCategoryService {
    private static final Logger logger = LoggerFactory.getLogger(BCategoryServiceImpl.class);
    @Autowired
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Autowired
    private IContext context;
    @Resource
    private IBitemService bitemService;
    public final Integer SHOW_DISABLE = 1;

    public List<CategoryBo> queryTree(String dirUsage) {
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setDirUsage(dirUsage);
        rootDirectoryReqDto.setInstanceId(this.context.instanceId());
        rootDirectoryReqDto.setTenantId(this.context.tenantId());
        String filter = ObjectHelper.bean2Json((Object)rootDirectoryReqDto);
        List treeList = (List)this.directoryQueryApi.queryDirectoryTreeByFilter(filter).getData();
        if (CollectionUtils.isEmpty((Collection)treeList)) {
            return null;
        }
        ArrayList dirList = Lists.newArrayList();
        this.tree2List(dirList, treeList);
        List<CategoryBo> categoryBoList = dirList.stream().map(dirDto -> (CategoryBo)ConvertUtil.convert((Object)dirDto, CategoryBo.class)).collect(Collectors.toList());
        return this.toTree(categoryBoList);
    }

    public Map<String, Object> queryList(RootDirectoryReqDto rootDirectoryReqDto, Integer showDisable, Long customerId) {
        HashMap resultMap = Maps.newHashMap();
        rootDirectoryReqDto.setInstanceId(this.context.instanceId());
        rootDirectoryReqDto.setTenantId(this.context.tenantId());
        String filters = JSONObject.toJSONString((Object)rootDirectoryReqDto);
        List result = (List)this.directoryQueryApi.queryDirectoryTreeByFilter(filters).getData();
        if (null == result) {
            resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
            resultMap.put("tree", null);
            return resultMap;
        }
        if (!this.SHOW_DISABLE.equals(showDisable)) {
            this.filterDisable(result);
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            this.setLevel(result, null);
        }
        resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
        resultMap.put("tree", result);
        return resultMap;
    }

    void filterDisable(List<TreeDto<DirectoryItemRespDto>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        Iterator<TreeDto<DirectoryItemRespDto>> iterator = sourceList.iterator();
        while (iterator.hasNext()) {
            TreeDto<DirectoryItemRespDto> itemRespDto = iterator.next();
            if (itemRespDto.getNode() == null || ((DirectoryItemRespDto)itemRespDto.getNode()).getStatus() == null || !((DirectoryItemRespDto)itemRespDto.getNode()).getStatus().equals(StatusEnum.DISABLED.getStatus())) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        for (TreeDto<DirectoryItemRespDto> dirTreeDto : sourceList) {
            this.filterDisable(dirTreeDto.getChildren());
        }
    }

    public void setLevel(List<TreeDto<DirectoryItemRespDto>> sourceList, List<Long> productTypeIds) {
        for (TreeDto<DirectoryItemRespDto> dirTreeDto : sourceList) {
            int i = 1;
            ((DirectoryItemRespDto)dirTreeDto.getNode()).setExtension(String.valueOf(i));
            if (CollectionUtils.isNotEmpty(productTypeIds)) {
                if (productTypeIds.contains(((DirectoryItemRespDto)dirTreeDto.getNode()).getId())) {
                    if (dirTreeDto.getChildren() == null) continue;
                    for (TreeDto childTreeDto : dirTreeDto.getChildren()) {
                        i = 2;
                        ((DirectoryItemRespDto)childTreeDto.getNode()).setExtension(String.valueOf(i));
                        if (childTreeDto.getChildren() == null) continue;
                        i = 3;
                        for (TreeDto grandTreeDto : childTreeDto.getChildren()) {
                            ((DirectoryItemRespDto)grandTreeDto.getNode()).setExtension(String.valueOf(i));
                        }
                    }
                    continue;
                }
                if (dirTreeDto.getChildren() == null) continue;
                Iterator twoIterator = dirTreeDto.getChildren().iterator();
                ArrayList newTwoDir = Lists.newArrayList();
                while (twoIterator.hasNext()) {
                    TreeDto childTreeDto = (TreeDto)twoIterator.next();
                    i = 2;
                    ((DirectoryItemRespDto)childTreeDto.getNode()).setExtension(String.valueOf(i));
                    if (productTypeIds.contains(((DirectoryItemRespDto)childTreeDto.getNode()).getId())) {
                        if (childTreeDto.getChildren() == null) continue;
                        i = 3;
                        for (TreeDto grandTreeDto : childTreeDto.getChildren()) {
                            ((DirectoryItemRespDto)grandTreeDto.getNode()).setExtension(String.valueOf(i));
                        }
                        continue;
                    }
                    if (childTreeDto.getChildren() != null) {
                        i = 3;
                        for (TreeDto grandTreeDto : childTreeDto.getChildren()) {
                            ((DirectoryItemRespDto)grandTreeDto.getNode()).setExtension(String.valueOf(i));
                            if (!productTypeIds.contains(((DirectoryItemRespDto)grandTreeDto.getNode()).getId())) continue;
                            newTwoDir.add(grandTreeDto);
                        }
                    }
                    twoIterator.remove();
                }
                if (!CollectionUtils.isNotEmpty((Collection)newTwoDir)) continue;
                dirTreeDto.getChildren().addAll(newTwoDir);
                continue;
            }
            if (dirTreeDto.getChildren() == null) continue;
            for (TreeDto childTreeDto : dirTreeDto.getChildren()) {
                i = 2;
                ((DirectoryItemRespDto)childTreeDto.getNode()).setExtension(String.valueOf(i));
                if (childTreeDto.getChildren() == null) continue;
                i = 3;
                for (TreeDto grandTreeDto : childTreeDto.getChildren()) {
                    ((DirectoryItemRespDto)grandTreeDto.getNode()).setExtension(String.valueOf(i));
                }
            }
        }
    }

    private void tree2List(List<DirectoryItemRespDto> dirList, List<TreeDto<DirectoryItemRespDto>> treeList) {
        for (TreeDto<DirectoryItemRespDto> treeDto : treeList) {
            dirList.add((DirectoryItemRespDto)treeDto.getNode());
            if (null == treeDto.getChildren()) continue;
            this.tree2List(dirList, treeDto.getChildren());
        }
    }

    private List<CategoryBo> toTree(List<CategoryBo> categoryBoList) {
        ArrayList treeList = Lists.newArrayList();
        for (CategoryBo tree : categoryBoList) {
            if (!tree.getParentId().equals(0L)) continue;
            treeList.add(tree);
        }
        for (CategoryBo tree : categoryBoList) {
            this.toTreeChildren(treeList, tree);
        }
        return treeList;
    }

    private void toTreeChildren(List<CategoryBo> treeList, CategoryBo tree) {
        for (CategoryBo node : treeList) {
            if (tree.getParentId().equals(node.getId())) {
                if (node.getChildren() == null) {
                    node.setChildren((List)Lists.newArrayList());
                }
                node.getChildren().add(tree);
            }
            if (node.getChildren() == null) continue;
            this.toTreeChildren(node.getChildren(), tree);
        }
    }

    public CategoryBo getById(Long categoryId) {
        CategoryBo categoryBo = null;
        DirectoryItemRespDto directoryItemRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(categoryId).getData();
        if (null != directoryItemRespDto) {
            categoryBo = (CategoryBo)ConvertUtil.convert((Object)directoryItemRespDto, CategoryBo.class);
            if (categoryBo.getParentId() == 0L) {
                categoryBo.setParentName("\u6839\u5143\u7d20");
            } else {
                directoryItemRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(categoryBo.getParentId()).getData();
                if (directoryItemRespDto != null) {
                    categoryBo.setParentName(directoryItemRespDto.getName());
                }
            }
        }
        return categoryBo;
    }

    public Map<Long, String> getDirParent(Long dirId) {
        DirectoryItemRespDto directoryRespDto;
        Long reqParam = dirId;
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        Long parentId = -1L;
        while (parentId != null && parentId != 0L && (parentId = (directoryRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(reqParam).getData()).getParentId()) != 0L) {
            resultMap.put(directoryRespDto.getId(), directoryRespDto.getName());
            reqParam = parentId;
        }
        return resultMap;
    }

    public List<Long> getDirListParent(Long dirId) {
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        Map<Long, String> dirMap = this.getDirParent(dirId);
        for (Map.Entry<Long, String> entry : dirMap.entrySet()) {
            dirIdList.add(entry.getKey());
        }
        Collections.reverse(dirIdList);
        return dirIdList;
    }
}

