/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.bitem.biz.handler;

import cn.hutool.core.collection.CollUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.bitem.api.dto.response.BitemInfoDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BitemHandler {
    private static final Logger log = LoggerFactory.getLogger(BitemHandler.class);
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public BitemInfoDto getShopRelationInfo(List<Long> shopIdList) {
        BitemInfoDto bitemInfoDto = new BitemInfoDto();
        if (CollUtil.isEmpty(shopIdList)) {
            return bitemInfoDto;
        }
        List shopList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIdList)));
        if (CollUtil.isEmpty((Collection)shopList)) {
            return bitemInfoDto;
        }
        bitemInfoDto.setShopSellerMap(shopList.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getSellerId, (o1, o2) -> o2)));
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(bitemInfoDto.getShopSellerMap().values().stream().collect(Collectors.toList()));
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
        if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
            return bitemInfoDto;
        }
        bitemInfoDto.setSellerOrgMap(sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, SellerRespDto::getOrganizationId, (o1, o2) -> o2)));
        Long currentUserOrgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListByOrgIds(bitemInfoDto.getSellerOrgMap().values().stream().collect(Collectors.toList())));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return bitemInfoDto;
        }
        Map orgCustomerMap = customerRespDtos.stream().filter(customerDto -> Objects.equals(currentUserOrgId, customerDto.getOrgInfoId())).collect(Collectors.groupingBy(CustomerRespDto::getMerchantId, Collectors.mapping(BaseRespDto::getId, Collectors.toList())));
        bitemInfoDto.setOrgCustomerMap(orgCustomerMap);
        log.info("[\u4ef7\u683c\u67e5\u8be2] >>> \u5e97\u94fa{}\u5bf9\u4e8e\u5f53\u524d\u5c0fB\u767b\u5f55\u8005\u7ec4\u7ec7id:[{}]\u83b7\u53d6\u5bf9\u5e94\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u5ba2\u6237\u5173\u7cfb\u5982\u4e0b\uff1a{}\uff1b\u5e97\u94fa\u4e0b\u7684\u5c0fB\u5bf9\u5e94\u5173\u7cfb\uff1a{}", new Object[]{shopList.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getName, (o1, o2) -> o2)), currentUserOrgId, orgCustomerMap, bitemInfoDto.getShopCustomerMap()});
        return bitemInfoDto;
    }
}

