/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition.coupon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.CouponTemplateItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.BlackItemSkuDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.AbstractBaseTemplate;
import com.dtyunxi.yundt.module.marketing.biz.constant.MarketingConstant;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CouponBlackSkuCondition
extends AbstractBaseTemplate {
    @Override
    protected <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        IItemQueryApi itemQueryApi = (IItemQueryApi)SpringBeanUtil.getBean(IItemQueryApi.class);
        CouponTemplateDetailRespDto couponDetail = (CouponTemplateDetailRespDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List items = JSON.parseArray((String)jsonObject.getString("CouponBlackSkuCondition.items"), CouponTemplateItemSkuDto.class);
        ArrayList itemList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            Set itemIdList = items.stream().map(CouponTemplateItemSkuDto::getItemCode).collect(Collectors.toSet());
            List skuIdList = items.stream().map(CouponTemplateItemSkuDto::getSkuId).collect(Collectors.toList());
            List itemRespDtos = (List)itemQueryApi.queryByItemIds(StringUtils.join(itemIdList, (String)",")).getData();
            List skuRespDtos = (List)itemQueryApi.queryItemSkus(skuIdList).getData();
            Map<Long, ItemRespDto> itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, item -> item, (e1, e2) -> e1));
            Map<Long, ItemSkuRespDto> skuMap = skuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, sku -> sku, (e1, e2) -> e1));
            items.forEach(couponItem -> {
                ItemRespDto itemRespDto = (ItemRespDto)itemMap.get(Long.valueOf(couponItem.getItemCode()));
                ItemSkuRespDto skuRespDto = (ItemSkuRespDto)skuMap.get(couponItem.getSkuId());
                if (Objects.nonNull(itemRespDto) && Objects.nonNull(skuRespDto)) {
                    BlackItemSkuDto blackItemSkuDto = new BlackItemSkuDto();
                    blackItemSkuDto.setItemId(Long.valueOf(couponItem.getItemCode()));
                    blackItemSkuDto.setItemCode(itemRespDto.getCode());
                    blackItemSkuDto.setItemName(itemRespDto.getName());
                    blackItemSkuDto.setSkuId(couponItem.getSkuId());
                    blackItemSkuDto.setAttr(skuRespDto.getAttr());
                    blackItemSkuDto.setShopId(couponItem.getShopId());
                    Map skuAttr = (Map)ObjectHelper.Json2Bean((String)skuRespDto.getAttr(), Map.class);
                    if (null != skuAttr) {
                        String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
                        blackItemSkuDto.setSkuDesc(skuDesc);
                    }
                    itemList.add(blackItemSkuDto);
                }
            });
        }
        couponDetail.setBlackItems((List)itemList);
    }

    @Override
    public long getConditionTemplateId() {
        return MarketingConstant.CONDITION_BLACK_SKU_TP_ID;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.COUPON_TOB_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityTobDto> ConditionReqDto convertToCondition(T t) {
        return null;
    }
}

