/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRuleItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.enums.ActivityCodePreEnum;
import com.dtyunxi.yundt.module.marketing.biz.action.AbstractActionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.action.ActionFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.config.MarketingTobConfig;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractActivityService {
    private static Logger logger = LoggerFactory.getLogger(AbstractActivityService.class);
    @Autowired
    private IActivityExtApi activityExtApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;

    public <T extends BaseActivityTobDto> Long addActivity(T activityReqDto) {
        RestResponse restResponse;
        this.validateTime(activityReqDto);
        this.validateStorage(activityReqDto);
        if (activityReqDto.getShopId() != null) {
            IShopExtQueryApi shopExtQueryApi = (IShopExtQueryApi)SpringBeanUtil.getBean(IShopExtQueryApi.class);
            RestResponse shopDtoRestResponse = shopExtQueryApi.queryBaseById(activityReqDto.getShopId());
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)shopDtoRestResponse);
            if (shopDto == null) {
                throw new BizException("\u9009\u62e9\u5e97\u94fa\u5df2\u88ab\u7981\u7528\u6216\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5");
            }
            activityReqDto.setOrganizationId(shopDto.getOrganizationId());
            activityReqDto.setOrganizationName(shopDto.getOrganizationName());
        }
        ActivityCreateReqDto activityCreateReqDto = new ActivityCreateReqDto();
        IActivityApi activityApi = (IActivityApi)SpringBeanUtil.getBean(IActivityApi.class);
        ActivityDto activityDto = new ActivityDto();
        CubeBeanUtils.copyProperties((Object)activityDto, activityReqDto, (String[])new String[0]);
        activityDto.setActivityTemplateId(Long.valueOf(activityReqDto.getActivityType().getId()));
        activityDto.setAuditStatusEnum(AuditStatusEnum.WAIT_AUDIT);
        activityDto.setActivityStatusEnum(ActivityStatusEnum.NEW);
        activityDto.setShopId(activityReqDto.getShopId());
        List<ActivityItemReqDto> activityItems = this.getActivityItems(activityReqDto);
        List conditions = ActivityFactory.getActivityTemplate(activityReqDto.getActivityType()).stream().map(conditionTemplate -> conditionTemplate.convertToCondition(activityReqDto)).collect(Collectors.toList());
        List actions = ActionFactory.getActionTemplate(activityReqDto.getActivityType()).stream().map(AbstractActionTemplate::getActionReqDto).collect(Collectors.toList());
        ArrayList activityRelations = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)activityRelations, (Collection)activityReqDto.getActivityRelations(), ActivityRelationReqDto.class);
        activityCreateReqDto.setActivityRuleItems(this.getActivityRuleItems(activityReqDto));
        activityCreateReqDto.setActivityRelations((List)activityRelations);
        activityCreateReqDto.setActivityDto(activityDto);
        activityCreateReqDto.setActivityItems(activityItems);
        activityCreateReqDto.setConditions(conditions);
        activityCreateReqDto.setActions(actions);
        Long activityId = activityReqDto.getId();
        if (!(activityReqDto.getId() == null || activityReqDto.getDBActivityFlag() != null && activityReqDto.getDBActivityFlag().booleanValue())) {
            logger.info("\u975e\u5927b\u6362\u8d2d\u6d3b\u52a8\u4fee\u6539");
            IActivityExtQueryApi activityExtQueryApi = (IActivityExtQueryApi)SpringBeanUtil.getBean(IActivityExtQueryApi.class);
            ActivityRespDto activityRespDto = (ActivityRespDto)RestResponseHelper.extractData((RestResponse)activityExtQueryApi.queryActivityById(activityId));
            if (ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus()) || ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus())) {
                activityDto.setId(null);
                activityDto.setActivityCode(this.marketingModuleHelper.generateCode(ActivityCodePreEnum.getCodePre((Long)activityDto.getActivityTemplateId())));
                activityDto.setOriginalActivityId(activityId);
                activityDto.setFirstActivityId(activityRespDto.getFirstActivityId() != null ? activityRespDto.getFirstActivityId() : activityId);
            }
        } else if (activityReqDto.getId() != null) {
            logger.info("\u5927b\u6362\u8d2d\u6d3b\u52a8\u4fee\u6539");
        }
        if (activityDto.getId() == null) {
            logger.info("AbstractActivityService addActivity:{}", (Object)JSON.toJSONString((Object)activityCreateReqDto));
            restResponse = activityApi.add(activityCreateReqDto);
            Long id = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
            RestResponseHelper.extractData((RestResponse)this.activityExtApi.saveSingleItemByActivity(id));
            return id;
        }
        logger.info("AbstractActivityService modifyActivity:{}", (Object)JSON.toJSONString((Object)activityCreateReqDto));
        restResponse = activityApi.modifyById(activityReqDto.getId().longValue(), activityCreateReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        return null;
    }

    private void subStorage(List<ActivityItemReqDto> activityItems) {
        MarketingTobConfig marketingTobConfig = (MarketingTobConfig)SpringBeanUtil.getBean(MarketingTobConfig.class);
        if (2 == marketingTobConfig.getStorageShareType() && CollectionUtils.isNotEmpty(activityItems)) {
            IItemStorageApi itemStorageApi = (IItemStorageApi)SpringBeanUtil.getBean(IItemStorageApi.class);
            List returnItemStockList = activityItems.stream().map(activityItemRespDto -> {
                ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                itemStorageReqDto.setSkuId(activityItemRespDto.getSkuId());
                itemStorageReqDto.setShopId(activityItemRespDto.getShopId());
                itemStorageReqDto.setBalance(Long.valueOf(-activityItemRespDto.getOriginalStock().longValue()));
                return itemStorageReqDto;
            }).collect(Collectors.toList());
            BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
            batchItemStorageReqDto.setItemStorageReqDtoList(returnItemStockList);
            batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.SUB);
            RestResponse batchItemStorageRespDtoRestResponse = itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
            if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
                throw new BizException(batchItemStorageRespDtoRestResponse.getResultCode(), batchItemStorageRespDtoRestResponse.getResultMsg());
            }
        }
    }

    private <T extends BaseActivityTobDto> void validateStorage(T activityReqDto) {
        MarketingTobConfig marketingTobConfig = (MarketingTobConfig)SpringBeanUtil.getBean(MarketingTobConfig.class);
        if (2 == marketingTobConfig.getStorageShareType() && CollectionUtils.isNotEmpty((Collection)activityReqDto.getActivityItems())) {
            activityReqDto.getActivityItems().stream().forEach(bean -> {
                if (null == bean.getActivityStock()) {
                    throw new BizException("\u72ec\u7acb\u5e93\u5b58\u6a21\u5f0f\u4e0b\uff0c\u6d3b\u52a8\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
    }

    private <T extends BaseActivityTobDto> void validateTime(T activityReqDto) {
        if (activityReqDto.getBeginTime().compareTo(activityReqDto.getEndTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        }
        if (new Date().compareTo(activityReqDto.getEndTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (null != activityReqDto.getPreheatStartTime() && activityReqDto.getPreheatStartTime().compareTo(activityReqDto.getBeginTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u9884\u70ed\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        }
    }

    protected abstract <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T var1);

    protected <T extends BaseActivityTobDto> List<ActivityRuleItemReqDto> getActivityRuleItems(T activityReqDto) {
        return null;
    }

    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        return null;
    }

    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        return null;
    }

    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        return null;
    }
}

