/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActBacktrackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRuleItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.marketing.api.IActivityService;
import com.dtyunxi.yundt.module.marketing.api.ICombinationActivity;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ActivityCustomerDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.ApplicableActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationActivityDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationBatch;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.CombinationRuleContent;
import com.dtyunxi.yundt.module.marketing.api.dto.request.combination.GCombination;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.module.marketing.api.dto.response.CombinationListQueryRespDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ActivityFactory;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.module.marketing.biz.condition.combination.CombinationCondition;
import com.dtyunxi.yundt.module.marketing.biz.impl.AbstractActivityService;
import com.dtyunxi.yundt.module.marketing.biz.impl.MarketingModuleHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CombinationActivityImpl
extends AbstractActivityService
implements ICombinationActivity {
    private static Logger logger = LoggerFactory.getLogger(CombinationActivityImpl.class);
    @Autowired
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IActivityApi activityApi;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IActivityService activityService;
    @Resource
    private IConditionQueryApi conditionQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IWarehouseQueryApi warehouseQueryApi;

    public Long add(CombinationActivityDto activityReqDto) {
        if (!ActivityType.COMBINATION_ACTIVITY.equals((Object)activityReqDto.getActivityType())) {
            throw new BizException("\u6d3b\u52a8\u7c7b\u578b\u975e\u4f18\u60e0\u5957\u88c5!");
        }
        this.checkBatchs(activityReqDto);
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("TC"));
        Long activityId = this.addActivity(activityReqDto);
        return activityId;
    }

    public void modify(CombinationActivityDto activityReqDto) {
        Assert.notNull((Object)activityReqDto.getId(), (String)"\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)activityReqDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkBatchs(activityReqDto);
        this.addActivity(activityReqDto);
    }

    public void audit(Long id, ActivityAuditReqDto activityAuditReqDto) {
        activityAuditReqDto.setAuditPerson(this.context.userId());
        activityAuditReqDto.setTenantId(this.context.tenantId());
        activityAuditReqDto.setInstanceId(this.context.instanceId());
        activityAuditReqDto.setParentAuditPerson(activityAuditReqDto.getAuditPerson());
        if (AuditStatusEnum.AUDIT_PASS.getKey().equals(activityAuditReqDto.getAuditStatus())) {
            try {
                CombinationActivityDto combinationActivityDto = this.getDetail(id);
                logger.info("\u4f18\u60e0\u5957\u88c5\u4fee\u6539\u6d3b\u52a8\u9884\u5360\uff1a{}", (Object)combinationActivityDto);
                this.combinationActPreempt(combinationActivityDto, combinationActivityDto.getId());
                this.activityApi.auditById(id.longValue(), activityAuditReqDto);
                this.activityApi.enableById(id.longValue());
            }
            catch (Exception e) {
                logger.error("\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u9884\u5360\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
                throw new BizException("\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u9884\u5360\u5931\u8d25!" + e.getMessage());
            }
        } else {
            this.activityApi.auditById(id.longValue(), activityAuditReqDto);
        }
    }

    public void finish(Long id) {
        ActivityRespDto activityRespDto = this.checkActivity(id);
        if (ActivityStatusEnum.FINISH.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff01");
        }
        if (ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus())) {
            logger.info("\u5c31\u7b97\u662f\u672a\u5f00\u59cb\u7684\u6d3b\u52a8 \u4e5f\u5360\u7528\u4e86\u5e93\u5b58 \u6240\u4ee5\u8981\u91ca\u653e\u5e93\u5b58\u554a \u4e0d\u8d70\u8fd9\u4e2a\u903b\u8f91\u8d70\u4e0b\u9762\u91ca\u653e\u5e93\u5b58\u7684\u903b\u8f91");
        }
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus())) {
            // empty if block
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.finishById(id.longValue()));
        try {
            logger.info("\u4f18\u60e0\u5957\u88c5\u53d6\u6d88\u9884\u5360\uff1a{}", (Object)activityRespDto);
            this.backtrackInventory(activityRespDto);
        }
        catch (Exception e) {
            logger.error("\u7ed3\u675f\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u5931\u8d25", (Throwable)e);
            throw new BizException("\u7ed3\u675f\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u5931\u8d25!");
        }
    }

    public CombinationActivityDto getDetail(Long id) {
        List activityResp;
        RestResponse shopBaseDtoRestResponse;
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        CombinationActivityDto combinationActivityDto = new CombinationActivityDto();
        CubeBeanUtils.copyProperties((Object)combinationActivityDto, (Object)activityRespDto, (String[])new String[0]);
        Long shopId = combinationActivityDto.getShopId();
        if (Objects.nonNull(shopId) && Objects.nonNull(shopBaseDtoRestResponse = this.shopQueryApi.queryBaseById(shopId)) && Objects.nonNull(shopBaseDtoRestResponse.getData())) {
            combinationActivityDto.setShopName(((ShopBaseDto)shopBaseDtoRestResponse.getData()).getName());
        }
        combinationActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(combinationActivityDto.getActivityType());
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), combinationActivityDto));
        if (AuditStatusEnum.AUDIT_REFUSE.getKey().equals(activityRespDto.getAuditStatus()) && CollectionUtils.isNotEmpty((Collection)(activityResp = (List)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryAuditData(id.longValue()))))) {
            combinationActivityDto.setActivityAudit((ActivityRespDto)activityResp.stream().findFirst().get());
        }
        this.assembleCustomerInfo(combinationActivityDto, activityRespDto);
        return combinationActivityDto;
    }

    private void assembleCustomerInfo(CombinationActivityDto combinationActivityDto, ActivityRespDto activityRespDto) {
        if (CollectionUtils.isNotEmpty((Collection)activityRespDto.getUserIds())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setIdList(new ArrayList(activityRespDto.getUserIds()));
            PageInfo customers = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (null != customers && CollectionUtils.isNotEmpty((Collection)customers.getList())) {
                List activityCustomerDtos = customers.getList().stream().map(bean -> {
                    ActivityCustomerDto activityCustomerDto = new ActivityCustomerDto();
                    activityCustomerDto.setCustomerId(bean.getId());
                    activityCustomerDto.setCustomerCode(bean.getCode());
                    activityCustomerDto.setCustomerName(bean.getName());
                    activityCustomerDto.setRegion(bean.getRegion());
                    activityCustomerDto.setType(bean.getType());
                    activityCustomerDto.setCustomerTypeName(bean.getCustomerTypeName());
                    activityCustomerDto.setRegionNames(bean.getRegionNames());
                    activityCustomerDto.setStatusName(bean.getStatusName());
                    return activityCustomerDto;
                }).collect(Collectors.toList());
                combinationActivityDto.setActivityCustomers(activityCustomerDtos);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activityRespDto.getCustomerTypeIds())) {
            combinationActivityDto.setCustomerTypeIds((List)JSON.parseObject((String)activityRespDto.getCustomerTypeIds(), (TypeReference)new TypeReference<ArrayList<Long>>(){}, (Feature[])new Feature[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)activityRespDto.getCustomerAreaCodes())) {
            combinationActivityDto.setCustomerAreaCodes((List)JSON.parseObject((String)activityRespDto.getCustomerAreaCodes(), (TypeReference)new TypeReference<ArrayList<String>>(){}, (Feature[])new Feature[0]));
        }
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        CombinationActivityDto activityDto = (CombinationActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (Objects.nonNull(activityDto.getPromotionContent())) {
            List combinationItems = activityDto.getPromotionContent().getCombinationItems();
            ArrayList activityItems = new ArrayList();
            CubeBeanUtils.copyCollection(activityItems, (Collection)combinationItems, ApplicableActivityItemDto.class);
            activityDto.setActivityItems(activityItems);
            combinationItems.forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setActivityStock(Long.valueOf(null != itemDto.getActivityStock() ? itemDto.getActivityStock() : -1L));
                activityItemReqDto.setSkuDesc(itemDto.getSkuDesc());
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                activityItemReqDto.setShopName(itemDto.getShopName());
                activityItemReqDto.setSubType(itemDto.getSubType());
                activityItemReqDto.setSkuId(itemDto.getSkuId());
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<ActivityRuleItemReqDto> getActivityRuleItems(T activityReqDto) {
        CombinationActivityDto activityDto = (CombinationActivityDto)activityReqDto;
        ArrayList activityRuleItems = Lists.newArrayList();
        if (Objects.nonNull(activityDto.getPromotionContent())) {
            List combinationItems = activityDto.getPromotionContent().getCombinationItems();
            combinationItems.forEach(item -> {
                ActivityRuleItemReqDto activityRuleItem = new ActivityRuleItemReqDto();
                CubeBeanUtils.copyProperties((Object)activityRuleItem, (Object)item, (String[])new String[0]);
                activityRuleItem.setShopName(activityDto.getShopName());
                activityRuleItem.setPrice(item.getCombinationPrice());
                activityRuleItem.setNum(item.getCombinationNum());
                activityRuleItems.add(activityRuleItem);
            });
        }
        return activityRuleItems;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getUserIds(T activityReqDto) {
        CombinationActivityDto activityDto = (CombinationActivityDto)activityReqDto;
        if (CollectionUtils.isNotEmpty((Collection)activityDto.getActivityCustomers())) {
            List<Long> customerIds = activityDto.getActivityCustomers().stream().map(ActivityCustomerDto::getCustomerId).collect(Collectors.toList());
            return customerIds;
        }
        return null;
    }

    @Override
    protected <T extends BaseActivityTobDto> List<Long> getCustomerTypes(T activityReqDto) {
        CombinationActivityDto activityDto = (CombinationActivityDto)activityReqDto;
        return activityDto.getCustomerTypeIds();
    }

    @Override
    protected <T extends BaseActivityTobDto> List<String> getCustomerAreaCodes(T activityReqDto) {
        CombinationActivityDto activityDto = (CombinationActivityDto)activityReqDto;
        return activityDto.getCustomerAreaCodes();
    }

    public PageInfo<CombinationListQueryRespDto> queryActivityByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo activityPageInfo = new PageInfo(ListUtil.empty());
        PageInfo pageInfo = this.activityService.queryByPage(activityQueryReqDto, pageNum, pageSize);
        if (Objects.isNull(pageInfo) || CollUtil.isEmpty((Collection)pageInfo.getList())) {
            return activityPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)activityPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List activityList = pageInfo.getList();
        List activityQueryList = activityList.stream().map(item -> {
            CombinationListQueryRespDto activityListQueryRespDto = new CombinationListQueryRespDto();
            BeanUtils.copyProperties((Object)item, (Object)activityListQueryRespDto);
            return activityListQueryRespDto;
        }).collect(Collectors.toList());
        activityPageInfo.setList(activityQueryList);
        Set shopIds = activityList.stream().map(ActivityRespDto::getShopId).collect(Collectors.toSet());
        if (CollUtil.isEmpty(shopIds)) {
            return activityPageInfo;
        }
        RestResponse shopListResponse = this.shopQueryApi.queryByIds(shopIds);
        if (Objects.isNull(shopListResponse) || CollUtil.isEmpty((Collection)((Collection)shopListResponse.getData()))) {
            return activityPageInfo;
        }
        Map shopMap = ((List)shopListResponse.getData()).stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (o1, o2) -> o2));
        List activityIds = activityPageInfo.getList().stream().map(ActivityRespDto::getId).distinct().collect(Collectors.toList());
        List conditionRespDtoList = this.conditionQueryApi.queryConditions(activityIds, new CombinationCondition().getConditionTemplateId());
        Map<Long, List<ConditionRespDto>> activityMap = conditionRespDtoList.stream().collect(Collectors.groupingBy(ConditionRespDto::getActivityId));
        activityPageInfo.getList().forEach(item -> {
            List conditionList;
            if (Objects.nonNull(item.getShopId()) && shopMap.containsKey(item.getShopId())) {
                item.setShopName(((ShopDto)shopMap.get(item.getShopId())).getName());
            }
            if (CollectionUtils.isNotEmpty((Collection)(conditionList = (List)activityMap.get(item.getId())))) {
                GCombination gCombination;
                Map<Long, List<TcbjInventoryActDetailRespDto>> map;
                List<TcbjInventoryActDetailRespDto> list;
                TcbjInventoryActRespDto tcbjInventoryActRespDto;
                CombinationActivityDto combinationActivityDto = new CombinationActivityDto();
                this.parse(item.getId(), (ConditionRespDto)conditionList.get(0), combinationActivityDto);
                item.setCombinationActivityDtos(combinationActivityDto);
                TcbjInventoryActReqDto tcbjInventoryActReqDto = new TcbjInventoryActReqDto();
                tcbjInventoryActReqDto.setActivityId(item.getId());
                logger.info("\u5e93\u5b58\u63a5\u53e3\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)tcbjInventoryActReqDto));
                List tcbjInventoryActRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.inventoryActQuery(tcbjInventoryActReqDto));
                logger.info("\u5e93\u5b58\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tcbjInventoryActRespDtos));
                if (CollectionUtils.isNotEmpty((Collection)tcbjInventoryActRespDtos) && CollectionUtils.isNotEmpty((Collection)(tcbjInventoryActRespDto = (TcbjInventoryActRespDto)tcbjInventoryActRespDtos.get(0)).getDetailRespDtoList()) && CollectionUtils.isNotEmpty(list = (map = tcbjInventoryActRespDto.getDetailRespDtoList().stream().collect(Collectors.groupingBy(TcbjInventoryActDetailRespDto::getCargoId))).get((gCombination = (GCombination)combinationActivityDto.getPromotionContent().getCombinationItems().get(0)).getCargoId()))) {
                    BigDecimal activitySold = list.stream().map(TcbjInventoryActDetailRespDto::getActivitySold).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal activitySurplus = list.stream().map(TcbjInventoryActDetailRespDto::getActivitySurplus).reduce(BigDecimal.ZERO, BigDecimal::add);
                    logger.info("activitySold:{},activitySurplus:{},combinationNum:{},cargoId:{}", new Object[]{activitySold, activitySurplus, gCombination.getCombinationNum(), gCombination.getCargoId()});
                    item.setActivitySold(Long.valueOf(activitySold.divide(new BigDecimal(gCombination.getCombinationNum())).longValue()));
                    item.setActivitySurplus(Long.valueOf(activitySurplus.divide(new BigDecimal(gCombination.getCombinationNum())).longValue()));
                }
            }
        });
        return activityPageInfo;
    }

    public <T extends BaseActivityTobDto> void parse(Long activityId, ConditionRespDto conditionRespDto, T t) {
        CombinationActivityDto combinationActivityDto = (CombinationActivityDto)t;
        List<WarehouseRespDto> warehouseRespDtos = this.queryWarehouseByOrgIds(Lists.newArrayList((Object[])new Long[]{combinationActivityDto.getOrganizationId()}));
        WarehouseRespDto warehouse = warehouseRespDtos.get(0);
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        CombinationRule combinationRule = (CombinationRule)JSON.parseObject((String)jsonObject.getString("CombinationCondition.rule"), CombinationRule.class);
        combinationActivityDto.setThresholdType(combinationRule.getThresholdType());
        combinationActivityDto.setPromotionType(combinationRule.getPromotionType());
        ComRuleContentDto contents = combinationRule.getComRuleContent();
        if (Objects.nonNull(contents)) {
            TcbjInventoryActReqDto inventoryActReqDto = new TcbjInventoryActReqDto();
            inventoryActReqDto.setActivityId(combinationActivityDto.getId());
            CombinationRuleContent combinationRuleContent = new CombinationRuleContent();
            CubeBeanUtils.copyProperties((Object)combinationRuleContent, (Object)contents, (String[])new String[0]);
            ArrayList combinationItems = Lists.newArrayList();
            contents.getCombinationItems().forEach(comItemDto -> {
                GCombination gCombination = new GCombination();
                CubeBeanUtils.copyProperties((Object)gCombination, (Object)comItemDto, (String[])new String[0]);
                logger.info("comItemDto:{},{}", comItemDto, (Object)gCombination);
                ArrayList batchs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)batchs, (Collection)comItemDto.getBatchs(), CombinationBatch.class);
                gCombination.setBatchs((List)batchs);
                combinationItems.add(gCombination);
            });
            for (int i = 0; i < combinationItems.size(); ++i) {
                GCombination gItem = (GCombination)combinationItems.get(i);
                logger.info("\u5546\u54c1\u6279\u6b21\u53c2\u6570\u524d:{}", (Object)JSON.toJSONString((Object)gItem));
                gItem.getBatchs().stream().forEach(batchObj -> {
                    CargoStorageDto queryDto = new CargoStorageDto();
                    queryDto.setCargoId(gItem.getCargoId());
                    queryDto.setBatch(batchObj.getBatch());
                    queryDto.setWarehouseId(warehouse.getId());
                    queryDto.setPageSize(Integer.valueOf(1000));
                    queryDto.setPageNum(Integer.valueOf(1));
                    logger.info("\u5e93\u5b58\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
                    PageInfo pageCargo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.queryCargoStorage(queryDto));
                    logger.info("\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageCargo));
                    if (CollectionUtils.isNotEmpty((Collection)pageCargo.getList())) {
                        CargoStorageDto cargoStorage = (CargoStorageDto)pageCargo.getList().get(0);
                        batchObj.setWarehouseName(warehouse.getName());
                        batchObj.setProduceTime(cargoStorage.getProduceTime());
                        batchObj.setExpireTime(cargoStorage.getExpireTime());
                        batchObj.setBalance(Integer.valueOf(cargoStorage.getBalance().intValue()));
                    }
                });
                logger.info("\u5546\u54c1\u6279\u6b21\u53c2\u6570\u540e:{}", (Object)JSON.toJSONString((Object)gItem.getBatchs()));
            }
            combinationRuleContent.setCombinationItems((List)combinationItems);
            combinationActivityDto.setPromotionContent(combinationRuleContent);
        }
    }

    private void combinationActPreempt(CombinationActivityDto combinationActivityDto, Long activityId) {
        TcbjCombinationActReqDto combinationActReqDto = new TcbjCombinationActReqDto();
        combinationActReqDto.setActivityId(activityId);
        combinationActReqDto.setActivityName(combinationActivityDto.getActivityName());
        combinationActReqDto.setActivityCode(combinationActivityDto.getActivityCode());
        combinationActReqDto.setActivityType(combinationActivityDto.getActivityType().toString());
        combinationActReqDto.setSuiteNum(Integer.valueOf(combinationActivityDto.getActivityLimit().intValue()));
        combinationActReqDto.setShopId(combinationActivityDto.getShopId());
        combinationActReqDto.setSuitCode(combinationActivityDto.getThirdPartyCode());
        combinationActReqDto.setSuitName(combinationActivityDto.getActivityName());
        ArrayList detailReqDtoList = new ArrayList();
        combinationActivityDto.getPromotionContent().getCombinationItems().forEach(item -> {
            if (CollectionUtils.isNotEmpty((Collection)item.getBatchs())) {
                item.getBatchs().forEach(batchObj -> {
                    logger.info("\u6279\u6b21\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)batchObj));
                    TcbjCombinationActDetailReqDto dto = new TcbjCombinationActDetailReqDto();
                    dto.setCargoId(item.getCargoId());
                    dto.setCargoCode(item.getSkuCode());
                    dto.setBatch(batchObj.getBatch());
                    dto.setPreemptNum(new BigDecimal(batchObj.getNum()));
                    dto.setRatio(new BigDecimal(item.getCombinationNum()));
                    detailReqDtoList.add(dto);
                });
            }
        });
        combinationActReqDto.setDetailReqDtoList(detailReqDtoList);
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        Assert.notNull((Object)orgId, (String)"\u7528\u6237\u7ec4\u7ec7\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        WarehouseQueryReqDto queryDto = new WarehouseQueryReqDto();
        queryDto.setOrganizationIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
        queryDto.setMainWarehouse(Integer.valueOf(1));
        queryDto.setType("0");
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseQueryApi.queryWarehousePage(queryDto, Integer.valueOf(1), Integer.valueOf(100)));
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            combinationActReqDto.setWarehouseId(((WarehouseRespDto)pageInfo.getList().get(0)).getId());
            logger.info("\u4f18\u60e0\u5957\u88c5\u9884\u5360\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)combinationActReqDto));
            RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.combinationActPreempt(combinationActReqDto));
        }
    }

    private void backtrackInventory(ActivityRespDto activityRespDto) {
        TcbjCombinationActBacktrackReqDto combinationActBacktrackReqDto = new TcbjCombinationActBacktrackReqDto();
        combinationActBacktrackReqDto.setActivityId(activityRespDto.getId());
        combinationActBacktrackReqDto.setActivityCode(activityRespDto.getActivityCode());
        combinationActBacktrackReqDto.setActivityType(ActivityType.COMBINATION_ACTIVITY.name());
        logger.info("\u4f18\u60e0\u5957\u88c5\u53d6\u6d88\u9884\u5360\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)combinationActBacktrackReqDto));
        this.tcbjInventoryApi.backtrackInventory(combinationActBacktrackReqDto);
    }

    private ActivityRespDto checkActivity(Long activityId) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(activityId.longValue()).getData();
        if (activityRespDto == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        return activityRespDto;
    }

    public List<WarehouseRespDto> queryWarehouseByOrgIds(List<Long> orgIds) {
        IWarehouseQueryApi warehouseQueryApi = (IWarehouseQueryApi)SpringBeanUtil.getBean(IWarehouseQueryApi.class);
        WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
        warehouseQueryReqDto.setOrganizationIds(orgIds);
        warehouseQueryReqDto.setType("0");
        warehouseQueryReqDto.setMainWarehouse(Integer.valueOf(1));
        RestResponse pageInfoRestResp = warehouseQueryApi.queryWarehousePage(warehouseQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo warehousePageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResp);
        if (!Objects.isNull(warehousePageInfo) && !CollectionUtils.isEmpty((Collection)warehousePageInfo.getList())) {
            return warehousePageInfo.getList();
        }
        throw new BizException("\u5546\u5bb6\u5bf9\u5e94\u7684\u4ea7\u54c1\u4e3b\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    private void checkBatchs(CombinationActivityDto activityReqDto) {
        CombinationRuleContent content = activityReqDto.getPromotionContent();
        List combinationItems = content.getCombinationItems();
        for (GCombination gCombination : combinationItems) {
            for (CombinationBatch batch : gCombination.getBatchs()) {
                if (!ObjectUtils.isEmpty((Object)batch.getNum()) && (!ObjectUtils.isNotEmpty((Object)batch.getNum()) || !batch.getNum().equals(0))) continue;
                throw new BizException("\u8bbe\u7f6e\u5e93\u5b58\u6279\u6b21\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u6216\u672a0");
            }
        }
    }
}

