/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IfWholeCasePurchaseEnum;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemDepthQueryReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.IShoppingCart;
import com.dtyunxi.yundt.module.trade.api.ItemExtService;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.request.TrolleyQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeTobEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.constants.LimitMinModeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemExtServiceImpl
implements ItemExtService {
    private static final Logger logger = LoggerFactory.getLogger(ItemExtServiceImpl.class);
    @Resource
    private IBitemService bitemService;
    @Autowired
    private IActivityExtQueryApi activityExtQueryApi;
    @Resource
    private IShoppingCart shoppingCart;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;

    public PageInfo<ItemInfoRespDto> queryItemPageDepth(ItemDepthQueryReqDto itemDepthReqDto, Integer pageNum, Integer pageSize) {
        logger.info("\u5546\u54c1\u641c\u7d22\u5165\u53c2\uff1a{},\u5f53\u524d\u9875\uff1a{}, \u9875\u6570\u5927\u5c0f\uff1a{}", new Object[]{itemDepthReqDto, pageNum, pageSize});
        PageInfo itemInfoRespDtoPageInfo = this.bitemService.queryItemPageDepth(itemDepthReqDto, pageNum, pageSize);
        List list = itemInfoRespDtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return itemInfoRespDtoPageInfo;
        }
        List<Long> shopIds = list.stream().filter(item -> Objects.nonNull(item.getShopId())).map(ItemInfoRespDto::getShopId).collect(Collectors.toList());
        this.setShoppingCartInfo(list, shopIds);
        this.bitemService.setItemPolicyPriceInfo(list);
        this.setStockSortAndItemActivity(itemDepthReqDto, (PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo);
        this.setActivityTypeName((PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo);
        this.checkSupportSingleBuy((PageInfo<ItemInfoRespDto>)itemInfoRespDtoPageInfo, itemDepthReqDto.getCustomerId());
        this.itemService.setItemToInventory(itemDepthReqDto, list);
        return itemInfoRespDtoPageInfo;
    }

    private void checkSupportSingleBuy(PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo, Long customerId) {
        String attachment;
        if (customerId == null && StringUtils.isNotBlank((CharSequence)(attachment = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid")))) {
            customerId = Long.valueOf(attachment);
        }
        ArrayList itemIds = Lists.newArrayList();
        ArrayList shopIds = Lists.newArrayList();
        for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
            itemIds.add(itemInfoRespDto.getItemId());
            shopIds.add(itemInfoRespDto.getShopId());
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(customerId));
        SupportSingleItemDto supportSingleItemDto = new SupportSingleItemDto();
        supportSingleItemDto.setItemIds((List)itemIds);
        supportSingleItemDto.setShopIds((List)shopIds);
        supportSingleItemDto.setCustomerRespDtos((List)Lists.newArrayList((Object[])new CustomerRespDto[]{customerRespDto}));
        List notSupportSingleItem = this.bitemService.getNotSupportSingleItem(supportSingleItemDto);
        Map<String, NotSupportSingleItemDto> notSupportSingleItemDtoMap = notSupportSingleItem.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getItemId(), e -> e, (e1, e2) -> e1));
        for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
            if (notSupportSingleItemDtoMap.containsKey(itemInfoRespDto.getShopId() + "_" + itemInfoRespDto.getItemId())) {
                itemInfoRespDto.setSupportSingleBuy(Integer.valueOf(1));
            }
            if (customerRespDto != null && customerRespDto.getIfWholeCasePurchase() != null) {
                itemInfoRespDto.setIfWholeCasePurchase(customerRespDto.getIfWholeCasePurchase());
            }
            String ifWholeCasePurchaseRemark = null;
            if (CollectionUtils.isNotEmpty((Collection)itemInfoRespDto.getItemSkuList())) {
                ItemSkuRespDto skuDto = (ItemSkuRespDto)itemInfoRespDto.getItemSkuList().get(0);
                if (IfWholeCasePurchaseEnum.YES.getCode().equals(customerRespDto.getIfWholeCasePurchase())) {
                    if (skuDto.getMinPackage() != null) {
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u3002\u53d6\u6700\u5c0f\u5305\u88c5\u6570";
                        itemInfoRespDto.setLimitMinPurchaseNum(skuDto.getMinPackage());
                    } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(skuDto.getLimitMinMode())) {
                        itemInfoRespDto.setLimitMinPurchaseNum(skuDto.getLimitMin());
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                    } else {
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u662f+\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u500d\u6570\u63a7\u5236\u60c5\u51b5\u4e0b\u9ed8\u8ba4\u4e3a1";
                    }
                } else if (LimitMinModeEnum.CUSTOMER.getCode().equals(skuDto.getLimitMinMode())) {
                    itemInfoRespDto.setLimitMinPurchaseNum(skuDto.getLimitMin());
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf\u6a21\u5f0f\uff0c\u53ea\u80fd\u53d6\u81ea\u5b9a\u4e49\u8d77\u8ba2\u91cf";
                } else if (LimitMinModeEnum.MULTIPLE.getCode().equals(skuDto.getLimitMinMode())) {
                    if (skuDto.getMinPackage() != null && skuDto.getLimitMin() != null) {
                        itemInfoRespDto.setLimitMinPurchaseNum(Integer.valueOf(skuDto.getLimitMin() * skuDto.getMinPackage()));
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236+\u6700\u5c0f\u5305\u88c5\u6570\u975e\u7a7a\u65f6\u8ba1\u7b97\u51fa\u76f8\u4e58\u7684\u8d77\u8ba2\u91cf";
                    } else {
                        ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u500d\u6570\u63a7\u5236\uff0c\u4f46\u6700\u5c0f\u5305\u88c5\u6570\u4e3a\u7a7a\uff0c\u4e0b\u9ed8\u8ba4\u4e3a1";
                    }
                } else {
                    ifWholeCasePurchaseRemark = "\u6574\u7bb1\u8d77\u8ba2\u4e3a\u5426+\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e3a1";
                }
            } else {
                ifWholeCasePurchaseRemark = "\u5546\u54c1SKU\u94fe\u8868\u4e3a\u7a7a\uff0c\u65e0\u6700\u5c0f\u5305\u88c5\u500d\u6570\u548c\u6700\u5c0f\u8d77\u8ba2\u91cf\u8bbe\u7f6e\uff0c\u9ed8\u8ba4\u4e3a1";
            }
            if (MapUtils.isNotEmpty((Map)itemInfoRespDto.getExtFields())) {
                itemInfoRespDto.getExtFields().put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ifWholeCasePurchaseRemark", ifWholeCasePurchaseRemark);
            itemInfoRespDto.setExtFields(map);
        }
    }

    private void setStockSortAndItemActivity(ItemDepthQueryReqDto itemDepthReqDto, PageInfo<ItemInfoRespDto> itemPageInfo) {
        boolean activitySearch = false;
        if (null != itemDepthReqDto.getActivityId() || null != itemDepthReqDto.getCouponTpId()) {
            activitySearch = true;
        }
        this.bitemService.setItemActivityInfo(itemPageInfo.getList(), Boolean.valueOf(activitySearch), Boolean.valueOf(true), itemDepthReqDto.getCustomerIdList());
        itemPageInfo.getList().forEach(item -> {
            if (CollectionUtils.isNotEmpty((Collection)item.getTags())) {
                item.setTagNum(Integer.valueOf(item.getTags().size()));
            } else {
                item.setTagNum(Integer.valueOf(0));
            }
        });
    }

    private void setActivityTypeName(PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo) {
        List<Long> activityIds = this.getActivityIds(itemInfoRespDtoPageInfo);
        if (CollectionUtils.isEmpty(activityIds)) {
            return;
        }
        List activityRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.activityExtQueryApi.queryActivityListByIds(activityIds));
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return;
        }
        Map<Long, ActivityRespDto> activityRespDtoMap = activityRespDtos.stream().collect(Collectors.toMap(ActivityRespDto::getId, e -> e, (e1, e2) -> e1));
        for (ItemInfoRespDto itemInfoRespDto : itemInfoRespDtoPageInfo.getList()) {
            if (CollectionUtils.isEmpty((Collection)itemInfoRespDto.getTags())) continue;
            HashSet activityTypeNameSet = Sets.newHashSet();
            for (ItemActivityTagDto tag : itemInfoRespDto.getTags()) {
                ActivityRespDto activityRespDto;
                ActivityTypeTobEnum activityTypeTobEnum;
                if (!activityRespDtoMap.containsKey(tag.getActivityId()) || (activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)(activityRespDto = activityRespDtoMap.get(tag.getActivityId())).getActivityTemplateId())) == null) continue;
                activityTypeNameSet.add(activityTypeTobEnum.getTradeDesc());
            }
            itemInfoRespDto.setActivityTypeNameList(new ArrayList(activityTypeNameSet));
        }
    }

    private List<Long> getActivityIds(PageInfo<ItemInfoRespDto> itemInfoRespDtoPageInfo) {
        HashSet activityIds = Sets.newHashSet();
        itemInfoRespDtoPageInfo.getList().stream().forEach(e -> {
            if (CollectionUtils.isNotEmpty((Collection)e.getTags())) {
                for (ItemActivityTagDto tag : e.getTags()) {
                    activityIds.add(tag.getActivityId());
                }
            }
        });
        if (CollectionUtils.isEmpty((Collection)activityIds)) {
            return Collections.emptyList();
        }
        return activityIds.stream().collect(Collectors.toList());
    }

    private void setShoppingCartInfo(List<ItemInfoRespDto> list, List<Long> shopIds) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        Map<String, ShoppingCartItemRespDto> skuMap = this.getShoppingCartInfo(shopIds);
        if (CollUtil.isEmpty(skuMap)) {
            return;
        }
        for (ItemInfoRespDto item : list) {
            Long shopId = item.getShopId();
            List itemSkuList = item.getItemSkuList();
            if (Objects.isNull(shopId) || CollUtil.isEmpty((Collection)itemSkuList)) continue;
            itemSkuList.forEach(skuInfo -> {
                Long skuId = skuInfo.getId();
                String key = shopId + "-" + skuId;
                if (skuMap.containsKey(key)) {
                    skuInfo.setShoppingCartItemNum(((ShoppingCartItemRespDto)skuMap.get(key)).getItemNum());
                    skuInfo.setShoppingCartItemId(((ShoppingCartItemRespDto)skuMap.get(key)).getId());
                } else {
                    skuInfo.setShoppingCartItemNum(Integer.valueOf(0));
                }
            });
        }
    }

    private Map<String, ShoppingCartItemRespDto> getShoppingCartInfo(List<Long> shopIds) {
        TrolleyQueryReqDto trolleyQueryReqDto = new TrolleyQueryReqDto();
        ShoppingCartRespDto shoppingCartRespDto = this.shoppingCart.queryUserItemList(trolleyQueryReqDto);
        if (Objects.isNull(shoppingCartRespDto)) {
            return MapUtil.empty();
        }
        List normalCartItemList = shoppingCartRespDto.getNormalCartItemList();
        if (CollUtil.isEmpty((Collection)normalCartItemList)) {
            return MapUtil.empty();
        }
        if (CollUtil.isNotEmpty(shopIds)) {
            HashSet<Long> shopIdSet = new HashSet<Long>(shopIds);
            normalCartItemList = normalCartItemList.stream().filter(item -> shopIdSet.contains(item.getShopId())).collect(Collectors.toList());
        }
        Map<String, ShoppingCartItemRespDto> skuMap = normalCartItemList.stream().collect(Collectors.toMap(sku -> sku.getShopId() + "-" + sku.getSkuId(), Function.identity(), (o1, o2) -> o2));
        return skuMap;
    }
}

