/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.storageHelper;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseSupplyConfigReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseSupplyRelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyConfigQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseSupplyRelQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.BatchActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ItemActivityStockReqDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemStorageQueryDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.StorageBranchQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.ItemService;
import com.dtyunxi.yundt.module.trade.api.dto.request.StorageReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ToBCargoStorageCreateReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.shop.ShopInfo;
import com.dtyunxi.yundt.module.trade.api.enums.StockTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.IStorageService;
import com.dtyunxi.yundt.module.trade.biz.constant.StorageTypeEnum;
import com.dtyunxi.yundt.module.trade.biz.storageHelper.IStorageHelper;
import com.dtyunxi.yundt.module.trade.biz.util.StorageServiceFactory;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="storageHelper")
public class StorageHelper
implements IStorageHelper {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger(StorageHelper.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StorageServiceFactory storageServiceFactory;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Value(value="${item.storage.userItemCenter:true}")
    private boolean userItemCenter;
    @Resource
    private ItemService itemService;
    @Resource
    private IBitemService bitemService;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Autowired
    private ICsDeliveryNoticeOrderApi csDeliveryNoticeOrderApi;
    @Resource
    private IWarehouseSupplyConfigQueryApi warehouseSupplyConfigQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private IWarehouseSupplyRelQueryApi warehouseSupplyRelQueryApi;

    @Override
    public void subVirStorage(Map<String, List<Long>> activityIdsMap, String orderNo, List<Long> needActivityIds, ShopInfo shopInfo, List<TradeItemReqDto> itemList, Integer orderDeliveryType) {
        HashMap<String, Object> extFields;
        List<Long> activityIds;
        RestResponse restResponse = this.itemActivityStockApi.queryActivityStockType(null);
        Integer stockType = (Integer)RestResponseHelper.extractData((RestResponse)restResponse);
        ArrayList needSubList = Lists.newArrayList();
        ArrayList needSubVirList = Lists.newArrayList();
        if (StockTypeEnum.SHARE.getCode().equals(stockType)) {
            for (TradeItemReqDto orderItemInfoDto : itemList) {
                activityIds = activityIdsMap.get(orderItemInfoDto.getShopId() + "_" + orderItemInfoDto.getSkuSerial());
                ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                itemStorageReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
                itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
                itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                extFields = new HashMap();
                Assert.notNull((Object)orderItemInfoDto.getCargoSerial(), (String)"\u8be5\u503c\u4e3a\u7a7a:CargoCode,\u65e0\u6cd5\u6263\u51cf\u5e93\u5b58", (Object[])new Object[0]);
                extFields.put("cargoCode", orderItemInfoDto.getCargoSerial());
                if (Integer.valueOf(1).equals(orderItemInfoDto.getIsCombinedPackage())) {
                    extFields.put("activityId", orderItemInfoDto.getCombinedPackageActivityId());
                    extFields.put("combinationFlag", orderItemInfoDto.getIsCombinedPackage());
                }
                itemStorageReqDto.setExtFields(extFields);
                needSubVirList.add(itemStorageReqDto);
                if (CollectionUtils.isEmpty(activityIds) || orderItemInfoDto.getGift() == 1 || CombinationEnum.YES.getType().equals(orderItemInfoDto.getIsCombinedPackage())) continue;
                ItemActivityStockReqDto itemActivityStockReqDto = new ItemActivityStockReqDto();
                itemActivityStockReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
                itemActivityStockReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemActivityStockReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                itemActivityStockReqDto.setActivityIds(activityIds);
                needSubList.add(itemActivityStockReqDto);
            }
        } else {
            for (TradeItemReqDto orderItemInfoDto : itemList) {
                activityIds = activityIdsMap.get(orderItemInfoDto.getShopId() + "_" + orderItemInfoDto.getSkuSerial());
                if (CollectionUtils.isEmpty(activityIds) || orderItemInfoDto.getGift() == 1) {
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
                    itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                    itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
                    itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                    extFields = new HashMap();
                    if (Integer.valueOf(1).equals(orderItemInfoDto.getIsCombinedPackage())) {
                        extFields.put("activityId", orderItemInfoDto.getCombinedPackageActivityId());
                        extFields.put("combinationFlag", orderItemInfoDto.getIsCombinedPackage());
                    }
                    itemStorageReqDto.setExtFields(extFields);
                    needSubVirList.add(itemStorageReqDto);
                    continue;
                }
                if (!CombinationEnum.NO.getType().equals(orderItemInfoDto.getIsCombinedPackage())) continue;
                ItemActivityStockReqDto itemActivityStockReqDto = new ItemActivityStockReqDto();
                itemActivityStockReqDto.setBalance(Long.valueOf(-Long.valueOf(orderItemInfoDto.getItemNum().intValue()).longValue()));
                itemActivityStockReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemActivityStockReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                itemActivityStockReqDto.setActivityIds(activityIds);
                extFields = new HashMap();
                extFields.put("cargoCode", orderItemInfoDto.getCargoSerial());
                itemActivityStockReqDto.setExtFields(extFields);
                needSubList.add(itemActivityStockReqDto);
            }
        }
        if (OrderDeliveryTypeEnum.SELLER.getType().equals(orderDeliveryType) && CollectionUtils.isNotEmpty((Collection)needSubVirList)) {
            try {
                this.changeSotrage(shopInfo, orderNo, needSubVirList);
            }
            catch (Exception e) {
                this.logger.error("\u64cd\u4f5c\u5e93\u5b58\u629b\u9519", (Throwable)e);
                throw new com.dtyunxi.cube.commons.exceptions.BizException(TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode(), e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needSubList)) {
            BatchActivityStockReqDto batchActivityStockReqDto = new BatchActivityStockReqDto();
            batchActivityStockReqDto.setItemActivityStockList((List)needSubList);
            batchActivityStockReqDto.setOpt(BatchItemStorageReqDto.SUB);
            batchActivityStockReqDto.setActivityIds(needActivityIds);
            try {
                RestResponse batchActivityStockRestResp = this.operatingBatchActivityStorage(batchActivityStockReqDto);
                RestResponseHelper.checkOrThrow((RestResponse)batchActivityStockRestResp);
                this.logger.info("\u3010\u6d3b\u52a8\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1abatchActivityStockReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchActivityStockReqDto));
            }
            catch (Exception e) {
                this.logger.error("\u8425\u9500\u4e2d\u5fc3\u64cd\u4f5c\u5e93\u5b58\u629b\u9519", (Throwable)e);
                if (CollectionUtils.isNotEmpty((Collection)needSubVirList)) {
                    BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                    batchItemStorageReqDto.setItemStorageReqDtoList((List)needSubVirList);
                    batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                    if (this.userItemCenter) {
                        RestResponse batchItemStorageRespDtoRestResponse = this.operatingBatchItemStorage(batchItemStorageReqDto);
                        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
                    } else {
                        extFields = new HashMap<String, Object>(2);
                        extFields.put("orderNo", orderNo);
                        batchItemStorageReqDto.setExtFields(extFields);
                        RestResponse batchItemStorageRespDtoRestResponse = this.returnCargoStorageItemStorage(batchItemStorageReqDto);
                        RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
                    }
                    this.logger.info("\u3010\u5546\u54c1\u5e93\u5b58\u56de\u6eda\u64cd\u4f5c\u6210\u529f\uff1abatchItemStorageReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
                }
                throw new com.dtyunxi.cube.commons.exceptions.BizException(TradeModuleExcpCode.ACTIVITY_ITEM_STOCK_LIMIT.getCode(), e.getMessage());
            }
        }
    }

    @Override
    public void rollbackVirSotrage(SubmitOrderReqDto orderInfoDto, String preOrderNo, List<TradeItemReqDto> itemList) {
        List activityIds;
        List needActivityIds = orderInfoDto.getActivityIds();
        Map activityIdsMap = orderInfoDto.getActivityIdsMap();
        Integer stockType = (Integer)this.itemActivityStockApi.queryActivityStockType(null).getData();
        ArrayList needSubList = Lists.newArrayList();
        ArrayList needSubVirList = Lists.newArrayList();
        if (StockTypeEnum.SHARE.getCode().equals(stockType)) {
            for (TradeItemReqDto orderItemInfoDto : itemList) {
                activityIds = (List)activityIdsMap.get(orderItemInfoDto.getShopId() + "_" + orderItemInfoDto.getSkuSerial());
                ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                itemStorageReqDto.setBalance(Long.valueOf(orderItemInfoDto.getItemNum().intValue()));
                itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
                itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                HashMap<String, Number> extFields = new HashMap<String, Number>();
                if (Integer.valueOf(1).equals(orderItemInfoDto.getIsCombinedPackage())) {
                    extFields.put("activityId", orderItemInfoDto.getCombinedPackageActivityId());
                    extFields.put("combinationFlag", orderItemInfoDto.getIsCombinedPackage());
                }
                itemStorageReqDto.setExtFields(extFields);
                needSubVirList.add(itemStorageReqDto);
                if (CollectionUtils.isEmpty((Collection)activityIds) || orderItemInfoDto.getGift() == 1 || CombinationEnum.YES.getType().equals(orderItemInfoDto.getIsCombinedPackage())) continue;
                ItemActivityStockReqDto itemActivityStockReqDto = new ItemActivityStockReqDto();
                itemActivityStockReqDto.setBalance(Long.valueOf(orderItemInfoDto.getItemNum().intValue()));
                itemActivityStockReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemActivityStockReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                itemActivityStockReqDto.setActivityIds(activityIds);
                needSubList.add(itemActivityStockReqDto);
            }
        } else {
            for (TradeItemReqDto orderItemInfoDto : itemList) {
                activityIds = (List)activityIdsMap.get(orderItemInfoDto.getShopId() + "_" + orderItemInfoDto.getSkuSerial());
                if (CollectionUtils.isEmpty((Collection)activityIds) || orderItemInfoDto.getGift() == 1) {
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(orderItemInfoDto.getItemNum().intValue()));
                    itemStorageReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                    itemStorageReqDto.setItemType(orderItemInfoDto.getItemType());
                    itemStorageReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                    HashMap<String, Number> extFields = new HashMap<String, Number>();
                    if (Integer.valueOf(1).equals(orderItemInfoDto.getIsCombinedPackage())) {
                        extFields.put("activityId", orderItemInfoDto.getCombinedPackageActivityId());
                        extFields.put("combinationFlag", orderItemInfoDto.getIsCombinedPackage());
                    }
                    itemStorageReqDto.setExtFields(extFields);
                    needSubVirList.add(itemStorageReqDto);
                    continue;
                }
                if (!CombinationEnum.NO.getType().equals(orderItemInfoDto.getIsCombinedPackage())) continue;
                ItemActivityStockReqDto itemActivityStockReqDto = new ItemActivityStockReqDto();
                itemActivityStockReqDto.setBalance(Long.valueOf(orderItemInfoDto.getItemNum().intValue()));
                itemActivityStockReqDto.setShopId(Long.valueOf(orderItemInfoDto.getShopId()));
                itemActivityStockReqDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
                itemActivityStockReqDto.setActivityIds(activityIds);
                needSubList.add(itemActivityStockReqDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needSubVirList)) {
            BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
            batchItemStorageReqDto.setItemStorageReqDtoList((List)needSubVirList);
            batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
            try {
                if (this.userItemCenter) {
                    RestResponse batchItemStorageRespDtoRestResponse = this.operatingBatchItemStorage(batchItemStorageReqDto);
                    RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
                } else {
                    HashMap<String, String> extFields = new HashMap<String, String>(2);
                    extFields.put("orderNo", preOrderNo);
                    batchItemStorageReqDto.setExtFields(extFields);
                    RestResponse batchItemStorageRespDtoRestResponse = this.returnCargoStorageItemStorage(batchItemStorageReqDto);
                    RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
                }
                this.logger.info("\u3010\u5546\u54c1\u865a\u62df\u5e93\u5b58\u56de\u6eda\u64cd\u4f5c\u6210\u529f\uff1abatchItemStorageReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
            }
            catch (Exception e) {
                this.logger.error("\u3010\u4e0b\u5355\u5931\u8d25\uff0c\u56de\u6eda\u5546\u54c1\u5e93\u5b58\u5931\u8d25\u3011", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needSubList)) {
            BatchActivityStockReqDto batchActivityStockReqDto = new BatchActivityStockReqDto();
            batchActivityStockReqDto.setItemActivityStockList((List)needSubList);
            batchActivityStockReqDto.setOpt(BatchItemStorageReqDto.ADD);
            batchActivityStockReqDto.setActivityIds(needActivityIds);
            try {
                RestResponse batchActivityStockRestResp = this.operatingBatchActivityStorage(batchActivityStockReqDto);
                RestResponseHelper.checkOrThrow((RestResponse)batchActivityStockRestResp);
                this.logger.info("\u3010\u6d3b\u52a8\u5e93\u5b58\u56de\u6eda\u64cd\u4f5c\u6210\u529f\uff1abatchActivityStockReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchActivityStockReqDto));
            }
            catch (Exception e) {
                this.logger.error("\u3010\u4e0b\u5355\u5931\u8d25\uff0c\u56de\u6eda\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25\u3011", (Throwable)e);
            }
        }
    }

    @Override
    public Long noticeInventoryAddOrder(String orderNo) {
        ArrayList attrs = Lists.newArrayList((Object[])new OrderQueryEnum[]{OrderQueryEnum.ITEM, OrderQueryEnum.ADDRESS});
        OrderDetailRespDto orderDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)this.orderBizQueryApi.getOrderDetail(orderNo, StringUtils.join((Collection)attrs, (String)",")));
        OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
        if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
            orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
        }
        CsDeliveryNoticeOrderAddReqDto addReqDto = new CsDeliveryNoticeOrderAddReqDto();
        addReqDto.setPreOrderNo(orderDto.getOrderNo());
        addReqDto.setExternalOrderNo(orderDto.getThirdOrderNo());
        addReqDto.setWarehouseCode(orderDto.getWarehouseCode());
        addReqDto.setOrganizationId(orderDto.getOrganizationId());
        addReqDto.setOrganizationName(orderDto.getOrganizationName());
        ContactDto contactDto = new ContactDto();
        contactDto.setAddress(orderDelivery.getAddress());
        contactDto.setPlanTime(DateUtils.formatDate((Date)orderDto.getPlaceTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        contactDto.setReciveName(orderDelivery.getDeliveryName());
        contactDto.setRecivePhone(orderDelivery.getDeliveryMobile());
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (TradeItemRespDto item : orderDto.getOrderItems()) {
            CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setCargoCode(item.getCargoSerial());
            dto.setPlanQuantity(BigDecimal.valueOf(item.getItemNum().intValue()));
            try {
                dto.setActivityId(item.getCombinedPackageActivityId());
            }
            catch (Exception ex) {
                this.logger.error("\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8id\u5f02\u5e38\uff0c\u4e0d\u8d4b\u503c\uff1bactivityId:{}", (Object)item.getCombinedPackageActivityId());
            }
            totalQuantity = totalQuantity.add(dto.getPlanQuantity());
            dto.setTradeOrderItemId(item.getId());
            detailAddReqDtoList.add(dto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        addReqDto.setContactDto(contactDto);
        addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode());
        this.logger.info("----->\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        return (Long)RestResponseHelper.extractData((RestResponse)this.csDeliveryNoticeOrderApi.add(addReqDto));
    }

    @Override
    public List<WarehouseSupplyRelRespDto> deliveryWarehouseConfig(Long customerId, Long organizationId) {
        this.logger.info("customer delivery warehouse config the params is customer : {} , organizationId : {} .", (Object)customerId, (Object)organizationId);
        if (null == customerId) {
            throw new BizException("customerId is null");
        }
        if (null == organizationId) {
            throw new BizException("organizationId is null");
        }
        CustomerExtRespDto jxsCustomerInfo = this.getJxsCustomerInfo(String.valueOf(customerId));
        log.info("jxsCustomerInfo is {} .", (Object)JSONObject.toJSONString((Object)jxsCustomerInfo));
        if (jxsCustomerInfo.getIsWarehouseEnable() == null || jxsCustomerInfo.getIsWarehouseEnable() == 0) {
            log.info("customer.getIsWarehouseEnable() == {} , return DEFAULT .", (Object)jxsCustomerInfo.getIsWarehouseEnable());
            return Collections.emptyList();
        }
        WarehouseSupplyConfigReqDto warehouseSupplyConfigReqDto = new WarehouseSupplyConfigReqDto();
        warehouseSupplyConfigReqDto.setCustomerId(customerId);
        warehouseSupplyConfigReqDto.setOrganizationId(organizationId);
        log.info("deliveryWarehouseConfig \u79df\u6237\u5206\u4ed3\u914d\u7f6e\u8bf7\u6c42\u53c2\u6570={}", (Object)JSONObject.toJSONString((Object)warehouseSupplyConfigReqDto));
        PageInfo warehouseSupplyConfigRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyConfigQueryApi.queryByPage(JSON.toJSONString((Object)warehouseSupplyConfigReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        log.info("deliveryWarehouseConfig \u79df\u6237\u5206\u4ed3\u914d\u7f6e\u8fd4\u56de\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)warehouseSupplyConfigRespDtoPageInfo));
        if (CollectionUtils.isNotEmpty((Collection)warehouseSupplyConfigRespDtoPageInfo.getList())) {
            List warehouseSupplyRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.warehouseSupplyRelQueryApi.queryByCustomerId(String.valueOf(customerId)));
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)warehouseSupplyRelRespDtos), (String)"\u5ba2\u6237\u53d1\u8d27\u4ed3\u914d\u7f6e\u5f02\u5e38", (Object[])new Object[0]);
            return warehouseSupplyRelRespDtos;
        }
        return Collections.emptyList();
    }

    private void changeSotrage(ShopInfo shopInfo, String OrderNo, List<ItemStorageReqDto> needSubVirList) {
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(needSubVirList);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.SUB);
        if (this.userItemCenter) {
            RestResponse batchItemStorageRespDtoRestResponse = this.operatingBatchItemStorage(batchItemStorageReqDto);
            RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
            this.logger.info("\u3010\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u6263\u51cf\u5546\u54c1\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1abatchItemStorageReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
        } else {
            HashMap<String, String> extFields = new HashMap<String, String>(2);
            String warehouseCode = shopInfo.getWarehouseCode();
            extFields.put("warehouseCode", warehouseCode);
            extFields.put("orderNo", OrderNo);
            batchItemStorageReqDto.setExtFields(extFields);
            RestResponse batchItemStorageRespDtoRestResponse = this.operatingStorage(batchItemStorageReqDto);
            RestResponseHelper.checkOrThrow((RestResponse)batchItemStorageRespDtoRestResponse);
            this.logger.info("\u3010\u8c03\u7528\u5e93\u5b58\u4e2d\u5fc3\u9884\u5360\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1abatchItemStorageReqDto={}\u3011", (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
        }
    }

    private RestResponse operatingStorage(BatchItemStorageReqDto batchItemStorageReqDto) {
        IStorageService storageService = this.storageServiceFactory.get(StorageTypeEnum.IDENTITY.getCode());
        StorageReqDto reqDto = new StorageReqDto();
        ToBCargoStorageCreateReqDto cargoStorageCreateReqDto = new ToBCargoStorageCreateReqDto();
        Map extFields = batchItemStorageReqDto.getExtFields();
        List collectSubmitOrderHandler = batchItemStorageReqDto.getItemStorageReqDtoList().stream().map(data -> {
            CargoStorageInfoCreateReqDto newData = new CargoStorageInfoCreateReqDto();
            BeanUtils.copyProperties((Object)data, (Object)newData);
            newData.setExtFields(data.getExtFields());
            newData.setWarehouseCode(String.valueOf(extFields.get("warehouseCode")));
            newData.setNum(BigDecimal.valueOf(data.getBalance()).negate());
            newData.setCargoCode(String.valueOf(data.getExtFields().get("cargoCode")));
            return newData;
        }).collect(Collectors.toList());
        cargoStorageCreateReqDto.setCargoList(collectSubmitOrderHandler);
        cargoStorageCreateReqDto.setOrderNo(String.valueOf(extFields.get("orderNo")));
        reqDto.setCargoStorageCreateReqDto(cargoStorageCreateReqDto);
        this.logger.info("[operatingStorage]>>>{}", (Object)JSONObject.toJSONString((Object)reqDto));
        RestResponse restResponse = storageService.operatingItemStorage(reqDto);
        return restResponse;
    }

    private RestResponse operatingBatchActivityStorage(BatchActivityStockReqDto batchActivityStockReqDto) {
        IStorageService storageService = this.storageServiceFactory.get(StorageTypeEnum.ACTIVITY.getCode());
        StorageReqDto reqDto = new StorageReqDto();
        reqDto.setBatchActivityStockReqDto(batchActivityStockReqDto);
        return storageService.operatingItemStorage(reqDto);
    }

    private RestResponse operatingBatchItemStorage(BatchItemStorageReqDto batchItemStorageReqDto) {
        StorageReqDto reqDto = new StorageReqDto();
        reqDto.setBatchItemStorageReqDto(batchItemStorageReqDto);
        return this.storageServiceFactory.get().operatingItemStorage(reqDto);
    }

    private RestResponse returnCargoStorageItemStorage(BatchItemStorageReqDto batchItemStorageReqDto) {
        IStorageService storageService = this.storageServiceFactory.get(StorageTypeEnum.IDENTITY.getCode());
        StorageReqDto reqDto = new StorageReqDto();
        ToBCargoStorageCreateReqDto cargoStorageCreateReqDto = new ToBCargoStorageCreateReqDto();
        Map extFields = batchItemStorageReqDto.getExtFields();
        cargoStorageCreateReqDto.setOrderNo(String.valueOf(extFields.get("orderNo")));
        reqDto.setCargoStorageCreateReqDto(cargoStorageCreateReqDto);
        return storageService.returnItemStorage(reqDto);
    }

    @Override
    public void checkOrderItemInventory(OrderDetailRespDto orderData) {
        List orderItems = orderData.getOrderItems();
        StorageBranchQueryReqDto storageBranchQueryReqDto = new StorageBranchQueryReqDto();
        ArrayList<ItemStorageQueryDto> itemStorageList = new ArrayList<ItemStorageQueryDto>();
        for (TradeItemRespDto orderItemInfoDto : orderItems) {
            ItemStorageQueryDto itemStorageQueryDto = new ItemStorageQueryDto();
            itemStorageQueryDto.setSkuId(Long.valueOf(orderItemInfoDto.getSkuSerial()));
            itemStorageQueryDto.setShopId(Long.valueOf(orderData.getShopId()));
            itemStorageQueryDto.setCargoCode(orderItemInfoDto.getCargoSerial());
            itemStorageList.add(itemStorageQueryDto);
        }
        storageBranchQueryReqDto.setItemStorageList(itemStorageList);
        List itemStorageQueryDtos = this.bitemService.queryBranchItemStorage(storageBranchQueryReqDto);
        if (CollectionUtils.isEmpty((Collection)itemStorageQueryDtos)) {
            this.logger.info("\u63d0\u4ea4\u8ba2\u5355\u5e93\u5b58\u4e0d\u8db3");
            BizExceptionHelper.throwBizException((String)TradeModuleExcpCode.VALIDATION_FAIL.getCode(), (String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        Map<String, Long> avaNumMap = itemStorageQueryDtos.stream().collect(Collectors.toMap(e -> e.getShopId() + "_" + e.getSkuId() + "_" + e.getCargoCode(), e -> Optional.of(e).map(ItemStorageQueryDto::getAvaNum).orElse(0L), (o1, o2) -> o1));
        Long customerId = Long.valueOf(orderData.getCustomerId());
        StringBuilder itemControlMsg = new StringBuilder();
        List itemIdList = orderItems.stream().map(TradeItemRespDto::getItemSerial).map(x -> Long.valueOf(x)).collect(Collectors.toList());
        Map itemToInventoryMap = this.itemService.checkControlRule(itemIdList, customerId);
        if (itemToInventoryMap.isEmpty()) {
            this.logger.info("\u5e97\u94fa{}\u4e0d\u5b58\u5728\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7", (Object)orderData.getShopId());
            return;
        }
        for (TradeItemRespDto orderItemInfoDto : orderItems) {
            String key = orderItemInfoDto.getShopId() + "_" + orderItemInfoDto.getSkuSerial() + "_" + orderItemInfoDto.getCargoSerial();
            if (!avaNumMap.containsKey(key) || avaNumMap.get(key).compareTo(0L) <= 0) {
                itemControlMsg.append("\u5546\u54c1[").append(orderItemInfoDto.getItemCode()).append("]\u5e93\u5b58\u4e0d\u8db3;");
                continue;
            }
            Long itemId = Long.valueOf(orderItemInfoDto.getItemSerial());
            Long inventoryCtrNum = (Long)itemToInventoryMap.get(itemId);
            inventoryCtrNum = inventoryCtrNum == null ? 0L : inventoryCtrNum;
            Long avaNum = avaNumMap.get(key);
            Long itemNum = (long)orderItemInfoDto.getItemNum();
            this.logger.info("\u6821\u9a8c\u8ba2\u5355\u5b89\u5168\u7ba1\u63a7\u5546\u54c1={},\u8d2d\u4e70\u6570\u91cf={},\u53ef\u7528\u5e93\u5b58={},\u5b89\u5168\u7ba1\u63a7\u5e93\u5b58={}", new Object[]{orderItemInfoDto.getItemCode(), itemNum, avaNum, inventoryCtrNum});
            int flag = itemNum.compareTo(avaNum - inventoryCtrNum);
            if (flag <= 0) continue;
            itemControlMsg.append("\u5546\u54c1[").append(orderItemInfoDto.getItemCode()).append("]\u53ef\u7528\u5e93\u5b58[").append(avaNum - inventoryCtrNum).append("]\u4e0d\u8db3\u8d2d\u4e70\u6570\u91cf;");
        }
        if (StringUtils.isNotEmpty((String)itemControlMsg.toString())) {
            BizExceptionHelper.throwBizException((String)TradeModuleExcpCode.VALIDATION_FAIL.getCode(), (String)itemControlMsg.toString());
        }
    }

    private boolean isSmallBlogin() {
        String isSmallBStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.smallb");
        boolean isSmallB = "true".equals(isSmallBStr);
        this.logger.info("\u662f\u5426\u5c0fb\u89d2\u8272\u767b\u5f55\uff1aisSmallBStr={}, isSmallB={}", (Object)isSmallBStr, (Object)isSmallB);
        return isSmallB;
    }

    public CustomerExtRespDto getJxsCustomerInfo(String yesReqCusB2bCustomerid) {
        String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.organizationid={}", (Object)orgId);
        if (orgId != null && !this.isSmallBlogin()) {
            CustomerExtRespDto customerRespDto = (CustomerExtRespDto)((List)this.customerExtThreeQueryApi.queryByOrgIdList(Collections.singletonList(Long.valueOf(orgId))).getData()).get(0);
            log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u6210\u529f customerRespDto={}", (Object)JSONObject.toJSONString((Object)customerRespDto));
            if (customerRespDto == null) {
                throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
            }
            return customerRespDto;
        }
        log.info("\u4ece yes.req.cus.b2b.organizationid \u83b7\u53d6\u5931\u8d25");
        String customerid = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        log.info("\u83b7\u53d6 yes.req.cus.b2b.customerid={}", (Object)customerid);
        if (customerid == null) {
            customerid = yesReqCusB2bCustomerid;
        }
        if (customerid == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u5934\u83b7\u53d6customerid\u5f02\u5e38");
        }
        CustomerExtRespDto customerLss = (CustomerExtRespDto)this.customerExtThreeQueryApi.queryById(customerid).getData();
        if (customerLss == null) {
            throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25 \u5c0fb\u5ba2\u6237\u67e5\u8be2\u5f02\u5e38");
        }
        CustomerExtRespDto customerJxs = (CustomerExtRespDto)((List)this.customerExtThreeQueryApi.queryByOrgIdList(Collections.singletonList(customerLss.getMerchantId())).getData()).get(0);
        if (customerJxs != null) {
            log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u6210\u529f customerRespDtoList={}", (Object)JSONObject.toJSONString((Object)customerJxs));
            return customerJxs;
        }
        log.info("\u4ece yes.req.cus.b2b.customerid \u83b7\u53d6\u5931\u8d25");
        throw new RuntimeException("\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u79df\u6237\u4fe1\u606f\u5931\u8d25");
    }
}

