/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.CombinationEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ShippingTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderExtInfoDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.trade.api.IOrderItemService;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.enums.OrderBizTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.IPriceLimitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModifyOrderHandler
implements IServiceHandler {
    private static Logger logger = LoggerFactory.getLogger(ModifyOrderHandler.class);
    @Resource
    private ICommonService commonService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOrderItemService itemService;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IOrderTobApi orderTobApi;
    @Resource
    private IPriceLimitService priceLimitService;

    public Object handle(ServiceEvent<?> serviceEvent) {
        PriceAddOrModifyRespDto validate;
        logger.info("=====>\u6267\u884c\u4fee\u6539\u8ba2\u5355");
        SubmitOrderReqDto orderInfoDto = (SubmitOrderReqDto)serviceEvent.getData();
        if (null == orderInfoDto) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ORDER_INFO_NOT_VALID);
        }
        if (orderInfoDto.getId() == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.MODIFY_ORDER_VALID_ID);
        }
        if (StringUtils.isBlank((String)orderInfoDto.getOrderNo())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.MODIFY_ORDER_INFO_NOT_VALID);
        }
        orderInfoDto.setAddress(orderInfoDto.getAddress() == null ? new OrderAddressReqDto() : orderInfoDto.getAddress());
        if (orderInfoDto.getActivityFlag().booleanValue()) {
            orderInfoDto.setItemList(new ArrayList(1));
        }
        if (orderInfoDto.getCheckPriceLimit().booleanValue() && null != (validate = this.priceLimitService.checkPriceLimitByOrder(orderInfoDto)) && CollectionUtils.isNotEmpty((Collection)validate.getPriceOfferLimitItemRespDtos())) {
            return validate;
        }
        Map<Long, ItemDetailRespDto> itemDetails = this.buildOrderItem(orderInfoDto);
        HashMap<Long, ShopDto> shopMap = new HashMap<Long, ShopDto>();
        this.validateOrderInfo(orderInfoDto, itemDetails);
        OrderModTobReqDto orderReqDto = this.convertToOrderReqDto(orderInfoDto);
        List<TradeItemReqDto> tradeItemReqDtos = this.convertToTradeItemReqDtoList(orderInfoDto, itemDetails, shopMap);
        orderReqDto.setOrderItems(tradeItemReqDtos);
        Integer shippingType = orderInfoDto.getShippingType();
        if (shippingType != null && ShippingTypeEnum.getByCode((int)shippingType) != null) {
            orderReqDto.setShippingType(ShippingTypeEnum.getByCode((int)shippingType).getType());
        } else {
            orderReqDto.setShippingType(ShippingTypeEnum.EXPRESS.getType());
        }
        Object orderNo = null;
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u5165\u53c2: orderReqDto={}", (Object)JSON.toJSONString((Object)orderReqDto));
        try {
            orderReqDto.setSubmitType("1");
            orderReqDto.setCustomerId(null);
            orderReqDto.setSellerId(null);
            orderReqDto.setShopId(null);
            orderReqDto.setUserId(null);
            orderReqDto.setPlaceUserId(null);
            orderReqDto.setDeliveryDate(orderInfoDto.getDeliveryDate());
            logger.info("[\u7f16\u8f91\u8ba2\u5355\u5730\u5740]: orderReqDto={}", (Object)JSON.toJSONString((Object)orderReqDto));
            RestResponse voidRestResponse = this.orderTobApi.modifyOrderInfo(orderReqDto);
            RestResponseHelper.extractData((RestResponse)voidRestResponse);
        }
        catch (Exception e) {
            logger.info("\u7f16\u8f91/\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25: orderReqDto={}", (Object)JSON.toJSONString((Object)orderReqDto));
            throw e;
        }
        return orderNo;
    }

    private Map<Long, ItemDetailRespDto> buildOrderItem(SubmitOrderReqDto orderInfoDto) {
        Set itemIdList = orderInfoDto.getItemList().stream().map(OrderItemInfoDto::getItemId).collect(Collectors.toSet());
        HashSet giftItemIdList = new HashSet();
        if (CollectionUtils.isNotEmpty((Collection)orderInfoDto.getGiftItems())) {
            Set collect = orderInfoDto.getGiftItems().stream().map(OrderItemInfoDto::getItemId).collect(Collectors.toSet());
            giftItemIdList.addAll(collect);
        }
        itemIdList.addAll(giftItemIdList);
        Map<Long, ItemDetailRespDto> itemDetails = this.commonService.queryItemDetails(Lists.newArrayList(itemIdList), ((OrderItemInfoDto)orderInfoDto.getItemList().get(0)).getShopId());
        for (ItemDetailRespDto value : itemDetails.values()) {
            if (!giftItemIdList.contains(value.getItem().getId())) continue;
            HashMap<String, Integer> extFields = new HashMap<String, Integer>(value.getExtFields());
            extFields.put("gift", 1);
            value.setExtFields(extFields);
        }
        return itemDetails;
    }

    private void validateOrderInfo(SubmitOrderReqDto orderInfoDto, Map<Long, ItemDetailRespDto> itemDetails) {
        if (Objects.isNull(orderInfoDto.getCustomerId())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.CUSTOMER_INFO_NOT_EMPTY);
        }
        if (CollectionUtils.isEmpty((Collection)orderInfoDto.getItemList())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.TRADE_ITEM_NOT_EMPTY);
        }
        for (OrderItemInfoDto orderItemInfoDto : orderInfoDto.getItemList()) {
            boolean isOnShelf;
            ItemSkuRespDto sku;
            ItemDetailRespDto itemDetailRespDto = itemDetails.get(orderItemInfoDto.getItemId());
            if (null == itemDetailRespDto || null == itemDetailRespDto.getItem() || null == itemDetailRespDto.getItemSkuList()) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_NOT_EXIST);
            }
            if (null == (sku = this.commonService.getItemSkuRespDto(orderItemInfoDto.getSkuId(), itemDetailRespDto))) {
                BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_SKU_NOT_EXIST);
            }
            if (isOnShelf = this.itemService.isOnshelf(orderItemInfoDto.getShopId(), orderItemInfoDto.getItemId(), orderItemInfoDto.getSkuId()).booleanValue()) continue;
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.ITEM_OFF_SHELF);
        }
    }

    private OrderModTobReqDto convertToOrderReqDto(SubmitOrderReqDto orderInfoDto) {
        OrderModTobReqDto orderReqDto = new OrderModTobReqDto();
        orderReqDto.setOrderNo(orderInfoDto.getOrderNo());
        orderReqDto.setTradeNo(orderInfoDto.getOrderNo());
        orderReqDto.setId(orderInfoDto.getId());
        orderReqDto.setBuyerRemark(orderInfoDto.getBuyerRemark());
        orderReqDto.setBizType(OrderBizTypeEnum.ORDER.getCode().toString());
        orderReqDto.setAmountDetail(null);
        Integer effectiveTime = this.commonService.getEffectiveTime();
        if (effectiveTime != null && effectiveTime > 0) {
            orderReqDto.setCloseTime(DateTime.now().plusMinutes(effectiveTime.intValue()).toDate());
        }
        if (Objects.nonNull(orderInfoDto.getInvoiceInfo()) && Objects.nonNull(orderInfoDto.getInvoiceInfo().getInvoiceTaxType())) {
            ArrayList<OrderExtInfoDto> extInfos = new ArrayList<OrderExtInfoDto>();
            OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON((Object)orderInfoDto.getInvoiceInfo());
            jsonObject.put("invoiceLinkAddress", (Object)JSONObject.toJSONString((Object)orderInfoDto.getInvoiceLinkAddress()));
            orderExtInfoDto.setInvoice(jsonObject.toJSONString());
            extInfos.add(orderExtInfoDto);
            orderReqDto.setExtInfos(extInfos);
        }
        orderReqDto.setDeliveryAddress(orderInfoDto.getAddress());
        return orderReqDto;
    }

    private ShopDto getShopDto(Long shopId) {
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        if (null == shopDto || null == shopDto.getId()) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.SHOP_NOT_EXIST);
        }
        return shopDto;
    }

    private List<TradeItemReqDto> convertToTradeItemReqDtoList(SubmitOrderReqDto orderInfoDto, Map<Long, ItemDetailRespDto> itemDetails, Map<Long, ShopDto> shopMap) {
        ArrayList tradeItemReqDtoList = Lists.newArrayList();
        List itemList = orderInfoDto.getItemList();
        if (CollectionUtils.isNotEmpty((Collection)itemList)) {
            itemList.stream().filter(e -> ExchangeEnum.NO.getType().equals(e.getIfExchange()) && CombinationEnum.NO.getType().equals(e.getIsCombinedPackage()) && e.getGift() != 1).forEach(item -> {
                if (shopMap.get(item.getShopId()) == null) {
                    ShopDto shopDto = this.getShopDto(item.getShopId());
                    shopMap.put(item.getShopId(), shopDto);
                }
                ItemDetailRespDto itemDetail = (ItemDetailRespDto)itemDetails.get(item.getItemId());
                HashMap<String, List<Long>> activityIdsMap = new HashMap<String, List<Long>>();
                TradeItemReqDto tradeItemReqDto = this.commonService.covertToTradeItem(orderInfoDto, (OrderItemInfoDto)item, itemDetail, shopMap, orderInfoDto.getPlaceType(), (Map<String, List<Long>>)activityIdsMap);
                tradeItemReqDtoList.add(tradeItemReqDto);
            });
        }
        return tradeItemReqDtoList;
    }
}

