/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.module.trade.biz.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeUtil {
    private static final Logger logger = LoggerFactory.getLogger(TradeUtil.class);
    private static final String TRADE_NO = "TRADENO";
    private static final Integer STR_FORMAT_10 = 10;
    private static final Integer STR_FORMAT_100 = 100;
    private static final Integer STR_FORMAT_1000 = 1000;
    private static final String INDEX_OF_STR = "_";
    private static final String ORDER_NO_RANDOM_CACHE = "ORDER_NO_RANDOM_CACHE:";
    private static int maxPerMSECSize = 999;
    private static TradeUtil tradeUtil;
    @Autowired
    ICacheService cacheService;

    public static String generateTradeNo(String rootTradeNo) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 14);
        String timeMsecStr = timeStr.substring(14, 17);
        Long result = TradeUtil.tradeUtil.cacheService.incr(TRADE_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        rootTradeNo = rootTradeNo.substring(rootTradeNo.length() - 4);
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + rootTradeNo;
        System.out.println(tradeNo);
        return tradeNo;
    }

    public static String generateTradeNo() {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 14);
        String timeMsecStr = timeStr.substring(14, 17);
        Long result = TradeUtil.tradeUtil.cacheService.incr(TRADE_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        String romNo = "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        int romNum = RandomUtils.nextInt((int)1, (int)9999);
        romNo = romNum + "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            romNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            romNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            romNo = "0" + mod;
        }
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + romNo;
        return tradeNo;
    }

    public static String generateOrderNo(String customerCode) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 8);
        String romNo = "";
        Integer romNum = RandomUtils.nextInt((int)1, (int)9999);
        logger.info("\u751f\u6210\u8ba2\u5355\u7f16\u53f7,\u968f\u673a\u6570\uff1a{}", (Object)romNum);
        if (romNum < 10) {
            romNo = "000" + romNum;
        } else if (romNum >= 10 && romNum < 100) {
            romNo = "00" + romNum;
        } else if (romNum >= 100 && romNum < 1000) {
            romNo = "0" + romNum;
        } else if (romNum >= 1000 && romNum < 10000) {
            romNo = "" + romNum;
        }
        String tradeNo = customerCode.substring(0, customerCode.indexOf(INDEX_OF_STR) + 1) + timeSecondStr + romNo;
        logger.info("\u751f\u6210\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)tradeNo);
        String cacheOrderNo = (String)TradeUtil.tradeUtil.cacheService.getCache(ORDER_NO_RANDOM_CACHE + tradeNo, String.class);
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u8ba2\u5355\u53f7\uff1a{}", (Object)cacheOrderNo);
        if (StringUtils.isNotBlank((CharSequence)cacheOrderNo)) {
            return TradeUtil.generateOrderNo(customerCode);
        }
        int expired = (int)DateUtil.dateDiff(new Date(), DateUtil.getDayEnd()) / 1000;
        TradeUtil.tradeUtil.cacheService.setCache(ORDER_NO_RANDOM_CACHE + tradeNo, (Object)tradeNo, expired);
        return tradeNo;
    }

    private static Integer getRomNum(String customerCode) {
        int romNum = RandomUtils.nextInt((int)1, (int)9999);
        Integer cache = (Integer)TradeUtil.tradeUtil.cacheService.getCache(ORDER_NO_RANDOM_CACHE + customerCode + ":" + romNum, Integer.class);
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u968f\u673a\u6570\uff1a{}", (Object)cache);
        if (cache != null) {
            return TradeUtil.getRomNum(customerCode);
        }
        int expired = (int)DateUtil.dateDiff(new Date(), DateUtil.getDayEnd()) / 1000;
        TradeUtil.tradeUtil.cacheService.setCache(ORDER_NO_RANDOM_CACHE + customerCode + ":" + romNum, (Object)romNum, expired);
        return romNum;
    }

    @PostConstruct
    public void init() {
        tradeUtil = this;
        TradeUtil.tradeUtil.cacheService = this.cacheService;
    }

    public static void main(String[] args) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date now = sdf.parse("2022-05-14 23:49:59");
            Date dayEnd = DateUtil.getDayEnd();
            int ex = (int)DateUtil.dateDiff(new Date(), DateUtil.getDayEnd()) / 1000;
            System.out.println(ex);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

