/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.DeliveryItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliveryLogisticRespDto;
import com.dtyunxi.yundt.module.trade.api.IDeliveryService;
import com.dtyunxi.yundt.module.trade.api.dto.MgmtDeliveryItemDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderDeliveredDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7ec4\u4ef6\uff1a\u53d1\u8d27\u5355\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/trade/delivery"})
public class DeliveryRest {
    @Autowired
    private IDeliveryService deliveryService;

    @ApiImplicitParams(value={@ApiImplicitParam(name="shippingCompanyCode", value="\u7269\u6d41\u516c\u53f8\u7f16\u53f7", dataType="String", paramType="query", required=true), @ApiImplicitParam(name="expressCode", value="\u8fd0\u5355\u53f7", dataType="String", paramType="query", required=true)})
    @GetMapping(value={"/delivery-logistics"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\uff08\u5feb\u9012\u9e1f\uff09", notes="\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\uff08\u5feb\u9012\u9e1f\uff09")
    public RestResponse<List<DeliveryLogisticRespDto>> listDeliveryLogistics(@RequestParam(name="shippingCompanyCode") String shippingCompanyCode, @RequestParam(name="expressCode") String expressCode) {
        return new RestResponse((Object)this.deliveryService.listDeliveryLogistics(shippingCompanyCode, expressCode));
    }

    @PostMapping(value={"/confirm/{deliveryNo}"})
    @ApiOperation(value="\u786e\u8ba4\u6536\u8d27", notes="\u786e\u8ba4\u6536\u8d27")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deliveryNo", dataType="String", paramType="path", required=true, value="\u53d1\u8d27\u5355\u53f7"), @ApiImplicitParam(name="orderNo", dataType="String", paramType="query", value="\u8ba2\u8d27\u5355\u53f7")})
    public RestResponse<Void> confirm(@PathVariable(value="deliveryNo") String deliveryNo, @RequestParam(value="orderNo", required=false) String orderNo) {
        this.deliveryService.confirm(deliveryNo, orderNo);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/detail/{deliveryNo}"})
    @ApiOperation(value="\u67e5\u8be2\u53d1\u8d27\u5355\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deliveryNo", dataType="String", paramType="path", required=true, value="\u53d1\u8d27\u5355\u53f7")})
    public RestResponse<OrderDeliveredDetailRespDto> getDetail(@PathVariable(value="deliveryNo") String deliveryNo) {
        return new RestResponse((Object)this.deliveryService.getDetail(deliveryNo));
    }

    @ApiOperation(value="\u5b9e\u9645\u53d1\u8d27\u8be6\u60c5\u5206\u9875", notes="\u5b9e\u9645\u53d1\u8d27\u8be6\u60c5\u5206\u9875")
    @PostMapping(value={"/itemDetail/page"})
    RestResponse<PageInfo<MgmtDeliveryItemDto>> queryItemDetailPage(@RequestBody DeliveryItemReqDto deliveryItemReqDto) {
        return this.deliveryService.queryItemDetailPage(deliveryItemReqDto);
    }
}

