/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageExtDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.bitem.biz.service.IBInventoryService;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderRespDto;
import com.dtyunxi.yundt.module.trade.biz.service.OrderInformMqService;
import com.dtyunxi.yundt.module.trade.biz.storageHelper.IStorageHelper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u624b\u52a8\u4fc3\u53d1 \u53d1\u9001\u53d1\u8d27\u3001\u6536\u8d27\u901a\u77e5\u5355 Rest\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/testRest"})
public class TestRest {
    private static final Logger log = LoggerFactory.getLogger(TestRest.class);
    @Resource
    private IOrderService orderService;
    @Autowired
    private OrderInformMqService orderInformMqService;
    @Resource
    private ITcbjInventoryApi tcbjInventoryApi;
    @Resource
    private IBInventoryService binventoryService;
    @Resource
    private IOrderApi orderApi;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IStorageHelper iStorageHelper;

    @ApiOperation(value="\u4fc3\u53d1\u53d1\u9001\u53d1\u8d27\u3001\u6536\u8d27\u901a\u77e5\u5355")
    @GetMapping(value={"/send"})
    public void send(String tradeNo, Integer type) {
        if (type == 1) {
            ArrayList<OrderQueryEnum> attrs = new ArrayList<OrderQueryEnum>();
            attrs.add(OrderQueryEnum.ITEM);
            attrs.add(OrderQueryEnum.PAY_RECORD);
            attrs.add(OrderQueryEnum.ADDRESS);
            RestResponse restResponse = this.orderBizQueryApi.getOrderDetail(tradeNo, StringUtils.join(attrs, (String)","));
            OrderDetailRespDto orderData = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
            this.orderInformMqService.sendDeliveryInform(tradeNo, orderData);
        } else {
            this.orderInformMqService.sendReciptInform(tradeNo);
        }
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6839\u636e\u8ba2\u5355\u53f7\u586b\u5145\u6279\u6b21")
    @GetMapping(value={"/test"})
    public void test(@RequestParam(value="orderNo") String orderNo) {
        OrderRespDto OrderRespDto2 = this.orderService.getMgmtOrderDetail(orderNo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)OrderRespDto2));
        List itemList = OrderRespDto2.getItemList();
        ArrayList<OrderItemStockBatchDto> orderItemStockBatchDtos = new ArrayList<OrderItemStockBatchDto>();
        OrderStockBatchDto orderStockBatch = new OrderStockBatchDto();
        orderStockBatch.setOrderId(OrderRespDto2.getId());
        block0: for (ItemRespDto itemRespDto : itemList) {
            Integer itemNum = itemRespDto.getItemNum();
            CargoStorageDto cargoStorageDto = new CargoStorageDto();
            WarehouseRespDto warehouseRespDto = this.binventoryService.queryWarehouseByShopId(OrderRespDto2.getShopId());
            cargoStorageDto.setWarehouseId(warehouseRespDto.getId());
            cargoStorageDto.setCargoCode(itemRespDto.getCargoSerial());
            cargoStorageDto.setPageNum(Integer.valueOf(1));
            cargoStorageDto.setPageSize(Integer.valueOf(10000));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tcbjInventoryApi.queryBatch(cargoStorageDto));
            log.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)pageInfo));
            if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                List list = pageInfo.getList();
                for (CargoStorageExtDto dto : list) {
                    OrderItemStockBatchDto orderItemStockBatchDto = new OrderItemStockBatchDto();
                    orderItemStockBatchDto.setBatch(dto.getBatch());
                    orderItemStockBatchDto.setSkuId(itemRespDto.getSkuId());
                    if (dto.getBalance().compareTo(new BigDecimal(itemNum)) >= 0) {
                        orderItemStockBatchDto.setNum(itemNum);
                        orderItemStockBatchDtos.add(orderItemStockBatchDto);
                        continue block0;
                    }
                    orderItemStockBatchDto.setNum(Integer.valueOf(dto.getBalance().intValue()));
                    itemNum = itemNum - dto.getBalance().intValue();
                    orderItemStockBatchDtos.add(orderItemStockBatchDto);
                }
                continue;
            }
            log.info("\u67e5\u8be2\u6279\u6b21\u53f7\u4e3a\u7a7a:{}", (Object)orderNo);
        }
        if (CollectionUtils.isNotEmpty(orderItemStockBatchDtos)) {
            orderStockBatch.setOrderItemStockBatchDtos(orderItemStockBatchDtos);
            log.info("\u6267\u884c\u4fdd\u5b58\u9ed8\u8ba4\u5546\u54c1\u6279\u6b21:{}", (Object)JSON.toJSONString((Object)orderStockBatch));
            this.orderApi.addStockBatch(orderStockBatch);
        } else {
            log.info("\u6267\u884c\u4fdd\u5b58\u9ed8\u8ba4\u5546\u54c1\u6279\u6b21\u4e3a\u7a7a:{}", (Object)orderNo);
        }
    }

    @GetMapping(value={"/noticeInventory/{orderNo}"})
    public RestResponse<Long> not(@PathVariable(value="orderNo") String orderNo) {
        return new RestResponse((Object)this.iStorageHelper.noticeInventoryAddOrder(orderNo));
    }
}

