/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest.ext;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.FinReviewToBReqDto;
import com.dtyunxi.yundt.module.trade.api.IOrderAfterSalesExt;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AfterSalesUpdateExtReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveExtReqDto;
import com.dtyunxi.yundt.module.trade.biz.util.RedisLockUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7ec4\u4ef6\uff1a\u552e\u540e\u670d\u52a1\u6269\u5c55(\u4e0d\u786e\u5b9a\u552e\u540e\u5546\u54c1\u6a21\u5f0f))"})
@RestController
@RequestMapping(value={"/v1/trade/after-sales/uncertainlyItem"})
public class AfterSalesExtRest {
    @Autowired
    IOrderAfterSalesExt orderAfterSalesExt;
    @Resource
    private RedisLockUtil redisLockUtil;

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5269\u4f59\u9000\u8d27\u989d\u5ea6", notes="\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5269\u4f59\u9000\u8d27\u989d\u5ea6")
    @GetMapping(value={"/queryReturnQuotaByCust"})
    public RestResponse<BigDecimal> queryReturnQuotaByCust(@RequestParam(name="customerId") Long customerId) {
        BigDecimal returnQuota = this.orderAfterSalesExt.queryReturnQuotaByCust(customerId);
        return new RestResponse((Object)returnQuota);
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u5728\u67d0\u4e2a\u5546\u5bb6\u7684\u5269\u4f59\u9000\u8d27\u989d\u5ea6", notes="\u67e5\u8be2\u5ba2\u6237\u5728\u67d0\u4e2a\u5546\u5bb6\u7684\u5269\u4f59\u9000\u8d27\u989d\u5ea6")
    @GetMapping(value={"/queryReturnQuotaBySeller"})
    public RestResponse<BigDecimal> queryReturnQuotaBySeller(@RequestParam(name="sellerId") Long sellerId) {
        BigDecimal returnQuota = this.orderAfterSalesExt.queryReturnQuotaBySeller(sellerId);
        return new RestResponse((Object)returnQuota);
    }

    @RequestMapping(value={"/addApplyByOrder"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u552e\u540e\u5355\u7533\u8bf7,\u4ece\u539f\u8ba2\u5355\u7533\u8bf7\uff08\u5b9e\u9645\u9000\u8d27\u5546\u54c1\u4e0d\u786e\u5b9a\uff09", notes="\u65b0\u589e\u552e\u540e\u5355\u7533\u8bf7,\u4ece\u539f\u8ba2\u5355\u7533\u8bf7\uff08\u5b9e\u9645\u9000\u8d27\u5546\u54c1\u4e0d\u786e\u5b9a\uff09")
    RestResponse<String> addApplyByOrder(@Valid @RequestBody ReturnOrderSaveExtReqDto reqDto) {
        String returnNo = this.orderAfterSalesExt.addAfterSalesByOrder(reqDto);
        return new RestResponse((Object)returnNo);
    }

    @RequestMapping(value={"/addApplyManual"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u552e\u540e\u5355\u7533\u8bf7,\u624b\u5de5\u6dfb\u52a0\u5546\u54c1", notes="\u65b0\u589e\u552e\u540e\u5355\u7533\u8bf7,\u624b\u5de5\u6dfb\u52a0\u5546\u54c1\uff08\u5b9e\u9645\u9000\u8d27\u5546\u54c1\u4e0d\u786e\u5b9a\uff09")
    RestResponse<String> addApplyManual(@RequestBody ReturnOrderSaveExtReqDto reqDto) {
        String returnNo = this.orderAfterSalesExt.addAfterSalesManual(reqDto);
        return new RestResponse((Object)returnNo);
    }

    @RequestMapping(value={"/updateReturnInfo"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiOperation(value="\u7f16\u8f91\u552e\u540e\u5355", notes="\u7f16\u8f91\u552e\u540e\u5355")
    RestResponse<Void> updateReturnInfo(@Valid @RequestBody AfterSalesUpdateExtReqDto reqDto) {
        this.orderAfterSalesExt.updateAfterSales(reqDto);
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @ApiOperation(value="\u5ba1\u6838\u8ba2\u5355", notes="\u5ba1\u6838\u8ba2\u5355")
    @PostMapping(value={"/audit-order"})
    public RestResponse<Void> auditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        String lockKey = "order-audit:" + orderAuditToBReqDto.getOrderNo();
        String lockValue = this.redisLockUtil.tryGetLock(lockKey);
        if (lockValue == null) {
            throw new BizException("\u8ba2\u5355[" + orderAuditToBReqDto.getOrderNo() + "]\u5df2\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb...");
        }
        try {
            this.orderAfterSalesExt.auditOrder(orderAuditToBReqDto);
        }
        finally {
            this.redisLockUtil.releaseLock(lockKey, lockValue);
        }
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @ApiOperation(value="\u53cd\u5ba1\u6838\uff08\u9a73\u56de\u5230\u5f85\u5ba1\u6838\uff09", notes="\u53cd\u5ba1\u6838\uff08\u9a73\u56de\u5230\u5f85\u5ba1\u6838\uff09")
    @PostMapping(value={"/reject-audit-order"})
    public RestResponse<Void> rejectAuditOrder(@Valid @RequestBody OrderAuditToBReqDto orderAuditToBReqDto) {
        String lockKey = "order-audit:" + orderAuditToBReqDto.getOrderNo();
        String lockValue = this.redisLockUtil.tryGetLock(lockKey);
        if (lockValue == null) {
            throw new BizException("\u8ba2\u5355[" + orderAuditToBReqDto.getOrderNo() + "]\u5df2\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u52ff\u9891\u7e41\u70b9\u51fb...");
        }
        try {
            this.orderAfterSalesExt.rejectAuditOrder(orderAuditToBReqDto);
        }
        finally {
            this.redisLockUtil.releaseLock(lockKey, lockValue);
        }
        return RestResponse.VOID;
    }

    @ApiImplicitParam(name="orderAuditReqDto", dataType="OrderAuditReqDto", paramType="body", required=true, value="\u5ba1\u6838\u8ba2\u5355\u53c2\u6570")
    @ApiOperation(value="\u8d22\u52a1\u590d\u5ba1\u9000\u8ba2\u5355", notes="\u8d22\u52a1\u590d\u5ba1\u9000\u8ba2\u5355")
    @PostMapping(value={"/fin-review-order"})
    public RestResponse<Void> finReviewOrder(@Valid @RequestBody FinReviewToBReqDto finReviewToBReqDto) {
        this.orderAfterSalesExt.finReviewOrder(finReviewToBReqDto);
        return RestResponse.VOID;
    }
}

