/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.trade.api.IShoppingCart;
import com.dtyunxi.yundt.module.trade.api.dto.request.CartItemBatchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.CombinedPackageItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ShoppingCartItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.TrolleyQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.MutShoppingCartRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ShoppingCartRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7ec4\u4ef6\uff1a\u8d2d\u7269\u8f66\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/trade/shopping-cart"})
public class ShoppingCartRest {
    @Resource
    private IShoppingCart shoppingCart;

    @ApiOperation(value="\u5546\u54c1\u52a0\u5165\u8d2d\u7269\u8f66")
    @ApiImplicitParam(name="shoppingCartItemReqDto", paramType="body", dataType="ShoppingCartItemReqDto", required=true, value="\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={"/item"})
    public RestResponse<Long> addItem(@Valid @RequestBody ShoppingCartItemReqDto shoppingCartItemReqDto) {
        return new RestResponse((Object)this.shoppingCart.addItem(shoppingCartItemReqDto));
    }

    @ApiOperation(value="\u5546\u54c1\u6279\u91cf\u52a0\u5165\u8d2d\u7269\u8f66")
    @ApiImplicitParam(name="cartItemBatchReqDto", paramType="body", dataType="CartItemBatchReqDto", required=true, value="\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u6dfb\u52a0\u4fe1\u606f")
    @PostMapping(value={"/item-batch"})
    public RestResponse<List<String>> addItemBatch(@Valid @RequestBody CartItemBatchReqDto cartItemBatchReqDto) {
        return new RestResponse((Object)this.shoppingCart.addItemBatch(cartItemBatchReqDto));
    }

    @ApiOperation(value="\u5546\u54c1\u6279\u91cf\u52a0\u5165\u8d2d\u7269\u8f66")
    @ApiImplicitParam(name="cartItemBatchReqDto", paramType="body", dataType="CartItemBatchReqDto", required=true, value="\u8d2d\u7269\u8f66\u5546\u54c1\u6279\u91cf\u6dfb\u52a0\u4fe1\u606f")
    @PostMapping(value={"/item-batch/ext"})
    public RestResponse<List<String>> addItemBatchExt(@Valid @RequestBody CartItemBatchReqDto cartItemBatchReqDto) {
        return new RestResponse((Object)this.shoppingCart.addItemBatchExt(cartItemBatchReqDto));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1", notes="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\uff0cids\u591a\u4e2a\u5df2\u9017\u53f7\u9694\u5f00")
    @ApiImplicitParam(name="ids", paramType="query", dataType="String", required=true, value="\u8d2d\u7269\u8f66\u5546\u54c1\u9879id")
    @DeleteMapping(value={"/item"})
    public RestResponse<Void> removeItem(@RequestParam(value="ids") String ids) {
        this.shoppingCart.removeItem(ids);
        return new RestResponse();
    }

    @ApiOperation(value="\u4fee\u6539\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", paramType="query", dataType="String", required=true, value="\u8d2d\u7269\u8f66\u5546\u54c1\u9879id"), @ApiImplicitParam(name="itemNum", paramType="query", dataType="Int", required=true, value="\u5546\u54c1\u6570\u91cf")})
    @PutMapping(value={"/item"})
    public RestResponse<Void> modifyItem(@RequestParam(value="id") Long id, @RequestParam(value="itemNum") Integer itemNum) {
        this.shoppingCart.modifyItem(id, itemNum);
        return new RestResponse();
    }

    @ApiOperation(value="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/item/list"})
    public RestResponse<ShoppingCartRespDto> queryItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        return new RestResponse((Object)this.shoppingCart.queryItemList(trolleyQueryReqDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u590d\u5408\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/item/mut/list"})
    public RestResponse<MutShoppingCartRespDto> queryMutItemList(TrolleyQueryReqDto trolleyQueryReqDto) {
        return new RestResponse((Object)this.shoppingCart.queryMutItemList(trolleyQueryReqDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u590d\u5408\u8d2d\u7269\u8f66\u5546\u54c1\u5206\u7ec4\u5217\u8868")
    @PostMapping(value={"/item/mut/group/list"})
    public RestResponse<MutShoppingCartRespDto> queryMutItemGroupList(@RequestBody TrolleyQueryReqDto trolleyQueryReqDto) {
        return new RestResponse((Object)this.shoppingCart.queryMutItemList(trolleyQueryReqDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u5217\u8868\u6570\u91cf")
    @GetMapping(value={"/item/num"})
    public RestResponse<Integer> queryItemListNum(TrolleyQueryReqDto trolleyQueryReqDto) {
        return new RestResponse((Object)this.shoppingCart.queryItemListNum(trolleyQueryReqDto));
    }

    @ApiOperation(value="\u7ec4\u5408\u5957\u88c5\u52a0\u5165\u8d2d\u7269\u8f66")
    @ApiImplicitParam(name="combinedPackageItemReqDto", paramType="body", dataType="CombinedPackageItemReqDto", required=true, value="\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={"/add/combinedPackageItem"})
    public RestResponse<Long> addCombinedPackageItem(@Valid @RequestBody CombinedPackageItemReqDto combinedPackageItemReqDto) {
        return new RestResponse((Object)this.shoppingCart.addCombinedPackageItem(combinedPackageItemReqDto));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1", notes="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\uff0cids\u591a\u4e2a\u5df2\u9017\u53f7\u9694\u5f00")
    @PostMapping(value={"/item/ext"})
    public RestResponse<Void> batchRemoveItem(@Valid @RequestBody List<Long> ids) {
        this.shoppingCart.batchRemoveItem(ids);
        return new RestResponse();
    }
}

