/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.context.biz.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.ApplicationBatchQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.module.context.common.config.AppRecognitionConfig;
import com.dtyunxi.yundt.module.context.common.dto.RequestApp;
import com.dtyunxi.yundt.module.context.common.impl.RequestPreProcessService;
import com.dtyunxi.yundt.module.context.common.vo.CacheVo;

public class CenterRequestPreProcessService
extends RequestPreProcessService<ServiceContext, RequestApp, ApplicationBatchQueryDto, AppInstanceDto> {
    private IApplicationQueryApi applicationQueryApi;

    public CenterRequestPreProcessService(IApplicationQueryApi applicationQueryApi, AppRecognitionConfig appRecognitionConfig, ICacheService cacheService) {
        super(appRecognitionConfig, cacheService);
        this.applicationQueryApi = applicationQueryApi;
    }

    public void appInfo(ServiceContext serviceContext, AppRecognitionConfig.DefaultValue defaultValue) {
        Long requestTenantId;
        Long requestInstanceId;
        Long requestApplicationId = serviceContext.getRequestApplicationId();
        if (requestApplicationId != null) {
            logger.debug("\u8bc6\u522b\u4e0d\u51fa\uff0c\u4f18\u5148\u4f7f\u7528\u8bf7\u6c42\u7684requestApplicationId\uff1a{}", (Object)requestApplicationId);
            defaultValue.setAppId(requestApplicationId);
        }
        if ((requestInstanceId = serviceContext.getRequestInstanceId()) != null) {
            logger.debug("\u8bc6\u522b\u4e0d\u51fa\uff0c\u4f18\u5148\u4f7f\u7528\u8bf7\u6c42\u7684requestInstanceId\uff1a{}", (Object)requestInstanceId);
            defaultValue.setInstanceId(requestInstanceId);
        }
        if ((requestTenantId = serviceContext.getRequestTenantId()) != null) {
            logger.debug("\u8bc6\u522b\u4e0d\u51fa\uff0c\u4f18\u5148\u4f7f\u7528\u8bf7\u6c42\u7684requestTenantId\uff1a{}", (Object)requestTenantId);
            defaultValue.setTenantId(requestTenantId);
        }
    }

    public RequestApp request2User(ServiceContext serviceContext, String requestUrl, ApplicationBatchQueryDto applicationBatchQueryDto) {
        RestResponse restResponse = this.applicationQueryApi.findByHostnameInOneTime(applicationBatchQueryDto);
        return this.packRequestApp(serviceContext, restResponse, requestUrl);
    }

    public ApplicationBatchQueryDto queryDto(String applicationKey, String referer, String xRealHostname, String requestUrl) {
        ApplicationBatchQueryDto applicationBatchQueryDto = new ApplicationBatchQueryDto();
        applicationBatchQueryDto.setApplicationKey(applicationKey);
        applicationBatchQueryDto.setReferer(referer);
        applicationBatchQueryDto.setxRealHostname(xRealHostname);
        applicationBatchQueryDto.setToReturnRequestUrl(requestUrl);
        return applicationBatchQueryDto;
    }

    public void packRequestApp(AppInstanceDto appInstanceDto, RequestApp requestApp) {
        Long tenantId;
        Long applicationId;
        Long instanceId = appInstanceDto.getId();
        if (instanceId == null) {
            instanceId = appInstanceDto.getInstanceId();
        }
        if (instanceId != null) {
            requestApp.setReqInstanceId(instanceId);
        }
        if ((applicationId = appInstanceDto.getApplicationId()) != null) {
            requestApp.setReqAppId(applicationId);
        }
        if ((tenantId = appInstanceDto.getTenantId()) != null) {
            requestApp.setReqTenantId(tenantId);
        }
        requestApp.setTargetUrl(appInstanceDto.getRequestUrl());
    }

    public RequestApp cacheRsOrRequest(CacheVo cacheVo, ServiceContext serviceContext, String requestUrl, ApplicationBatchQueryDto applicationBatchQueryDto) {
        if (cacheVo.getRequestApp() == null) {
            RequestApp requestApp = this.request2User(serviceContext, requestUrl, applicationBatchQueryDto);
            this.cacheRequestRs(cacheVo.getAppKeyKey(), cacheVo.getxRealHostnameKey(), cacheVo.getRefererKey(), requestApp);
            return requestApp;
        }
        return cacheVo.getRequestApp();
    }

    public RequestApp emptyRs() {
        return null;
    }
}

