/**
 * @(#)UserExceptionCode.java 1.0 2016-11-10
 * <p>
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api.exception;

/**
 * 描述
 *
 * @author xuhuaqiang
 * @since 0.6.0
 */
public enum CustomerModuleExceptionCode {

    NON_EXIST_PARAM("30001", "参数不能为空"),
    EMPTY_PARAM_ERROR("30002", "参数错误，请检查参数"),
    EXIST_DIR_CHILD("30003", "存在子目录，请先操作子目录"),
    RECORD_NOT_EXIST("30004", "记录不存在"),
    TIME_FORMAT_ERROR("30005", "错误的时间格式(格式为yyyy-MM-dd HH:mm:ss)"),
    NAME_EXISTS("30006", "名称已经存在"),
    NAME_NULL("30007", "名称不允许为空"),
    CODE_EXISTS("30008", "编码已经存在"),
    RELATION_EXISTS("30009", "存在关联关系"),
    PK_ID_NULL("30010", "主键id不允许为空"),
    REGION_EXISTS_CUSTOMER("30011", "该区域下存在客户，请先将该部分客户转移到其他区域！"),
    REGION_EXISTS_CHILD("30012", "该区域下存在子区域，请先删除子区域！"),
    REGION_NAME_EXISTS("30013", "该区域名称已存在，请重新输入！"),
    CUSTOMER_UPLOAD_OSS_ERROR("30014", "导出客户上传oss出现异常，请重新操作"),
    REGION_NO_EXISTS("30015", "客户区域不存在，请重新选择！"),
    USER_NAME_EXISTS("30016", "登录账号名已被注册!"),
    LOGIN_FAIL("30017", "登录失败"),
    CUSTOMER_TYPE_NO_EXISTS("30018", "该客户类型不存在，请重新选择！"),
    //SALESMAN_LOGIN_FAIL("30019", "您的账号无法登录业务员端，请重新确认您的账号是否为业务员身份，谢谢。"),

    SALESMAN_LOGIN_FAIL("30019", "您的账号无法登录业务员端，原因可能为所属商家人员未绑定客户或已禁用或已过期等"),





    ;


    private final String code;

    private final String msg;


    private CustomerModuleExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }

    public static String getDesc(String index) {
        for (CustomerModuleExceptionCode exceptionCode : CustomerModuleExceptionCode.values()) {
            if (exceptionCode.getCode().equals(index)) {
                return exceptionCode.getMsg();
            }
        }
        return null;
    }

}
