package com.dtyunxi.yundt.module.customer.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "VerifyCustomerByOrgIdReqDto", description = "批量校验三要素ByOrgId")
public class CheckCreditByCustomerCodeReqDto {

    /************* 校验同一租户下是否有相同credit *********************/

    @ApiModelProperty(value = "客户编号")
    private String cusCode;

    @ApiModelProperty("organization_info.credit_code")
    private String creditCode;

    /************** 客户名称与orgName 50%匹配 ********************/

    @ApiModelProperty("organization_info.org_name")
    private String orgName;
}
