package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 业务渠道
 * @author lius5
 */
public enum BizChannelEnum {

    BY_HEALTH("1000000000000000001","汤臣倍健事业部"),
    BY_BESSER("1000000000000000002","佰嘉事业部"),
    LIFE_SPACE("1000000000000000003","海外品牌事业部"),

    ;

    private String code;
    private String name;

    BizChannelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static BizChannelEnum fromCode(String code) {
        for (BizChannelEnum typeEnum : BizChannelEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static BizChannelEnum fromName(String name) {
        for (BizChannelEnum typeEnum : BizChannelEnum.values()) {
            if (typeEnum.getName().equals(name)) {
                return typeEnum;
            }
        }
        return null;
    }
}
