package com.dtyunxi.yundt.module.customer.api.enums;

/**
 * 是否是默认设置
 *
 * @author zhuiming
 * @date 2021/6/4
 */
public enum DefaultSettingEnum {
    /**
     * 否
     */
    NO(0, "否"),
    /**
     * 是
     */
    YES(1, "是"),


    ;

    private final Integer code;
    private final String name;

    DefaultSettingEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static DefaultSettingEnum fromCode(Integer status) {
        for (DefaultSettingEnum typeEnum : DefaultSettingEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        DefaultSettingEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        DefaultSettingEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
