package com.dtyunxi.yundt.module.customer.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 客户SKU授权数量统计响应DTO
 *
 * @author system
 * @date 2024-01-01
 */
@ApiModel(value = "客户SKU授权数量统计响应DTO")
public class CustomerSkuAuthCountRespDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "SKU ID")
    private Long skuId;

    @ApiModelProperty(value = "已授权客户数量")
    private Long authorizedCount;

    @ApiModelProperty(value = "未授权客户数量")
    private Long unauthorizedCount;

    @ApiModelProperty(value = "总客户数量")
    private Long totalCount;

    public CustomerSkuAuthCountRespDto() {
    }

    public CustomerSkuAuthCountRespDto(Long skuId, Long authorizedCount, Long unauthorizedCount) {
        this.skuId = skuId;
        this.authorizedCount = authorizedCount;
        this.unauthorizedCount = unauthorizedCount;
        this.totalCount = authorizedCount + unauthorizedCount;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getAuthorizedCount() {
        return authorizedCount;
    }

    public void setAuthorizedCount(Long authorizedCount) {
        this.authorizedCount = authorizedCount;
    }

    public Long getUnauthorizedCount() {
        return unauthorizedCount;
    }

    public void setUnauthorizedCount(Long unauthorizedCount) {
        this.unauthorizedCount = unauthorizedCount;
    }

    public Long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    public String toString() {
        return "CustomerSkuAuthCountRespDto{" +
                "skuId=" + skuId +
                ", authorizedCount=" + authorizedCount +
                ", unauthorizedCount=" + unauthorizedCount +
                ", totalCount=" + totalCount +
                '}';
    }
} 