/**
 * @(#)IItemProcess.java 1.0 2019/10/12
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.company.CompanyVerifyReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.company.CompanyVerifyRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.module.customer.api.dto.MerchantDetailRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.MerchantListRespDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;

import java.util.List;

/**
 * 客户信息服务
 *
 * @author xuhuaqiang
 */
public interface ICustomerExtService {


    /***
     * 根据id查询客户信息详情
     * @param id
     * @return
     */
    CustomerExtDetailRespDto queryById(Long id);


    PageInfo<MerchantListRespDto> queryMerchantByPage(String filter, Integer pageNum, Integer pageSize);

    PageInfo<CustomerExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize);

    MerchantDetailRespDto queryMerchantByCurrentUser();

    /**
     * 根据统一社会信用代码查询公司信息
     * @param creditCode
     * @return
     */
    StoreRespDto queryCompanyByCreditCode(String creditCode,String customerCode);

    /**
     * 企业三要素校验
     * @param verifyCompanyReqDto
     * @return
     */
    CompanyVerifyRespDto verifyCompany(CompanyVerifyReqDto verifyCompanyReqDto);

    Void updateCustomerStatus(Long id, Long statusId);

    void update(CustomerReqExtDto reqDto);

    RestResponse<CustomerAddResultDto> add(CustomerReqExtDto reqDto);

    RestResponse<List<String>> batchUpCusIfWholePurchase(CustomerBatchUpReqDto reqDto);
}
