package com.dtyunxi.yundt.module.customer.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author xuhuaqiang
 * @version 1.0.0
 * @description
 * @date 2021/07/22 19:28
 */
@ApiModel(value = "MerchantSearchReqDto", description = "商家搜索请求Dto")
public class MerchantSearchReqDto {

    private static final long serialVersionUID = 221080511738756219L;

    /**
     * 商家编号
     */
    @ApiModelProperty(name = "merchantCode", value = "商家编号")
    private String merchantCode;
    /**
     * 商家名称
     */
    @ApiModelProperty(name = "merchantName", value = "商家名称")
    private String merchantName;
    /**
     * 公司名称
     */
    @ApiModelProperty(name = "companyName", value = "公司名称")
    private String companyName;
    /**
     * 商家状态（3: 启用 4: 禁用）
     */
    @ApiModelProperty(name = "settleStatus", value = "商家状态（3: 启用 4: 禁用）")
    private Integer settleStatus;

    @ApiModelProperty(name = "settleStatusList",value = "入驻状态集合")
    private List<Integer> settleStatusList;

    @ApiModelProperty(name = "orgInfoIds",value = "组织ID集合")
    private List<Long> orgInfoIds;

    @ApiModelProperty(name = "type", value = "客户类型（1：品牌商，2：大B，3：零售商）")
    private Integer type;

    @ApiModelProperty(name = "channel", value = "渠道类型（1：品牌方运营端，2：大B卖家端）")
    private Integer channel;

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<Long> getOrgInfoIds() {
        return orgInfoIds;
    }

    public void setOrgInfoIds(List<Long> orgInfoIds) {
        this.orgInfoIds = orgInfoIds;
    }

    public List<Integer> getSettleStatusList() {
        return settleStatusList;
    }

    public void setSettleStatusList(List<Integer> settleStatusList) {
        this.settleStatusList = settleStatusList;
    }

    public String getMerchantCode() {
        return merchantCode;
    }

    public void setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(Integer settleStatus) {
        this.settleStatus = settleStatus;
    }
}
