package com.dtyunxi.yundt.module.customer.biz.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 药店导入操作数据
 * @author lius5
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class StoreExportVo {

    /**
     *  机构名称
     */
    @Excel(name = "* 药店名称（公司名称）")
    private String storeName;
    /**
     *  机构曾用名
     */
    @Excel(name = "机构曾用名")
    private String storeAlias;
    /**
     *  统一社会信用代码
     */
    @Excel(name = "* 统一社会信用代码")
    private String socialCreditNum;
    /**
     *  机构类型
     */
    @Excel(name = "* 机构类型")
    private String storeType;
    /**
     *  机构所属省份
     */
    @Excel(name = "* 机构所属省份")
    private String province;
    /**
     *  机构所属省份code
     */
    @Excel(name = "* 机构所属省份code")
    private String provinceCode;
    /**
     *  机构所属城市
     */
    @Excel(name = "* 机构所属城市")
    private String city;
    /**
     *  机构所属城市code
     */
    @Excel(name = "* 机构所属城市code")
    private String cityCode;
    /**
     *  机构所属区县
     */
    @Excel(name = "* 机构所属区县")
    private String district;
    /**
     *  机构所属区县code
     */
    @Excel(name = "* 机构所属区县code")
    private String districtCode;
    /**
     *  机构详细地址
     */
    @Excel(name = "* 机构详细地址")
    private String storeAddr;

    /**
     *  机构详细地址
     */
    @Excel(name = "机构注册地址")
    private String storeRegisterAddr;
    /**
     *  是否连锁药店
     */
    @Excel(name = "是否连锁药店")
    private String isChain;
    /**
     *  是否医保药店
     */
    @Excel(name = "是否医保药店")
    private String isInsurance;
    /**
     *  经度
     */
    @Excel(name = "经度")
    private String log;
    /**
     *  纬度
     */
    @Excel(name = "纬度")
    private String lat;
    /**
     *  药品经营许可证
     */
    @Excel(name = "药品经营许可证")
    private String dbln;
    /**
     *  状态
     */
    @Excel(name = "* 状态")
    private String state;
    /**
     *  上级总部名称
     */
    @Excel(name = "上级总部名称")
    private String storeParentName;
    /**
     *  上级总部社会信用代码
     */
    @Excel(name = "上级总部社会信用代码")
    private String parentSocialCreditNum;
    /**
     *  是否大客户 0：非大客户；1：大客户
     */
    @Excel(name = "是否大客户",replace = {"否_0","是_1"})
    private Integer isCustomer;
    /**
     *  是否大客户 0：非大客户；1：大客户
     */
    @Excel(name = "* 法人")
    private String legalPersonName;

    /**
     *  是否大客户 0：非大客户；1：大客户
     */
    @Excel(name = "* 是否信用代码注册",replace = {"否_0","是_1"})
    private Integer isFlag;

    /**
     *  是否大客户 0：非大客户；1：大客户
     */
    @Excel(name = "客户系统类型",replace = {"无_0","老百姓系统_1","国大系统_2","海王系统_3","益丰系统_4","大参林系统_5",
            "高济系统_6","健之佳系统_7","一心堂系统_8","山东漱玉_9","山东金通_10","贵州一品_11", "贵州一树_12",
            "福建新紫金_13","湖北天济_14","广西康全_15"})
    private Integer customerSystem;


    /**
     *  是否大客户 0：非大客户；1：大客户
     */
    @Excel(name = "屏蔽业务线")
    private String bizChannel;

    @Excel(name = "导入失败原因")
    private String  reason;

    /**
     * 存储子集
     */
    private List<StoreExportVo> children = Lists.newArrayList();
}
