package com.dtyunxi.yundt.module.customer.biz.impl.user;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.MenuDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IAccessExtQueryApi;
import com.dtyunxi.yundt.module.customer.api.user.IAccessExtService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 权限查询服务实现
 */
@Service
public class IAccessExtServiceImpl  implements IAccessExtService {
    private static final Logger logger = LoggerFactory.getLogger(IAccessExtServiceImpl.class);

    @Resource
    private IAccessExtQueryApi accessExtQueryApi;
    @Resource
    private HttpServletRequest request;

    /**
     * 获取请求头的组织ID
     *
     * @return 组织ID
     */
    public String headerOrgId() {
        String organizationId = request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("获取请求头组织ID：{}", organizationId);
        return organizationId;
    }


    @Override
    public RestResponse<UserAccessRespDto> queryUserAccess(Long userId, Long instanceId) {
        UserAccessRespDto respDto = new UserAccessRespDto();
        respDto.setUserId(userId);
        respDto.setMenus(new ArrayList<>());
        /* 获取组织信息 */
        String organizationId = this.headerOrgId();
        logger.info("请求头组织ID：{}", organizationId);

//        if (StringUtils.isBlank(organizationId)){
//            organizationId = nacosPropertiesOrgEntity.orgId();
//            logger.info("nacos配置的组织ID：{}", organizationId);
//        }
        if(StringUtils.isBlank(organizationId)){
            logger.error("请求头缺失组织ID");
            return new RestResponse<>(respDto);
        }

        ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationId",organizationId);
        UserAccessRespDto userAccessRespDto = RestResponseHelper.extractData(accessExtQueryApi.queryUserAccess(userId,organizationId, instanceId));
        if (userAccessRespDto != null) {
            final List<MenuDto> newList = userAccessRespDto.getMenus().stream().filter(a -> instanceId.equals(a.getInstanceId())).collect(Collectors.toList());
            userAccessRespDto.setMenus(newList);
        }
        return new RestResponse<>(userAccessRespDto);
    }



}
