/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IEmployeeCustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeNumCountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeNumCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleExpandReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeImportReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IRoleQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.RestUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeExpandRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.query.ISellerExpandQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeExpand2ServiceImpl
implements IEmployeeExpand2Service {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeExpand2ServiceImpl.class);
    @Resource
    private IEmployeeExpandApi employeeExpandApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeCustomerApi employeeCustomerApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ISellerExpandQueryApi sellerExpandQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IContext context;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IRoleQueryApi roleQueryApi;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;
    @Resource
    private IUserExtQueryApi userExtQueryApi;

    public Map<String, CustomerRespDto> getOrgCustomerMap(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return new HashMap<String, CustomerRespDto>();
        }
        RestResponse customerRest = this.employeeCustomerQueryApi.queryCustomerListByCodes(customerCodeList);
        if (customerRest == null || CollectionUtils.isEmpty((Collection)((Collection)customerRest.getData()))) {
            return new HashMap<String, CustomerRespDto>();
        }
        List customerList = (List)customerRest.getData();
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        return customerMap;
    }

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        return tenantId;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        Integer type;
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        String orgId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        if (Objects.nonNull(employeeDto.getOrganizationId())) {
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        AssertUtil.assertNotBlank((String)orgId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull((Object)instanceId, (String)"\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        Long tenantId = this.tenantId();
        employeeDto.setOrganizationId(Long.valueOf(Long.parseLong(orgId)));
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            AssertUtil.assertNotNull((Object)employeeDto.getOrgId(), (String)"\u6240\u9009\u7ec4\u7ec7[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.assertNotNull((Object)employeeDto.getOrganizationCode(), (String)"\u6240\u9009\u7ec4\u7ec7\u4ee3\u7801[organizationCode]\u4e0d\u80fd\u4e3a\u7a7a");
            employeeDto.setOrganizationId(employeeDto.getOrganizationId());
        }
        if ((type = Integer.valueOf(Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType())) == 1 && StringUtils.isNotEmpty((CharSequence)employeeDto.getCustomerCode())) {
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())) {
                throw new BizException("\u5ba2\u6237\u7f16\u53f7[" + employeeDto.getCustomerCode() + "]\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            employeeDto.setOrganizationId(customerRespDto.getOrgInfoId());
            employeeDto.setCustomerCode(null);
        }
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);
        employeeDto.setType(type);
        Long employeeId = (Long)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.addEmployee(instanceId, (EmployeeExtReqDto)employeeDto));
        employeeDto.setId(employeeId);
        this.bindEmployeeCustomer(employeeDto);
        return new RestResponse((Object)employeeId);
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        Integer type;
        logger.info("\u4fee\u6539\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        AssertUtil.assertNotNull((Object)employeeDto.getId(), (String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)instanceId, (String)"\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        Long tenantId = this.tenantId();
        String orgId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        if (Objects.nonNull(employeeDto.getOrganizationId())) {
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        AssertUtil.assertNotBlank((String)orgId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            AssertUtil.assertNotNull((Object)employeeDto.getOrgId(), (String)"\u6240\u9009\u7ec4\u7ec7[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.assertNotNull((Object)employeeDto.getOrganizationCode(), (String)"\u6240\u9009\u7ec4\u7ec7\u4ee3\u7801[organizationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((type = Integer.valueOf(Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType())) == 1 && StringUtils.isNotEmpty((CharSequence)employeeDto.getCustomerCode())) {
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())) {
                throw new BizException("\u5ba2\u6237\u7f16\u53f7[" + employeeDto.getCustomerCode() + "]\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            orgId = customerRespDto.getOrgInfoId().toString();
            employeeDto.setCustomerCode(null);
        }
        employeeDto.setOrganizationId(Long.valueOf(Long.parseLong(orgId)));
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.modifyEmployee(instanceId, (EmployeeExtReqDto)employeeDto));
        this.bindEmployeeCustomer(employeeDto);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryByPage(EmployeeExpandQueryReqDto reqDto) {
        List dtoList;
        List areaCodes;
        logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)reqDto.getOrganizationId());
        String organizationId = null;
        if (Objects.isNull(reqDto.getOrganizationId())) {
            organizationId = this.headerOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        } else {
            organizationId = String.valueOf(reqDto.getOrganizationId());
        }
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull((Object)reqDto.getInstanceId(), (String)"\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        Long orgId = StringUtils.isBlank((CharSequence)organizationId) ? null : Long.valueOf(Long.parseLong(organizationId));
        reqDto.setOrganizationId(orgId);
        Long tenantId = this.tenantId();
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList employeeIds = new ArrayList();
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1) {
            CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
            customerExtQuery.setMerchantId(reqDto.getOrganizationId());
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getEmpCustomerCode())) {
                customerExtQuery.setCode(reqDto.getEmpCustomerCode());
            }
            customerExtQuery.setCustomerNameLike(reqDto.getCustomerNameLike());
            customerExtQuery.setCustomerCodeLike(reqDto.getCustomerCodeLike());
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2)\uff0c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)customerExtQuery));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        }
        List empCustDtos = null;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName()) || StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCode(reqDto.getCustomerCode());
            customerExtReqDto.setName(reqDto.getCustomerName());
            customerExtReqDto.setInstanceId(reqDto.getInstanceId());
            customerExtReqDto.setMerchantId(reqDto.getOrganizationId());
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)customerExtReqDto));
            empCustDtos = (List)RestUtil.checkResponse((RestResponse)this.employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            logger.info("\u7ed3\u675f\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)empCustDtos));
            if (CollectionUtils.isEmpty((Collection)empCustDtos)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List _ids = empCustDtos.stream().map(EmployeeCustomerRespDto::getEmployeeId).collect(Collectors.toList());
            employeeIds.addAll(_ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerAreaList()) && CollectionUtils.isNotEmpty(areaCodes = reqDto.getCustomerAreaList().stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getAreaCode())).map(CustomerAreaExtReqDto::getAreaCode).distinct().collect(Collectors.toList()))) {
            EmployeeRegionQueryReqDto regionQueryReqDto = new EmployeeRegionQueryReqDto();
            regionQueryReqDto.setInstanceId(reqDto.getInstanceId());
            regionQueryReqDto.setMerchantId(reqDto.getOrganizationId());
            regionQueryReqDto.setRegionCodes(areaCodes);
            logger.info("\u5f00\u59cb\u5ba2\u6237\u533a\u57df\uff08\u5927B\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2\uff09\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)regionQueryReqDto));
            dtoList = (List)RestUtil.checkResponse((RestResponse)this.employeeRegionQueryApi.queryEmployeeRegionByCodes(regionQueryReqDto));
            logger.info("\u7ed3\u675f\u5ba2\u6237\u533a\u57df\uff08\u5927B\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2\uff09\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dtoList));
            if (CollectionUtils.isEmpty((Collection)dtoList)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List _ids = dtoList.stream().map(EmployeeRegionRespDto::getEmployeeId).collect(Collectors.toList());
            employeeIds.addAll(_ids);
        }
        if (CollectionUtils.isNotEmpty(employeeIds)) {
            reqDto.setIds(employeeIds);
        }
        PageInfo employeePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryByPage((EmployeeExtQueryReqDto)reqDto));
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)employeePage, (String[])new String[]{"list", "navigatepageNums"});
        List employeePageList = employeePage.getList();
        dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)employeePageList, EmployeeExpandRespDto.class);
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1) {
            this.fillCustomInfo(dtoList, orgId);
        } else {
            this.fillCustomerAndRegionNum(dtoList, reqDto.getOrganizationId(), reqDto.getInstanceId(), tenantId);
        }
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    public RestResponse<EmployeeExpandRespDto> queryById(EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        ArrayList<EmployeeExpandRespDto> respDtos = new ArrayList<EmployeeExpandRespDto>(1);
        EmployeeExtRespDto employeeExtRespDto = (EmployeeExtRespDto)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryById(reqDto));
        if (Objects.nonNull(employeeExtRespDto) && Objects.nonNull(employeeExtRespDto.getId())) {
            EmployeeExpandRespDto expandRespDto = new EmployeeExpandRespDto();
            CubeBeanUtils.copyProperties((Object)expandRespDto, (Object)employeeExtRespDto, (String[])new String[0]);
            respDtos.add(expandRespDto);
        }
        if (CollectionUtils.isNotEmpty(respDtos)) {
            this.fillCustomInfo(respDtos, Long.valueOf(organizationId));
            this.fillOrganizationInfo(respDtos);
            return new RestResponse(respDtos.get(0));
        }
        return new RestResponse();
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updateStatus(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotEmpty((Collection)reqDto.getIds(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aids]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getStatus(), (String)"\u72b6\u6001[\u5c5e\u6027\u540d\uff1astatus]\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.upateStatus(instanceId, reqDto));
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> setSuperAdmin(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aid]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getSuperAdmin(), (String)"\u662f\u5426\u8d85\u7ea7\u7ba1\u7406\u5458[0-\u5426\uff0c1-\u662f]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)reqDto.getEmployeeRoleDtoList(), (String)"\u89d2\u8272\u4fe1\u606f[\u5c5e\u6027\u540d\uff1aemployeeRoleDtoList]\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.setSuperAdmin(instanceId, reqDto));
        return RestResponse.VOID;
    }

    public RestResponse<ImportBaseResponse> importExcelEmployee(EmployeeImportReqDto importReqDto) {
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long instanceId = importReqDto.getInstanceId();
        String orgIdStr = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            orgIdStr = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        }
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        Long orgId = Long.valueOf(orgIdStr);
        ImportBaseResponse response = new ImportBaseResponse();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List<EmployeeExcelVo> importDataList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), EmployeeExcelVo.class, (ImportParams)importParams);
            if (ObjectUtils.isNotEmpty((Object)result)) {
                importDataList = result.getList();
                importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        if (CollectionUtils.isEmpty(importDataList)) {
            response.setTotalNum(0);
            response.setSuccessNum(0);
            response.setErrorNum(0);
            return new RestResponse((Object)response);
        }
        logger.info("\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(importDataList));
        response.setTotalNum(importDataList.size());
        List<String> roleNameList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getRoleName())).map(EmployeeExcelVo::getRoleName).distinct().collect(Collectors.toList());
        Map<String, List<RoleExpandRespDto>> roleMap = this.getRoleMap(roleNameList, null);
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = this.getCustomerAreaMap(roleNameList);
        List<String> accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getAccount())).map(EmployeeExcelVo::getAccount).distinct().collect(Collectors.toList());
        Map<String, List<UserOrgizationRespDto>> userOrgMap = this.getAccoutMap(accountList);
        importDataList = this.verifyData(importDataList, roleMap, customerAreasMap, userOrgMap, orgId);
        List<EmployeeExcelVo> successList = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        List<EmployeeExcelVo> employeeExcelVoList = this.mergeData(successList);
        Map<Object, Object> employeeInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(employeeExcelVoList)) {
            List userIdList = employeeExcelVoList.stream().map(EmployeeExcelVo::getUserId).collect(Collectors.toList());
            employeeInfoMap = this.getEmployeeMap(userIdList, Collections.singletonList(employeeExcelVoList.get(0).getOrgId()));
        }
        for (EmployeeExcelVo data2 : employeeExcelVoList) {
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data2.getOrgId());
            employeeExtReqDto.setOrgId(data2.getOrgId());
            employeeExtReqDto.setName(data2.getUserName());
            employeeExtReqDto.setPosition(data2.getPosition());
            employeeExtReqDto.setSex(data2.getSex());
            employeeExtReqDto.setStation(data2.getDepartment());
            employeeExtReqDto.setEmployeeNo(data2.getJobNumber());
            employeeExtReqDto.setPhoneNum(data2.getPhoneNumber());
            employeeExtReqDto.setEmployeeRoleDtoList(data2.getRoleList());
            employeeExtReqDto.setUserId(data2.getUserId());
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data2.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data2.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data2.getAreaList());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setType(Integer.valueOf(0));
            employeeExtReqDto.setStatus(Integer.valueOf(1));
            String key = data2.getOrgId() + "_" + data2.getUserId();
            try {
                if (!employeeInfoMap.isEmpty() && employeeInfoMap.containsKey(key)) {
                    Long id = (Long)employeeInfoMap.get(key);
                    employeeExtReqDto.setId(id);
                    logger.info("\u4fee\u6539\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                    this.modifyEmployee(instanceId, employeeExtReqDto);
                    continue;
                }
                logger.info("\u65b0\u589e\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.addEmployee(instanceId, employeeExtReqDto);
            }
            catch (Exception e) {
                logger.info("\u4eba\u5458\u5904\u7406\u6267\u884c\u5931\u8d25:{}", (Throwable)e);
                this.setErrorsMsg(importDataList, data2.getAccount(), "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        List errorList = importDataList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorList)) {
            response.setErrorNum(errorList.size());
            String excelName = "\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, EmployeeExcelVo.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                logger.info("\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f\u6587\u4ef6\u751f\u6210\u5931\u8d25");
                logger.info(e.getMessage(), (Throwable)e);
            }
        }
        response.setSuccessNum(response.getTotalNum() - response.getErrorNum());
        return new RestResponse((Object)response);
    }

    public List<EmployeeExcelVo> setErrorsMsg(List<EmployeeExcelVo> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorMsg()) && vo.getAccount().equals(account)) {
                vo.setErrorMsg(errorMsg);
            }
        });
        return list;
    }

    public List<EmployeeExcelVo> verifyData(List<EmployeeExcelVo> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<CustomerAreaRespDto>> areasMap, Map<String, List<UserOrgizationRespDto>> userOrgMap, Long orgId) {
        List<Object> codes = new ArrayList();
        for (EmployeeExcelVo vo : list) {
            if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount())) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
                continue;
            }
            List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
            List userOrgList = userOrgizationVos.stream().filter(e -> orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(userOrgList)) {
                vo.setErrorMsg("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                continue;
            }
            vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
            vo.setOrgId(orgId);
            if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                vo.setErrorMsg("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                vo.setErrorMsg("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) && !CommonUtil.checkPhoneNum(vo.getPhoneNumber())) {
                vo.setErrorMsg("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e;");
                continue;
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())) {
                    vo.setErrorMsg("\u89d2\u8272\u9519\u8bef");
                    continue;
                }
                List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && e.getBelongOrgId().compareTo(vo.getOrgId()) == 0 || e.getRoleType() == 1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgRoleList)) {
                    vo.setErrorMsg("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                vo.setRole(employeeRoleReqDto);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getGovernArea()})) {
                if (areasMap.isEmpty() || !areasMap.containsKey(vo.getGovernArea())) {
                    vo.setErrorMsg("\u7ba1\u7406\u533a\u57df\u9519\u8bef");
                    continue;
                }
                List<CustomerAreaRespDto> customerAreaRespDtos = areasMap.get(vo.getGovernArea());
                List orgAreaList = customerAreaRespDtos.stream().filter(e -> e.getOrgInfoId().compareTo(vo.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgAreaList)) {
                    vo.setErrorMsg("\u7ba1\u7406\u533a\u57df\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
                employeeRegionReqDto.setRegionCode(((CustomerAreaRespDto)orgAreaList.get(0)).getCode());
                employeeRegionReqDto.setStartTime(new Date());
                vo.setArea(employeeRegionReqDto);
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())) {
                codes.add(vo.getGovernCustomer());
            }
            if (!StringUtils.isNotEmpty((CharSequence)vo.getBlacklist())) continue;
            codes.add(vo.getBlacklist());
        }
        if (CollectionUtils.isNotEmpty(codes)) {
            codes = codes.stream().distinct().collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryCustomerListByCodes(codes));
            Map<Object, Object> customersMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                customersMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (key1, key2) -> key2));
            }
            for (EmployeeExcelVo vo : list) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getErrorMsg()})) continue;
                if (StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())) {
                    if (customersMap.isEmpty() || !customersMap.containsKey(vo.getGovernCustomer())) {
                        vo.setErrorMsg("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
                        continue;
                    }
                    CustomerRespDto customerRespDto = (CustomerRespDto)customersMap.get(vo.getGovernCustomer());
                    if (null == customerRespDto.getOrgInfoId() || customerRespDto.getMerchantId().compareTo(vo.getOrgId()) != 0) {
                        vo.setErrorMsg("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                        continue;
                    }
                    EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
                    employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
                    employeeCustomerReqDto.setStartTime(new Date());
                    vo.setCustomerDto(employeeCustomerReqDto);
                }
                if (!StringUtils.isNotEmpty((CharSequence)vo.getBlacklist())) continue;
                if (customersMap.isEmpty() || !customersMap.containsKey(vo.getBlacklist())) {
                    vo.setErrorMsg("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
                    continue;
                }
                CustomerRespDto customerBlacklistRespDto = (CustomerRespDto)customersMap.get(vo.getBlacklist());
                if (null == customerBlacklistRespDto.getOrgInfoId() || customerBlacklistRespDto.getMerchantId().compareTo(vo.getOrgId()) != 0) {
                    vo.setErrorMsg("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    continue;
                }
                EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
                customerBlacklistReqDto.setCustomerId(customerBlacklistRespDto.getId());
                customerBlacklistReqDto.setStartTime(new Date());
                vo.setCustomerBlackDto(customerBlacklistReqDto);
            }
        }
        return list;
    }

    private List<EmployeeExcelVo> mergeData(List<EmployeeExcelVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        Map<String, List<EmployeeExcelVo>> employeeGroupMap = list.stream().collect(Collectors.groupingBy(EmployeeExcelVo::getAccount));
        ArrayList resultVoList = Lists.newArrayList();
        for (String account : employeeGroupMap.keySet()) {
            List customerBlackList;
            List customerInfoList;
            List areaList;
            List<EmployeeExcelVo> employeeExcelVos = employeeGroupMap.get(account);
            EmployeeExcelVo vo = new EmployeeExcelVo();
            CubeBeanUtils.copyProperties((Object)vo, (Object)employeeExcelVos.get(0), (String[])new String[0]);
            List roleList = employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getRole())).map(EmployeeExcelVo::getRole).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRoleReqDto>(Comparator.comparing(EmployeeRoleReqDto::getRoleId))), ArrayList::new));
            if (CollectionUtils.isNotEmpty((Collection)roleList)) {
                vo.setRoleList(roleList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(areaList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getArea())).map(EmployeeExcelVo::getArea).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeRegionReqDto>(Comparator.comparing(EmployeeRegionReqDto::getRegionCode))), ArrayList::new))))) {
                vo.setAreaList(areaList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerInfoList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerDto())).map(EmployeeExcelVo::getCustomerDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerReqDto>(Comparator.comparing(EmployeeCustomerReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerInfoList(customerInfoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerBlackList = (List)employeeExcelVos.stream().filter(v -> Objects.nonNull(v.getCustomerBlackDto())).map(EmployeeExcelVo::getCustomerBlackDto).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmployeeCustomerBlacklistReqDto>(Comparator.comparing(EmployeeCustomerBlacklistReqDto::getCustomerId))), ArrayList::new))))) {
                vo.setCustomerBlackList(customerBlackList);
            }
            resultVoList.add(vo);
        }
        return resultVoList;
    }

    private void fillCustomInfo(List<EmployeeExpandRespDto> dtoList, Long merchantId) {
        List orgIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
            customerExtQuery.setMerchantId(merchantId);
            customerExtQuery.setOrgInfoIds(orgIdList);
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                return;
            }
            Map customerMap = customerRespDtos.stream().collect(Collectors.toMap(dto -> merchantId + "_" + dto.getOrgInfoId(), Function.identity()));
            for (EmployeeExtRespDto employeeExtRespDto : dtoList) {
                String key = merchantId + "_" + employeeExtRespDto.getOrganizationId();
                if (customerMap.isEmpty() || !customerMap.containsKey(key)) continue;
                CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(key);
                employeeExtRespDto.setCustomerName(customerRespDto.getName());
                employeeExtRespDto.setCustomerCode(customerRespDto.getCode());
            }
        }
    }

    private void fillCustomerCodeAndName(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (EmployeeExtRespDto employeeExtRespDto : dtoList) {
            if (Objects.isNull(employeeExtRespDto.getId())) continue;
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setInstanceId(employeeExtRespDto.getInstanceId());
            customerExtReqDto.setOrgInfoId(employeeExtRespDto.getOrganizationId());
            customerExtReqDto.setEmployeeIds(Arrays.asList(employeeExtRespDto.getId()));
            customerExtReqDto.setType(employeeExtRespDto.getType());
            List customerRespDtos = (List)RestUtil.checkResponse((RestResponse)this.employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            if (!CollectionUtils.isNotEmpty((Collection)customerRespDtos)) continue;
            EmployeeCustomerRespDto customerRespDto = (EmployeeCustomerRespDto)customerRespDtos.get(0);
            employeeExtRespDto.setCustomerName(customerRespDto.getCustomerName());
            employeeExtRespDto.setCustomerCode(customerRespDto.getCustomerCode());
        }
    }

    private void fillCustomerAndRegionNum(List<EmployeeExpandRespDto> dtoList, Long orgId, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List employeeIds = dtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeIds)) {
            return;
        }
        EmployeeNumCountReqDto reqDto = new EmployeeNumCountReqDto();
        reqDto.setEmployeeIds(employeeIds);
        reqDto.setOrgId(orgId);
        RestResponse response = this.employeeCustomerQueryApi.queryCountByEmployeeId(reqDto);
        if (Objects.nonNull(response) && "0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List list = (List)response.getData();
            for (EmployeeExpandRespDto dto : dtoList) {
                for (EmployeeNumCountRespDto countNumDto : list) {
                    if (!Objects.nonNull(dto) || !Objects.nonNull(dto.getId()) || !Objects.nonNull(countNumDto) || !Objects.nonNull(countNumDto.getEmployeeId()) || dto.getId().longValue() != countNumDto.getEmployeeId().longValue()) continue;
                    dto.setCustomerNum(countNumDto.getCustomerNum());
                    dto.setRegionNum(countNumDto.getRegionNum());
                }
            }
        }
    }

    private void fillOrganizationInfo(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List organizationIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).collect(Collectors.toList());
        OrgSellerCustomerQueryReqDto queryReqDto = new OrgSellerCustomerQueryReqDto();
        queryReqDto.setPageNum(1);
        queryReqDto.setPageSize(organizationIdList.size());
        queryReqDto.setMerchantIdList(organizationIdList);
        RestResponse orgSellerCustomerRest = this.orgSellerCustomerQueryApi.orgSellerCustomerPage(queryReqDto);
        Map<Object, Object> orgSellerMap = new HashMap();
        if (orgSellerCustomerRest != null && CollectionUtils.isNotEmpty((Collection)((PageInfo)orgSellerCustomerRest.getData()).getList())) {
            List orgSellerList = ((PageInfo)orgSellerCustomerRest.getData()).getList();
            orgSellerMap = orgSellerList.stream().collect(Collectors.toMap(OrgSellerCustomerRespDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeExpandRespDto respDto : dtoList) {
            if (orgSellerMap.isEmpty() || !orgSellerMap.containsKey(respDto.getOrganizationId())) continue;
            OrgSellerCustomerRespDto orgSellerCustomerRespDto = (OrgSellerCustomerRespDto)orgSellerMap.get(respDto.getOrganizationId());
            respDto.setOrganizationCode(orgSellerCustomerRespDto.getOrgCode());
            respDto.setOrganizationName(orgSellerCustomerRespDto.getOrgName());
            respDto.setSellerId(orgSellerCustomerRespDto.getSellerId());
            respDto.setSellerName(orgSellerCustomerRespDto.getSellerName());
            respDto.setSuperiorSellerName(orgSellerCustomerRespDto.getSuperiorSellerName());
            respDto.setDealerCode(orgSellerCustomerRespDto.getDealerCode());
        }
    }

    public void bindEmployeeCustomer(EmployeeExpandReqDto employeeDto) {
        logger.info("\u8fdb\u5165\u7ed1\u5b9a\u4eba\u5458\u5ba2\u6237");
        EmployeeCustomerAddReqDto bindCustomerDto = new EmployeeCustomerAddReqDto();
        bindCustomerDto.setEmployeeId(employeeDto.getId());
        bindCustomerDto.setUserId(employeeDto.getUserId());
        if (Objects.isNull(employeeDto.getUserId()) && StringUtils.isNotEmpty((CharSequence)employeeDto.getUserName())) {
            UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
            userQueryReqDto.setUserNames(Collections.singletonList(employeeDto.getUserName()));
            List userRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
            bindCustomerDto.setUserId(((UserRespDto)userRespDtos.get(0)).getId());
        }
        bindCustomerDto.setMerchantId(employeeDto.getOrganizationId());
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            bindCustomerDto.setMerchantId(employeeDto.getOrgId());
        }
        bindCustomerDto.setRegionInfoList(employeeDto.getRegionInfoList());
        bindCustomerDto.setCustomerInfoList(employeeDto.getCustomerInfoList());
        bindCustomerDto.setCustomerBlackList(employeeDto.getCustomerBlackList());
        this.employeeCustomerApi.saveEmployeeBindInfo(bindCustomerDto);
        logger.info("\u8fdb\u5165\u7ed1\u5b9a\u4eba\u5458\u5ba2\u6237\u7ed3\u675f");
    }

    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryPageByOrg(Long organizationId, Integer pageNum, Integer pageSize) {
        EmployeeExpandQueryReqDto queryReqDto = new EmployeeExpandQueryReqDto();
        queryReqDto.setPageNum(pageNum);
        queryReqDto.setPageSize(pageSize);
        queryReqDto.setOrganizationId(organizationId);
        return this.queryByPage(queryReqDto);
    }

    public RestResponse<List<Long>> getEmployeeOrgIdByUserId(Long userId) {
        return this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId);
    }

    public RestResponse<List<EmployeeExtRespDto>> queryByRole(Long roleId, Long instanceId) {
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        ServiceContext.getContext().setAttachment("yes.req.cus.b2b.organizationId", organizationId);
        return this.employeeExpandQueryApi.queryByRole(roleId, instanceId);
    }

    public RestResponse<List<OrganizationDto>> getOrgInfoByUserId(Long userId) {
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getOrgInfoByUserId(userId));
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            return new RestResponse();
        }
        List orgIdList = organizationDtos.stream().map(OrganizationDto::getId).collect(Collectors.toList());
        SellerExtQueryReqDto sellerExtQueryReqDto = new SellerExtQueryReqDto();
        sellerExtQueryReqDto.setOrgIdList(orgIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerExpandQueryApi.queryBatchSellerList(sellerExtQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)sellerRespDtos)) {
            return new RestResponse((Object)organizationDtos);
        }
        Map sellerOrgMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (k1, k2) -> k1));
        for (OrganizationDto organizationDto : organizationDtos) {
            if (sellerOrgMap.isEmpty() || !sellerOrgMap.containsKey(organizationDto.getId())) continue;
            SellerRespDto sellerRespDto = (SellerRespDto)sellerOrgMap.get(organizationDto.getId());
            organizationDto.setName(sellerRespDto.getName());
        }
        return new RestResponse((Object)organizationDtos);
    }

    public Map<String, List<RoleExpandRespDto>> getRoleMap(List<String> roleNameList, Long orgId) {
        if (CollectionUtils.isEmpty(roleNameList)) {
            return new HashMap<String, List<RoleExpandRespDto>>();
        }
        Map<String, List<RoleExpandRespDto>> roleMap = new HashMap<String, List<RoleExpandRespDto>>(roleNameList.size() * 4 / 3 + 2);
        RoleExpandReqDto roleExpandReqDto = new RoleExpandReqDto();
        roleExpandReqDto.setOrgId(orgId);
        roleExpandReqDto.setRoleNameList(roleNameList);
        List roleExpandRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.roleQueryApi.getRoleByNameList(roleExpandReqDto));
        if (CollectionUtils.isEmpty((Collection)roleExpandRespDtos)) {
            return roleMap;
        }
        roleMap = roleExpandRespDtos.stream().collect(Collectors.groupingBy(RoleRespDto::getName));
        return roleMap;
    }

    public Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return new HashMap<String, List<UserOrgizationRespDto>>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<String, List<UserOrgizationRespDto>>(accountList.size() * 4 / 3 + 2);
        List userOrgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if (CollectionUtils.isEmpty((Collection)userOrgInfoList)) {
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    public Map<String, List<CustomerAreaRespDto>> getCustomerAreaMap(List<String> governAreaList) {
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<String, List<CustomerAreaRespDto>>(governAreaList.size() * 4 / 3 + 2);
        if (CollectionUtils.isEmpty(governAreaList)) {
            return customerAreasMap;
        }
        CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
        areaListReqDto.setNameList(governAreaList);
        RestResponse areaRest = this.employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
        if (null == areaRest || CollectionUtils.isEmpty((Collection)((Collection)areaRest.getData()))) {
            return customerAreasMap;
        }
        List customerAreaList = (List)areaRest.getData();
        customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
        return customerAreasMap;
    }

    public Map<String, Long> getEmployeeMap(List<Long> userIdList, List<Long> orgIdList) {
        Map<String, Long> employeeInfoMap = new HashMap<String, Long>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return employeeInfoMap;
        }
        EmployeeExtQueryReqDto dto = new EmployeeExtQueryReqDto();
        dto.setOrganizationIdList(orgIdList);
        dto.setUserIds(userIdList);
        List employeeList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeByUserOrgList(dto));
        if (CollectionUtils.isNotEmpty((Collection)employeeList)) {
            employeeInfoMap = employeeList.stream().collect(Collectors.toMap(ee -> ee.getOrganizationId() + "_" + ee.getUserId(), BaseRespDto::getId));
        }
        return employeeInfoMap;
    }

    public Map<String, OrganizationDto> getOrgByNameMap(List<String> nameList) {
        if (CollectionUtils.isEmpty(nameList)) {
            return new HashMap<String, OrganizationDto>();
        }
        List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.orgInfoExtQueryApi.getOrgByNameList(nameList));
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return new HashMap<String, OrganizationDto>();
        }
        Map<String, OrganizationDto> organizationEoMap = dtoList.stream().collect(Collectors.toMap(OrganizationDto::getName, Function.identity(), (k1, k2) -> k1));
        return organizationEoMap;
    }
}

